/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.urlgroup;

import com.wily.introscope.agent.urlgroup.URLPattern;
import java.util.Map;
import java.util.StringTokenizer;

public class URLMatch {
    public static boolean isMatch(String path, Map params, URLPattern pattern) {
        return URLMatch.isMatch(path, params, pattern.getPath(), pattern.getParams());
    }

    public static boolean isMatch(String path, Map params, String pattern, Map paramPattern) {
        if (path.startsWith(pattern)) {
            if (path.length() == pattern.length()) {
                return URLMatch.checkParamMap(params, paramPattern);
            }
            if (path.charAt(pattern.length() - 1) == '/') {
                return URLMatch.checkParamMap(params, paramPattern);
            }
            if (path.charAt(pattern.length()) == '/') {
                return URLMatch.checkParamMap(params, paramPattern);
            }
        }
        if (pattern.indexOf(42) >= 0 && URLMatch.matchRegexpRule(pattern, path)) {
            return URLMatch.checkParamMap(params, paramPattern);
        }
        return false;
    }

    public static boolean matchRegexpRule(String exp, String source) {
        StringTokenizer strtok = new StringTokenizer(exp, "*", true);
        if (!strtok.hasMoreTokens()) {
            return false;
        }
        int j = 0;
        while (strtok.hasMoreTokens()) {
            String curtok = strtok.nextToken();
            if (curtok.equals("*")) {
                if (!strtok.hasMoreTokens()) {
                    return true;
                }
                String nexttok = strtok.nextToken();
                int nextindex = source.indexOf(nexttok, j);
                if (nextindex >= 0) {
                    j = nextindex + nexttok.length();
                    continue;
                }
                return false;
            }
            if (source.startsWith(curtok, j)) {
                j += curtok.length();
                continue;
            }
            return false;
        }
        return true;
    }

    private static boolean checkParamMap(Map params, Map paramPattern) {
        if (paramPattern == null) {
            return true;
        }
        if (params == null) {
            return false;
        }
        for (String patternName : paramPattern.keySet()) {
            String[] patternValues = (String[])paramPattern.get(patternName);
            if (patternValues == null) continue;
            String[] paramValues = (String[])params.get(patternName);
            if (paramValues == null) {
                return false;
            }
            int j = 0;
            while (j < patternValues.length) {
                String curPatternValue = patternValues[j];
                boolean foundValue = false;
                int i = 0;
                while (i < paramValues.length) {
                    if (paramValues[i].equals(curPatternValue)) {
                        foundValue = true;
                        break;
                    }
                    ++i;
                }
                if (!foundValue) {
                    return false;
                }
                ++j;
            }
        }
        return true;
    }
}

