/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.timeslice;

import com.wily.introscope.spec.metric.IncompatibleTypesException;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.timeslice.ANumericalTimeslicedValue;
import com.wily.wilyassert.Assertion;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;

public final class IntegerTimeslicedValue
extends ANumericalTimeslicedValue {
    public static final int kApproximateMemorySize = 64;
    private static final long serialVersionUID = -8895221953754867240L;
    private int fValue;
    private int fMinimum;
    private int fMaximum;

    public IntegerTimeslicedValue(int typeCookie, long startTimestamp, long stopTimestamp, BlameStackSnapshot blameStack, long dataPointCount, boolean dataIsAbsent, int value, int minimum, int maximum) {
        super(typeCookie, startTimestamp, stopTimestamp, blameStack, dataPointCount, dataIsAbsent);
        Assertion.wilyAssert(false);
        this.fValue = value;
        this.fMinimum = minimum <= value ? minimum : value;
        this.fMaximum = maximum >= value ? maximum : value;
    }

    public IntegerTimeslicedValue(int typeCookie, long startTimestamp, long stopTimestamp, BlameStackSnapshot blameStack, long dataPointCount, int value, int minimum, int maximum) {
        super(typeCookie, startTimestamp, stopTimestamp, blameStack, dataPointCount, false);
        Assertion.wilyAssert(false);
        this.fValue = value;
        this.fMinimum = minimum <= value ? minimum : value;
        this.fMaximum = maximum >= value ? maximum : value;
    }

    public IntegerTimeslicedValue(int typeCookie, long startTimestamp, long stopTimestamp, BlameStackSnapshot blameStack, int value) {
        this(typeCookie, startTimestamp, stopTimestamp, blameStack, 1L, false, value, value, value);
    }

    public IntegerTimeslicedValue(int typeCookie, long startTimestamp, long stopTimestamp, BlameStackSnapshot blameStack, int value, long dataPointCount) {
        this(typeCookie, startTimestamp, stopTimestamp, blameStack, dataPointCount, false, value, value, value);
    }

    public IntegerTimeslicedValue(int typeCookie, long startTimestamp, long stopTimestamp, BlameStackSnapshot blameStack, boolean dataIsAbsent) {
        this(typeCookie, startTimestamp, stopTimestamp, blameStack, 0L, dataIsAbsent, 0, 0, 0);
    }

    public IntegerTimeslicedValue(DataInputStream inputStream, BlameStackSnapshot blameStack) throws IOException {
        this.readExternalData(inputStream, blameStack);
        Assertion.wilyAssert(false);
    }

    public IntegerTimeslicedValue() {
    }

    public String getValueAsString() {
        return Integer.toString(this.getValue());
    }

    protected double doGetNumericalValueAsDouble(double defaultValue) {
        return this.getValue();
    }

    protected double doGetNumericalMaxAsDouble(double defaultValue) {
        return this.getMaximum();
    }

    protected double doGetNumericalMinAsDouble(double defaultValue) {
        return this.getMinimum();
    }

    public final int getValue() {
        return this.fValue;
    }

    public final int getMinimum() {
        return this.fMinimum;
    }

    public final int getMaximum() {
        return this.fMaximum;
    }

    public final long getMinimumAsLong() {
        return this.fMinimum;
    }

    public long getValueAsLong() {
        return this.fValue;
    }

    public final long getMaximumAsLong() {
        return this.fMaximum;
    }

    public static IntegerTimeslicedValue checkedCast(IMetricDataValue abstractValue) throws IncompatibleTypesException {
        try {
            return (IntegerTimeslicedValue)abstractValue;
        }
        catch (ClassCastException cce) {
            throw new IncompatibleTypesException("Failed to cast the object: " + abstractValue + " to an IntegerTimeslicedValue", cce);
        }
    }

    public Number getValueWrapper() {
        return new Integer(this.getValue());
    }

    public Number getMinimumWrapper() {
        return new Integer(this.getMinimum());
    }

    public Number getMaximumWrapper() {
        return new Integer(this.getMaximum());
    }

    public int hashCode() {
        return this.hashCodeDNA() ^ this.fValue;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IntegerTimeslicedValue)) {
            return false;
        }
        IntegerTimeslicedValue castTarget = (IntegerTimeslicedValue)o;
        if (!this.equalsDNA(castTarget)) {
            return false;
        }
        if (this.dataIsAbsent() && castTarget.dataIsAbsent()) {
            return true;
        }
        return this.getValue() == castTarget.getValue() && this.getMinimum() == castTarget.getMinimum() && this.getMaximum() == castTarget.getMaximum();
    }

    public String toString() {
        return "[" + super.toString() + "|val: " + this.fValue + ",min: " + this.fMinimum + ",max: " + this.fMaximum + "]";
    }

    protected void writeExternalData(DataOutput out) throws IOException {
        super.writeExternalData(out);
        out.writeInt(this.fValue);
        out.writeInt(this.fMinimum);
        out.writeInt(this.fMaximum);
    }

    protected void readExternalData(DataInput in, BlameStackSnapshot blameStack) throws IOException {
        super.readExternalData(in, blameStack);
        this.fValue = in.readInt();
        this.fMinimum = in.readInt();
        this.fMaximum = in.readInt();
    }
}

