/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub;

import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.messageprimitives.pipe.EndpointNotFoundException;
import com.wily.isengard.messageprimitives.service.MessageService;
import com.wily.isengard.messageprimitives.service.MessageServiceFactory;
import com.wily.isengard.ongoingquery.AQueryNotification;
import com.wily.isengard.ongoingquery.QuerySyntaxException;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.MailboxInUseException;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.postoffice.PostOfficeSpecifier;
import com.wily.isengard.registry.IRegistryService;
import com.wily.isengard.registry.RegistryEntry;
import com.wily.isengard.util.tree.DirectoryPath;
import com.wily.isengard.util.tree.DirectoryPathAndEntry;
import com.wily.isengard.util.tree.EntryAlreadyExistsException;
import com.wily.isengard.util.tree.EntryNotFoundException;
import com.wily.isengard.util.tree.InvalidPathException;
import com.wily.util.exception.UnexpectedExceptionError;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class ClonedRegistry
extends MessageService
implements IRegistryService {
    private IRegistryService fRegistry;
    private HashMap fRegistryCache;
    private volatile boolean fRealRegistryTransportDown = false;
    private final String fRealRegistryTransportDownMessage;
    static /* synthetic */ Class class$0;

    public ClonedRegistry(PostOffice po, Address realRegistry) throws MailboxInUseException {
        super(po, 1);
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.wily.isengard.registry.IRegistryService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.initialize(clazz, this);
        }
        catch (InvalidIsengardInterface e) {
            throw new UnexpectedExceptionError(e);
        }
        this.fRealRegistryTransportDownMessage = MessageFormat.format("Transport for the registry service at address: {0} is down", realRegistry);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.isengard.registry.IRegistryService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fRegistry = (IRegistryService)MessageServiceFactory.getService(po, (Class)clazz, realRegistry);
        this.fRegistryCache = new HashMap();
        this.cloneRegistry();
        this.allowAllGroupsToAccess();
    }

    private void cloneRegistry() {
        RegistryClone clone = new RegistryClone(this.getPostOffice(), this.fRegistryCache);
        try {
            this.fRegistry.registerOngoingQuery(".*", clone);
        }
        catch (Exception exception) {}
    }

    public DirectoryPathAndEntry[] queryEntries(String query) throws ConnectionException, QuerySyntaxException {
        if (!this.fRealRegistryTransportDown) {
            return this.fRegistry.queryEntries(query);
        }
        throw new ConnectionException(this.fRealRegistryTransportDownMessage);
    }

    public void registerOngoingQuery(String query, AQueryNotification notification) throws ConnectionException, QuerySyntaxException, EndpointNotFoundException {
        if (this.fRealRegistryTransportDown) {
            throw new ConnectionException(this.fRealRegistryTransportDownMessage);
        }
        this.fRegistry.registerOngoingQuery(query, notification);
    }

    public void addEntry(PostOfficeSpecifier postOffice, DirectoryPath path, RegistryEntry entry) throws ConnectionException, EntryAlreadyExistsException {
        if (this.fRealRegistryTransportDown) {
            throw new ConnectionException(this.fRealRegistryTransportDownMessage);
        }
        this.fRegistry.addEntry(postOffice, path, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistryEntry getEntry(DirectoryPath path) throws ConnectionException, InvalidPathException, EntryNotFoundException {
        HashMap hashMap = this.fRegistryCache;
        synchronized (hashMap) {
            RegistryEntry entry = (RegistryEntry)this.fRegistryCache.get(path.getPathString());
            if (entry != null) {
                return entry;
            }
        }
        if (!this.fRealRegistryTransportDown) {
            return this.fRegistry.getEntry(path);
        }
        throw new ConnectionException(this.fRealRegistryTransportDownMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEntry(DirectoryPath path) throws ConnectionException, InvalidPathException {
        HashMap hashMap = this.fRegistryCache;
        synchronized (hashMap) {
            this.fRegistryCache.remove(path.getPathString());
        }
        if (this.fRealRegistryTransportDown) {
            throw new ConnectionException(this.fRealRegistryTransportDownMessage);
        }
        this.fRegistry.deleteEntry(path);
    }

    public String[] getSubDirectories(DirectoryPath path) throws ConnectionException, InvalidPathException {
        if (!this.fRealRegistryTransportDown) {
            return this.fRegistry.getSubDirectories(path);
        }
        throw new ConnectionException(this.fRealRegistryTransportDownMessage);
    }

    public void setRealRegistryTransportDown() {
        this.fRealRegistryTransportDown = true;
    }

    private static class RegistryClone
    extends AQueryNotification {
        private static final long serialVersionUID = -8217805732943434375L;
        private HashMap fRegistryCache;

        public RegistryClone() {
        }

        public RegistryClone(PostOffice po, HashMap registryCache) {
            super(po);
            this.fRegistryCache = registryCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataAdded(Collection dataset) throws ConnectionException {
            HashMap hashMap = this.fRegistryCache;
            synchronized (hashMap) {
                Iterator i = dataset.iterator();
                while (i.hasNext()) {
                    DirectoryPathAndEntry entry = (DirectoryPathAndEntry)i.next();
                    String path = entry.getPath().getPathString();
                    this.fRegistryCache.put(path, entry.getEntry());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataRemoved(Collection dataset) throws ConnectionException {
            HashMap hashMap = this.fRegistryCache;
            synchronized (hashMap) {
                Iterator i = dataset.iterator();
                while (i.hasNext()) {
                    DirectoryPathAndEntry entry = (DirectoryPathAndEntry)i.next();
                    String path = entry.getPath().getPathString();
                    this.fRegistryCache.remove(path);
                }
            }
        }

        public void dataChanged(Collection dataset) throws ConnectionException {
            this.dataAdded(dataset);
        }

        public void initialMatchesFinished() throws ConnectionException {
        }

        public void noticeException(Exception e) throws ConnectionException {
        }
    }
}

