/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import com.wily.util.IComparer;
import java.lang.reflect.Array;

public class PriorityQueue {
    private static final int kAllocationIncrement = 5;
    private Object[] fQueue;
    private int fNumObjects;
    private final IComparer fComparer;

    public PriorityQueue(IComparer comparer) {
        this(comparer, 0);
    }

    public PriorityQueue(IComparer comparer, int initialSize) {
        this.fComparer = comparer;
        this.fQueue = new Object[initialSize + 2];
        this.fNumObjects = 0;
    }

    public void insert(Object obj) {
        ++this.fNumObjects;
        if (this.fNumObjects == this.fQueue.length - 1) {
            Object[] temp = new Object[this.fQueue.length + 5];
            System.arraycopy(this.fQueue, 0, temp, 0, this.fQueue.length);
            this.fQueue = temp;
        }
        this.fQueue[this.fNumObjects] = obj;
        this.balanceUp(this.fNumObjects);
    }

    public boolean remove(Object obj) {
        int index;
        boolean found = false;
        for (index = 1; index <= this.fNumObjects; ++index) {
            if (!this.fComparer.equalTo(this.fQueue[index], obj)) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        if (index == this.fNumObjects) {
            this.fQueue[this.fNumObjects] = null;
            --this.fNumObjects;
            return true;
        }
        this.fQueue[index] = this.fQueue[this.fNumObjects];
        this.fQueue[this.fNumObjects] = null;
        --this.fNumObjects;
        if (this.fComparer.lessThan(obj, this.fQueue[index])) {
            this.balanceDown(index);
        } else {
            this.balanceUp(index);
        }
        return true;
    }

    public boolean contains(Object potential) {
        if (potential == null) {
            return false;
        }
        for (int x = 1; x <= this.fNumObjects; ++x) {
            if (this.fQueue[x] == null || !potential.equals(this.fQueue[x])) continue;
            return true;
        }
        return false;
    }

    public Object dequeue() {
        if (this.isEmpty()) {
            return null;
        }
        Object temp = this.fQueue[1];
        this.fQueue[1] = this.fQueue[this.fNumObjects];
        this.fQueue[this.fNumObjects] = null;
        --this.fNumObjects;
        this.balanceDown(1);
        return temp;
    }

    public void rebalance() {
        this.balanceDown(1);
    }

    public boolean isEmpty() {
        return this.fNumObjects == 0;
    }

    public int getSize() {
        return this.fNumObjects;
    }

    public Object peek() {
        if (!this.isEmpty()) {
            return this.fQueue[1];
        }
        return null;
    }

    public Object[] toArray() {
        Object[] all = new Object[this.fNumObjects];
        System.arraycopy(this.fQueue, 1, all, 0, this.fNumObjects);
        return all;
    }

    public Object[] toArray(Object[] typedCandidateArray) {
        Object[] result = (Object[])Array.newInstance(typedCandidateArray.getClass().getComponentType(), this.fNumObjects);
        System.arraycopy(this.fQueue, 1, result, 0, this.fNumObjects);
        return result;
    }

    private void balanceUp(int location) {
        if (location == 1) {
            return;
        }
        if (this.fComparer.lessThan(this.fQueue[location], this.fQueue[location / 2])) {
            this.swap(location, location / 2);
            this.balanceUp(location / 2);
        }
    }

    private void balanceDown(int location) {
        if (location * 2 > this.fNumObjects) {
            return;
        }
        int compareTo = this.fQueue[location * 2 + 1] == null || this.fComparer.lessThan(this.fQueue[location * 2], this.fQueue[location * 2 + 1]) ? location * 2 : location * 2 + 1;
        if (this.fComparer.lessThan(this.fQueue[compareTo], this.fQueue[location])) {
            this.swap(compareTo, location);
            this.balanceDown(compareTo);
        }
    }

    private void swap(int x, int y) {
        Object temp = this.fQueue[x];
        this.fQueue[x] = this.fQueue[y];
        this.fQueue[y] = temp;
    }
}

