/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import com.wily.util.adt.IdentityHashSet;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class WeakWeakIdentityHashMap {
    private static final int kDefaultInitialCapacity = 11;
    private static final float kLoadFactor = 0.75f;
    private final ReferenceQueue fReferenceQueue;
    private Entry[] fTable;
    private int fCount;

    public WeakWeakIdentityHashMap() {
        this(11);
    }

    public WeakWeakIdentityHashMap(int initialCapacity) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("Capacity must be positive: " + initialCapacity);
        }
        this.fReferenceQueue = new ReferenceQueue();
        this.fTable = new Entry[initialCapacity];
        this.fCount = 0;
    }

    public int size() {
        this.purge();
        return this.fCount;
    }

    public Object get(Object key) {
        this.purge();
        if (key == null) {
            throw new NullPointerException();
        }
        int hashCode = System.identityHashCode(key);
        int index = (hashCode & Integer.MAX_VALUE) % this.fTable.length;
        Entry previous = null;
        Entry e = this.fTable[index];
        while (e != null) {
            if (e.keyEquals(key)) {
                Object result = e.fValue.get();
                if (result == null) {
                    if (previous == null) {
                        this.fTable[index] = e.fNext;
                    } else {
                        previous.fNext = e.fNext;
                    }
                    --this.fCount;
                }
                return result;
            }
            previous = e;
            e = e.fNext;
        }
        return null;
    }

    public Object put(Object key, Object value) {
        Entry newEntry;
        this.purge();
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        int hashCode = System.identityHashCode(key);
        int index = (hashCode & Integer.MAX_VALUE) % this.fTable.length;
        Entry e = this.fTable[index];
        while (e != null) {
            if (e.keyEquals(key)) {
                Object result = e.fValue.get();
                e.fValue = new WeakReference<Object>(value);
                return result;
            }
            e = e.fNext;
        }
        this.fTable[index] = newEntry = new Entry(hashCode, key, value, this.fTable[index], this.fReferenceQueue);
        ++this.fCount;
        if ((float)this.fCount > (float)this.fTable.length * 0.75f) {
            this.rehash();
        }
        return null;
    }

    public IdentityHashSet keySet() {
        this.purge();
        IdentityHashSet result = new IdentityHashSet();
        Entry e = null;
        int index = 0;
        while (index < this.fTable.length) {
            e = this.fTable[index];
            while (e != null) {
                Object o = e.get();
                if (o != null) {
                    result.add(o);
                }
                e = e.fNext;
            }
            ++index;
        }
        return result;
    }

    public Set entrySet() {
        this.purge();
        HashSet<Entry> result = new HashSet<Entry>();
        Entry e = null;
        int index = 0;
        while (index < this.fTable.length) {
            e = this.fTable[index];
            while (e != null) {
                Object o = e.get();
                if (o != null) {
                    result.add(e);
                }
                e = e.fNext;
            }
            ++index;
        }
        return result;
    }

    public Collection values() {
        this.purge();
        ArrayList<WeakReference> result = new ArrayList<WeakReference>(this.fCount);
        Entry e = null;
        int index = 0;
        while (index < this.fTable.length) {
            e = this.fTable[index];
            while (e != null) {
                result.add(e.fValue);
                e = e.fNext;
            }
            ++index;
        }
        return result;
    }

    public void clear() {
        int index = 0;
        while (index < this.fTable.length) {
            this.fTable[index] = null;
            ++index;
        }
        this.fCount = 0;
    }

    private void rehash() {
        Entry[] newTable = new Entry[this.fTable.length * 2 + 1];
        int i = 0;
        while (i < this.fTable.length) {
            Entry e = this.fTable[i];
            Entry nextE = null;
            while (e != null) {
                Entry newNext;
                nextE = e.fNext;
                int newIndex = (e.hashCode() & Integer.MAX_VALUE) % newTable.length;
                e.fNext = newNext = newTable[newIndex];
                newTable[newIndex] = e;
                e = nextE;
            }
            ++i;
        }
        this.fTable = newTable;
    }

    public Object remove(Object key) {
        this.purge();
        int hashCode = System.identityHashCode(key);
        int index = (hashCode & Integer.MAX_VALUE) % this.fTable.length;
        Entry previous = null;
        Entry e = this.fTable[index];
        while (e != null) {
            if (e.keyEquals(key)) {
                if (previous == null) {
                    this.fTable[index] = e.fNext;
                } else {
                    previous.fNext = e.fNext;
                }
                --this.fCount;
                return e.fValue.get();
            }
            previous = e;
            e = e.fNext;
        }
        return null;
    }

    private void purge() {
        Entry entry = (Entry)this.fReferenceQueue.poll();
        while (entry != null) {
            this.purge(entry);
            entry = (Entry)this.fReferenceQueue.poll();
        }
    }

    private void purge(Entry entry) {
        int hashCode = entry.hashCode();
        int index = (hashCode & Integer.MAX_VALUE) % this.fTable.length;
        Entry previous = null;
        Entry e = this.fTable[index];
        while (e != null) {
            if (e == entry) {
                if (previous == null) {
                    this.fTable[index] = e.fNext;
                } else {
                    previous.fNext = e.fNext;
                }
                --this.fCount;
                return;
            }
            previous = e;
            e = e.fNext;
        }
    }

    public final class Entry
    extends WeakReference
    implements Map.Entry {
        private final int fHashCode;
        WeakReference fValue;
        Entry fNext;

        Entry(int hashCode, Object key, Object value, Entry next, ReferenceQueue queue) {
            super(key, queue);
            this.fHashCode = hashCode;
            this.fValue = new WeakReference<Object>(value);
            this.fNext = next;
        }

        public int hashCode() {
            return this.fHashCode;
        }

        boolean keyEquals(Object key) {
            return this.get() == key;
        }

        public Object getKey() {
            return super.get();
        }

        public Object getValue() {
            return this.fValue;
        }

        public Object setValue(Object value) {
            return null;
        }
    }
}

