/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.connection;

import com.ca.apm.connection.LogWrapper;
import com.ca.apm.connection.WaitDelayStrategy;
import com.ca.apm.connection.location.ServerLocationProvider;
import com.ca.apm.connection.location.SingleLocationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConnectionLooper<T>
implements Runnable {
    private final String name;
    protected final ServerLocationProvider<T> locationProvider;
    protected final WaitDelayStrategy delayStrategy;
    protected final LogWrapper logger;
    private final Object lock = new Object();
    private volatile boolean started = false;
    private volatile boolean connectionAlive = false;
    private volatile boolean canRun = true;
    private Thread worker;

    public ConnectionLooper(String name, LogWrapper logger, ServerLocationProvider<T> locationProvider, WaitDelayStrategy delayStrategy) {
        ConnectionLooper.verifyNotNull(name, "name");
        ConnectionLooper.verifyNotNull(logger, "logger");
        ConnectionLooper.verifyNotNull(locationProvider, "locationProvider");
        ConnectionLooper.verifyNotNull(delayStrategy, "delayStrategy");
        this.name = String.valueOf(name) + " connection thread";
        this.logger = logger;
        this.locationProvider = locationProvider;
        this.delayStrategy = delayStrategy;
    }

    public ConnectionLooper(String name, LogWrapper logger, T singleLocation, WaitDelayStrategy delayStrategy) {
        this(name, logger, new SingleLocationProvider<T>(singleLocation), delayStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.info("Starting " + this.name + ". Initializing");
        this.initialize();
        while (this.canRun) {
            try {
                this.connectionAlive = false;
                this.logger.info("Attempting connection");
                long start = System.currentTimeMillis();
                if (this.connect()) {
                    this.logger.info("Connection succeeded.");
                    this.onConnectionReady();
                    this.connectionAlive = true;
                    this.delayStrategy.resetDelay();
                    long elapsed = System.currentTimeMillis() - start;
                    this.logger.info("Connection established in " + elapsed + " ms.");
                }
            }
            catch (Exception e) {
                this.logger.error("Exception during connection activity. Connection not successful.", e);
                this.disconnect();
            }
            try {
                if (this.connectionAlive) {
                    Object e = this.lock;
                    synchronized (e) {
                        this.logger.info("Connection thread going to sleep");
                        this.lock.wait();
                        this.logger.info("Connection thread is now awake");
                        continue;
                    }
                }
                long nextDelay = this.delayStrategy.getNextDelayInMillis();
                Object object = this.lock;
                synchronized (object) {
                    this.logger.info("Connection was not successful. Will wait for " + nextDelay + " ms before next attempt");
                    this.lock.wait(nextDelay);
                }
            }
            catch (InterruptedException interruptedException) {
                this.logger.info(String.valueOf(this.name) + " interrupted.");
                Thread.currentThread().interrupt();
            }
        }
    }

    public abstract void initialize();

    public abstract boolean connect();

    public abstract void disconnect();

    public abstract void onConnectionReady() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnectionInterrupted() {
        this.disconnect();
        this.connectionAlive = false;
        Object object = this.lock;
        synchronized (object) {
            this.logger.info("Notifying connection thread to wake up");
            this.lock.notify();
        }
    }

    public synchronized void start() {
        if (this.started) {
            throw new IllegalStateException("Connection looper already started");
        }
        this.canRun = true;
        this.worker = new Thread((Runnable)this, this.name);
        this.worker.start();
        this.started = true;
    }

    public synchronized void stop() {
        if (!this.started) {
            throw new IllegalStateException(String.valueOf(this.name) + " connection thread is not started yet");
        }
        this.logger.info("Stopping " + this.name);
        this.canRun = false;
        this.disconnect();
        this.worker.interrupt();
        this.started = false;
    }

    public String getName() {
        return this.name;
    }

    private static void verifyNotNull(Object var, String name) {
        if (var == null) {
            throw new IllegalArgumentException(String.valueOf(name) + " cannot be null");
        }
    }

    public boolean isRunning() {
        return this.started;
    }

    public ServerLocationProvider getLocationProvider() {
        return this.locationProvider;
    }

    public WaitDelayStrategy getDelayStrategy() {
        return this.delayStrategy;
    }
}

