/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent;

import com.wily.wilyassert.Assertion;

public final class ReentrancyHandler {
    private static final int kMaximumSimultaneousThreadCount = 64;
    private Thread[] fThreadList = new Thread[64];
    private int fCursor = 0;

    public boolean allowsEntry(Thread current) {
        return this.findOrAdd(current);
    }

    public void leave(Thread current) {
        this.remove(current);
    }

    private synchronized boolean findOrAdd(Thread target) {
        if (this.find(target)) {
            return false;
        }
        return this.add(target);
    }

    private boolean find(Thread target) {
        int x = 0;
        while (x < this.fCursor) {
            if (this.fThreadList[x] == target) {
                return true;
            }
            ++x;
        }
        return false;
    }

    private boolean add(Thread target) {
        int x = 0;
        while (x < this.fCursor) {
            if (this.fThreadList[x] == null) {
                this.fThreadList[x] = target;
                return true;
            }
            ++x;
        }
        if (this.fCursor < 64) {
            this.fThreadList[this.fCursor++] = target;
            return true;
        }
        return false;
    }

    private synchronized void remove(Thread target) {
        int x = 0;
        while (x < this.fCursor) {
            if (this.fThreadList[x] == target) {
                this.fThreadList[x] = null;
                if (x == this.fCursor - 1) {
                    while (this.fCursor != 0 && this.fThreadList[this.fCursor - 1] == null) {
                        --this.fCursor;
                    }
                }
                return;
            }
            ++x;
        }
        Assertion.wilyAssert(false);
    }
}

