/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerRateDataAccumulator;
import com.wily.introscope.agent.trace.ABundledTracerFactory;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

public final class SummaryReceiveMethodResultRateTracer
extends ABundledTracerFactory
implements ITracer {
    private final ReentrancyLevel fReentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);

    public SummaryReceiveMethodResultRateTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected final IDataAccumulator createDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetIntegerRateDataAccumulator(formattedMetricName);
    }

    @Override
    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReentrancyLevel;
    }

    @Override
    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    @Override
    public final ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof DatagramChannel) {
            if (data.getInvocationParameterCount() == 1 && data.getInvocationParameterAsObject(0) instanceof ByteBuffer) {
                return this;
            }
            Assertion.wilyAssert("Instrumentation error: method parameter not a ByteBuffer");
        } else {
            Assertion.wilyAssert("Instrumentation error: instrumented object is not a DatagramChannel");
        }
        return null;
    }

    @Override
    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
        ByteBuffer b = (ByteBuffer)data.getInvocationParameterAsObject(0);
        data.put("startPosition", b.position());
    }

    @Override
    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (data.isSocketClamped()) {
            return;
        }
        IIntegerRateDataAccumulator rate = (IIntegerRateDataAccumulator)this.createDataAccumulator(this.getFormattedName());
        if (!rate.IDataAccumulator_isShutOff() && !data.hasInvocationThrownException()) {
            int startPosition = (Integer)data.get("startPosition");
            ByteBuffer b = (ByteBuffer)data.getInvocationParameterAsObject(0);
            int bytesRead = b.position() - startPosition;
            if (bytesRead > 0) {
                rate.IIntegerRateDataAccumulator_addBatchIncidents(bytesRead);
            }
        }
    }

    @Override
    public final void ITracerFactory_releaseTracer(int tracerIndex, ITracer tracer) {
    }
}

