/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.api;

import com.wily.isengard.IsengardException;
import com.wily.isengard.api.ServerInstanceLocator;
import com.wily.isengard.api.SocketFactoryUtils;
import com.wily.isengard.postofficehub.link.net.ISocketFactory;
import com.wily.isengard.util.parameter.CheckParameter;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IndexedProperties;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ServerInstanceLocatorPropertiesParser {
    public static final String kDefaultServerHostName = "localhost";
    public static final int kDefaultServerPort = 5001;
    public static final String kDefaultLocalHostName = "localhost";
    public static final int kDefaultLocalPort = 0;
    public static final String kDefaultSocketFactory;
    public static final String kEnabledCommunicationChannelProperty = "client.enabled.channel";
    public static final String kSocketFactoryPropertyPrefix = "client.socketfactory.";
    public static final String kServerHostNameProperty = "transport.tcp.host";
    public static final String kServerPortProperty = "transport.tcp.port";
    public static final String kSocketLocalHostNameProperty = "transport.tcp.local.ipaddress";
    public static final String kSocketLocalPortProperty = "transport.tcp.local.port";
    public static final String kSocketSendBufferSizeProperty = "transport.tcp.writeBufferSize";
    public static final String kSocketReceiveBufferSizeProperty = "transport.tcp.readBufferSize";
    public static final String kSocketCipherSuitesProperty = "transport.tcp.ciphersuites";
    public static final String kSocketCipherSuitesPropertyPrefix = "transport.tcp.ciphersuites.";
    public static final String kSocketProtocolsProperty = "transport.tcp.protocols";
    public static final String kSocketProtocolsPropertyPrefix = "transport.tcp.protocols.";
    public static final String kSocketTruststoreProperty = "transport.tcp.truststore";
    public static final String kSocketTruststorePropertyPrefix = "transport.tcp.truststore.";
    public static final String kSocketTrustPasswordProperty = "transport.tcp.trustpassword";
    public static final String kSocketTrustPasswordPropertyPrefix = "transport.tcp.trustpassword.";
    public static final String kSocketKeystoreProperty = "transport.tcp.keystore";
    public static final String kSocketKeystorePropertyPrefix = "transport.tcp.keystore.";
    public static final String kSocketKeyPasswordProperty = "transport.tcp.keypassword";
    public static final String kSocketKeyPasswordPropertyPrefix = "transport.tcp.keypassword.";
    public static final String kProxyHostProperty = "transport.http.proxy.host";
    public static final String kProxyPortProperty = "transport.http.proxy.port";
    public static final String kProxyUserNameProperty = "transport.http.proxy.username";
    public static final String kProxyPasswordProperty = "transport.http.proxy.password";
    public static final String kProxyRealmProperty = "transport.http.proxy.realm";
    public static final String kTryIPAddrProperty = "transport.http.tryIPAddr";
    public static final String kServerIdProperty = "client.current.serverId";
    private static final String kDefaultServerId = "";
    private static final String kReconnectChannel = "auto_reconnect";
    private ServerInstanceLocator fServerInstanceLocator;
    private String fServerId;
    private boolean fUseDefaultValues;
    private List fSocketFactoryClasses;
    private IModuleFeedbackChannel fFeedbackChannel;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.isengard.postofficehub.link.net.DefaultSocketFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        kDefaultSocketFactory = clazz.getName();
    }

    public ServerInstanceLocatorPropertiesParser(IndexedProperties properties, boolean useDefaultValues, List socketFactoryClasses, IModuleFeedbackChannel feedback) throws IsengardException {
        CheckParameter.notNull("Properties", properties);
        CheckParameter.notNull("Feedback Channel", feedback);
        this.fFeedbackChannel = feedback;
        this.fServerId = kDefaultServerId;
        this.fUseDefaultValues = useDefaultValues;
        this.fServerInstanceLocator = this.initializeServerInstanceLocator(properties);
    }

    public ServerInstanceLocatorPropertiesParser(IndexedProperties properties, boolean useDefaultValues, String serverId, List socketFactoryClasses, IModuleFeedbackChannel feedback) throws IsengardException {
        CheckParameter.notNull("Properties", properties);
        CheckParameter.notNull("Feedback Channel", feedback);
        CheckParameter.notEmptyString("Server Id", serverId);
        this.fFeedbackChannel = feedback;
        this.fServerId = serverId;
        this.fUseDefaultValues = useDefaultValues;
        this.fSocketFactoryClasses = socketFactoryClasses;
        this.fServerInstanceLocator = this.initializeServerInstanceLocator(properties);
    }

    public ServerInstanceLocator getServerInstanceLocator() {
        return this.fServerInstanceLocator;
    }

    public static void setServerHostNameProperty(IndexedProperties properties, String hostName) {
        CheckParameter.notNull("Properties", properties);
        CheckParameter.notNull("Server Host Name", hostName);
        properties.put(kServerHostNameProperty, hostName);
    }

    public static void setServerPortProperty(IndexedProperties properties, int port) {
        CheckParameter.notNull("Properties", properties);
        properties.put(kServerPortProperty, String.valueOf(port));
    }

    public static void setSocketFactoryProperty(IndexedProperties properties, String className) {
        CheckParameter.notNull("Properties", properties);
        CheckParameter.notNull("Socket Factory Class Name", className);
        properties.put(kEnabledCommunicationChannelProperty, kReconnectChannel);
        properties.put("client.socketfactory.auto_reconnect", className);
    }

    private ServerInstanceLocator initializeServerInstanceLocator(IndexedProperties properties) throws IsengardException {
        String enabledChannel = this.initializeEnabledChannel(properties);
        ISocketFactory factory = this.initializeSocketFactory(properties, enabledChannel);
        String hostName = this.initializeServerHostName(properties);
        int port = this.initializeServerPort(properties, factory);
        ServerInstanceLocator locator = null;
        try {
            locator = new ServerInstanceLocator(hostName, port, factory);
        }
        catch (Exception e) {
            throw new IsengardException("Failed to create server instance locator.", e);
        }
        locator.setSocketCreationProperties(properties);
        this.initializeSocketLocalHostName(properties, locator);
        this.initializeSocketLocalPort(properties, locator);
        this.initializeSocketSendBufferSize(properties, locator);
        this.initializeSocketReceiveBufferSize(properties, locator);
        this.initializeTryIPAddressFlag(properties, locator);
        return locator;
    }

    private String initializeEnabledChannel(Properties properties) throws IsengardException {
        String propertyKey = this.appendServerIdToPropertyKey(kEnabledCommunicationChannelProperty);
        String enabledChannel = StringUtils.trim(properties.getProperty(propertyKey));
        if (enabledChannel == null && !this.usingDefaultValues()) {
            throw new IsengardException("Invalid value for '" + propertyKey + "' property: " + enabledChannel);
        }
        return enabledChannel;
    }

    private String initializeServerHostName(Properties properties) throws IsengardException {
        String propertyKey = this.appendServerIdToPropertyKey(kServerHostNameProperty);
        String serverHostName = StringUtils.trim(properties.getProperty(propertyKey));
        if (serverHostName == null) {
            if (this.usingDefaultValues()) {
                serverHostName = "localhost";
            } else {
                throw new IsengardException("Invalid value for '" + propertyKey + "' property: " + serverHostName);
            }
        }
        return serverHostName;
    }

    private int initializeServerPort(Properties properties, ISocketFactory factory) throws IsengardException {
        String propertyKey = this.appendServerIdToPropertyKey(kServerPortProperty);
        String serverPort = StringUtils.trim(properties.getProperty(propertyKey));
        int port = 0;
        if (serverPort == null && this.usingDefaultValues()) {
            port = factory.getPort();
        } else {
            try {
                port = Integer.parseInt(serverPort);
            }
            catch (Exception e) {
                throw new IsengardException("Invalid value for '" + propertyKey + "' property: " + serverPort, e);
            }
        }
        return port;
    }

    private ISocketFactory initializeSocketFactory(IndexedProperties properties, String channel) throws IsengardException {
        ISocketFactory iSocketFactory;
        new IndexedProperties((Map)properties);
        if (this.fFeedbackChannel.isDebugEnabled()) {
            this.fFeedbackChannel.debug("Creating socket factory for " + channel);
        }
        String propertyKey = this.appendServerIdToPropertyKey(kSocketFactoryPropertyPrefix);
        String factoryClassName = StringUtils.trim(properties.getNamedProperty(propertyKey, channel));
        try {
            properties.setProperty(kServerIdProperty, this.getServerId());
            Class factoryClass = this.getSocketFactoryClass(factoryClassName);
            iSocketFactory = (ISocketFactory)SocketFactoryUtils.createSocketFactory(factoryClass, properties, this.fFeedbackChannel);
            Object var6_8 = null;
        }
        catch (Exception e) {
            try {
                this.fFeedbackChannel.debug("Failed to create socket factory.", e);
                throw new IsengardException("Exception creating socket factory for '" + propertyKey + channel + "' property: " + factoryClassName + ": " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                properties.remove(kServerIdProperty);
                throw throwable;
            }
        }
        properties.remove(kServerIdProperty);
        return iSocketFactory;
    }

    private Class getSocketFactoryClass(String factoryClassName) throws ClassNotFoundException {
        if (factoryClassName == null) {
            if (this.usingDefaultValues()) {
                return Class.forName(kDefaultSocketFactory);
            }
            return null;
        }
        if (this.fSocketFactoryClasses != null) {
            Iterator it = this.fSocketFactoryClasses.iterator();
            while (it.hasNext()) {
                Class clazz = (Class)it.next();
                if (!clazz.getName().equals(factoryClassName)) continue;
                return clazz;
            }
        }
        return Class.forName(factoryClassName);
    }

    private void initializeSocketLocalHostName(Properties properties, ServerInstanceLocator locator) throws IsengardException {
        String propertyKey = this.appendServerIdToPropertyKey(kSocketLocalHostNameProperty);
        String hostName = StringUtils.trim(properties.getProperty(propertyKey));
        if (hostName == null) {
            if (this.usingDefaultValues()) {
                locator.setLocalHostName("localhost");
            }
        } else {
            try {
                locator.setLocalHostName(hostName);
            }
            catch (Exception e) {
                throw new IsengardException("Invalid value for '" + propertyKey + "' property: " + hostName, e);
            }
        }
    }

    private void initializeSocketLocalPort(Properties properties, ServerInstanceLocator locator) throws IsengardException {
        String propertyKey = this.appendServerIdToPropertyKey(kSocketLocalPortProperty);
        String localPort = StringUtils.trim(properties.getProperty(propertyKey));
        if (localPort == null) {
            if (this.usingDefaultValues()) {
                locator.setLocalPort(0);
            }
        } else {
            try {
                locator.setLocalPort(Integer.parseInt(localPort));
            }
            catch (Exception e) {
                throw new IsengardException("Invalid value for '" + propertyKey + "' property: " + localPort, e);
            }
        }
    }

    private void initializeSocketSendBufferSize(Properties properties, ServerInstanceLocator locator) throws IsengardException {
        String propertyKey = this.appendServerIdToPropertyKey(kSocketSendBufferSizeProperty);
        String bufferSize = StringUtils.trim(properties.getProperty(propertyKey));
        if (bufferSize != null) {
            try {
                locator.setSocketSendBufferSize(Integer.parseInt(bufferSize));
            }
            catch (Exception e) {
                throw new IsengardException("Invalid value for '" + propertyKey + "' property: " + bufferSize, e);
            }
        }
    }

    private void initializeSocketReceiveBufferSize(Properties properties, ServerInstanceLocator locator) throws IsengardException {
        String propertyKey = this.appendServerIdToPropertyKey(kSocketReceiveBufferSizeProperty);
        String bufferSize = StringUtils.trim(properties.getProperty(propertyKey));
        if (bufferSize != null) {
            try {
                locator.setSocketReceiveBufferSize(Integer.parseInt(bufferSize));
            }
            catch (Exception e) {
                throw new IsengardException("Invalid value for '" + propertyKey + "' property: " + bufferSize, e);
            }
        }
    }

    private void initializeTryIPAddressFlag(IndexedProperties properties, ServerInstanceLocator locator) {
        String propertyKey = kTryIPAddrProperty;
        boolean tryIPAddress = properties.getBooleanProperty(propertyKey, true);
        locator.setTryIPAddressFlag(tryIPAddress);
    }

    private String getServerId() {
        return this.fServerId;
    }

    private boolean usingDefaultValues() {
        return this.fUseDefaultValues;
    }

    private String appendServerIdToPropertyKey(String propertyKey) {
        String propertyKeyWithServerId = null;
        propertyKeyWithServerId = this.getServerId().equals(kDefaultServerId) ? propertyKey : (propertyKey.endsWith(".") ? String.valueOf(propertyKey) + this.getServerId() + "." : String.valueOf(propertyKey) + "." + this.getServerId());
        return propertyKeyWithServerId;
    }
}

