/*
 * Decompiled with CFR 0.152.
 */
package com.wily.org.apache.commons.io.filefilter;

import com.wily.org.apache.commons.io.FilenameUtils;
import com.wily.org.apache.commons.io.filefilter.AbstractFileFilter;
import java.io.File;
import java.util.List;

public class WildcardFilter
extends AbstractFileFilter {
    private String[] wildcards = null;

    public WildcardFilter(String wildcard) {
        if (wildcard == null) {
            throw new IllegalArgumentException();
        }
        this.wildcards = new String[]{wildcard};
    }

    public WildcardFilter(String[] wildcards) {
        if (wildcards == null) {
            throw new IllegalArgumentException();
        }
        this.wildcards = wildcards;
    }

    public WildcardFilter(List wildcards) {
        if (wildcards == null) {
            throw new IllegalArgumentException();
        }
        this.wildcards = wildcards.toArray(new String[wildcards.size()]);
    }

    public boolean accept(File dir, String name) {
        if (dir != null && new File(dir, name).isDirectory()) {
            return false;
        }
        int i = 0;
        while (i < this.wildcards.length) {
            if (FilenameUtils.wildcardMatch(name, this.wildcards[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return false;
        }
        int i = 0;
        while (i < this.wildcards.length) {
            if (FilenameUtils.wildcardMatch(file.getName(), this.wildcards[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

