/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.file;

import com.wily.rave.agent.ds.file.fileSpec.AFileSpec;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class FileCacheEntry
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private AFileSpec fFileS;
    private long fLength;
    private long fLastModified;
    private byte[] fDigest;

    public FileCacheEntry() {
    }

    public FileCacheEntry(AFileSpec fileS, long fileLength, long lastModified) {
        this.fFileS = fileS;
        this.fLength = fileLength;
        this.fLastModified = lastModified;
    }

    public FileCacheEntry(AFileSpec fileS, long fileLength, long lastModified, byte[] digest) {
        this.fFileS = fileS;
        this.fLength = fileLength;
        this.fLastModified = lastModified;
        this.fDigest = digest;
    }

    public long getLength() {
        return this.fLength;
    }

    public long getLastModified() {
        return this.fLastModified;
    }

    public boolean hasDigest() {
        return this.fDigest != null && this.fDigest.length != 0;
    }

    public byte[] getDigest() {
        return this.fDigest;
    }

    public AFileSpec getFileS() {
        return this.fFileS;
    }

    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        this.fFileS = (AFileSpec)oi.readObject();
        this.fLength = oi.readLong();
        this.fLastModified = oi.readLong();
        Object object = oi.readObject();
        int digestBytes = (Integer)object;
        if (digestBytes == 0) {
            this.fDigest = null;
        } else {
            this.fDigest = new byte[digestBytes];
            oi.readFully(this.fDigest);
        }
    }

    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeObject(this.fFileS);
        oo.writeLong(this.fLength);
        oo.writeLong(this.fLastModified);
        oo.writeObject(this.fDigest != null ? new Integer(this.fDigest.length) : new Integer(0));
        if (this.fDigest != null) {
            oo.write(this.fDigest);
        }
    }
}

