/*
 * Decompiled with CFR 0.152.
 */
package com.wily.EDU.oswego.cs.dl.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class CopyOnWriteArrayList
implements List,
Cloneable,
Serializable {
    protected transient Object[] array_;

    protected synchronized Object[] array() {
        return this.array_;
    }

    public CopyOnWriteArrayList() {
        this.array_ = new Object[0];
    }

    public CopyOnWriteArrayList(Collection c) {
        this.array_ = new Object[c.size()];
        Iterator i = c.iterator();
        int size = 0;
        while (i.hasNext()) {
            this.array_[size++] = i.next();
        }
    }

    public CopyOnWriteArrayList(Object[] toCopyIn) {
        this.copyIn(toCopyIn, 0, toCopyIn.length);
    }

    public synchronized void copyIn(Object[] toCopyIn, int first, int n) {
        this.array_ = new Object[n];
        System.arraycopy(toCopyIn, first, this.array_, 0, n);
    }

    public int size() {
        return this.array().length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object elem) {
        int len;
        Object[] elementData = this.array();
        return CopyOnWriteArrayList.indexOf(elem, elementData, len = elementData.length) >= 0;
    }

    public int indexOf(Object elem) {
        Object[] elementData = this.array();
        int len = elementData.length;
        return CopyOnWriteArrayList.indexOf(elem, elementData, len);
    }

    protected static int indexOf(Object elem, Object[] elementData, int len) {
        if (elem == null) {
            int i = 0;
            while (i < len) {
                if (elementData[i] == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                if (elem.equals(elementData[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int indexOf(Object elem, int index) {
        Object[] elementData = this.array();
        int elementCount = elementData.length;
        if (elem == null) {
            int i = index;
            while (i < elementCount) {
                if (elementData[i] == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = index;
            while (i < elementCount) {
                if (elem.equals(elementData[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object elem) {
        Object[] elementData = this.array();
        int len = elementData.length;
        return CopyOnWriteArrayList.lastIndexOf(elem, elementData, len);
    }

    protected static int lastIndexOf(Object elem, Object[] elementData, int len) {
        if (elem == null) {
            int i = len - 1;
            while (i >= 0) {
                if (elementData[i] == null) {
                    return i;
                }
                --i;
            }
        } else {
            int i = len - 1;
            while (i >= 0) {
                if (elem.equals(elementData[i])) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object elem, int index) {
        Object[] elementData = this.array();
        if (elem == null) {
            int i = index;
            while (i >= 0) {
                if (elementData[i] == null) {
                    return i;
                }
                --i;
            }
        } else {
            int i = index;
            while (i >= 0) {
                if (elem.equals(elementData[i])) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            Object[] elementData = this.array();
            CopyOnWriteArrayList v = (CopyOnWriteArrayList)super.clone();
            v.array_ = new Object[elementData.length];
            System.arraycopy(elementData, 0, v.array_, 0, elementData.length);
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Object[] toArray() {
        Object[] elementData = this.array();
        Object[] result = new Object[elementData.length];
        System.arraycopy(elementData, 0, result, 0, elementData.length);
        return result;
    }

    public Object[] toArray(Object[] a) {
        Object[] elementData = this.array();
        if (a.length < elementData.length) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), elementData.length);
        }
        System.arraycopy(elementData, 0, a, 0, elementData.length);
        if (a.length > elementData.length) {
            a[elementData.length] = null;
        }
        return a;
    }

    public Object get(int index) {
        Object[] elementData = this.array();
        this.rangeCheck(index, elementData.length);
        return elementData[index];
    }

    public synchronized Object set(int index, Object element) {
        boolean same;
        int len = this.array_.length;
        this.rangeCheck(index, len);
        Object oldValue = this.array_[index];
        boolean bl = same = oldValue == element || element != null && element.equals(oldValue);
        if (!same) {
            Object[] newArray = new Object[len];
            System.arraycopy(this.array_, 0, newArray, 0, len);
            newArray[index] = element;
            this.array_ = newArray;
        }
        return oldValue;
    }

    public synchronized boolean add(Object element) {
        int len = this.array_.length;
        Object[] newArray = new Object[len + 1];
        System.arraycopy(this.array_, 0, newArray, 0, len);
        newArray[len] = element;
        this.array_ = newArray;
        return true;
    }

    public synchronized void add(int index, Object element) {
        int len = this.array_.length;
        if (index > len || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + len);
        }
        Object[] newArray = new Object[len + 1];
        System.arraycopy(this.array_, 0, newArray, 0, index);
        newArray[index] = element;
        System.arraycopy(this.array_, index, newArray, index + 1, len - index);
        this.array_ = newArray;
    }

    public synchronized Object remove(int index) {
        int len = this.array_.length;
        this.rangeCheck(index, len);
        Object oldValue = this.array_[index];
        Object[] newArray = new Object[len - 1];
        System.arraycopy(this.array_, 0, newArray, 0, index);
        int numMoved = len - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.array_, index + 1, newArray, index, numMoved);
        }
        this.array_ = newArray;
        return oldValue;
    }

    public synchronized boolean remove(Object element) {
        int len = this.array_.length;
        if (len == 0) {
            return false;
        }
        int newlen = len - 1;
        Object[] newArray = new Object[newlen];
        int i = 0;
        while (i < newlen) {
            if (element == this.array_[i] || element != null && element.equals(this.array_[i])) {
                int k = i + 1;
                while (k < len) {
                    newArray[k - 1] = this.array_[k];
                    ++k;
                }
                this.array_ = newArray;
                return true;
            }
            newArray[i] = this.array_[i];
            ++i;
        }
        if (element == this.array_[newlen] || element != null && element.equals(this.array_[newlen])) {
            this.array_ = newArray;
            return true;
        }
        return false;
    }

    public synchronized void removeRange(int fromIndex, int toIndex) {
        int len = this.array_.length;
        if (fromIndex < 0 || fromIndex >= len || toIndex > len || toIndex < fromIndex) {
            throw new IndexOutOfBoundsException();
        }
        int numMoved = len - toIndex;
        int newlen = len - (toIndex - fromIndex);
        Object[] newArray = new Object[newlen];
        System.arraycopy(this.array_, 0, newArray, 0, fromIndex);
        System.arraycopy(this.array_, toIndex, newArray, fromIndex, numMoved);
        this.array_ = newArray;
    }

    public synchronized boolean addIfAbsent(Object element) {
        int len = this.array_.length;
        Object[] newArray = new Object[len + 1];
        int i = 0;
        while (i < len) {
            if (element == this.array_[i] || element != null && element.equals(this.array_[i])) {
                return false;
            }
            newArray[i] = this.array_[i];
            ++i;
        }
        newArray[len] = element;
        this.array_ = newArray;
        return true;
    }

    public boolean containsAll(Collection c) {
        Object[] elementData = this.array();
        int len = elementData.length;
        Iterator e = c.iterator();
        while (e.hasNext()) {
            if (CopyOnWriteArrayList.indexOf(e.next(), elementData, len) >= 0) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean removeAll(Collection c) {
        Object[] elementData = this.array_;
        int len = elementData.length;
        if (len == 0) {
            return false;
        }
        Object[] temp = new Object[len];
        int newlen = 0;
        int i = 0;
        while (i < len) {
            Object element = elementData[i];
            if (!c.contains(element)) {
                temp[newlen++] = element;
            }
            ++i;
        }
        if (newlen == len) {
            return false;
        }
        Object[] newArray = new Object[newlen];
        System.arraycopy(temp, 0, newArray, 0, newlen);
        this.array_ = newArray;
        return true;
    }

    public synchronized boolean retainAll(Collection c) {
        Object[] elementData = this.array_;
        int len = elementData.length;
        if (len == 0) {
            return false;
        }
        Object[] temp = new Object[len];
        int newlen = 0;
        int i = 0;
        while (i < len) {
            Object element = elementData[i];
            if (c.contains(element)) {
                temp[newlen++] = element;
            }
            ++i;
        }
        if (newlen == len) {
            return false;
        }
        Object[] newArray = new Object[newlen];
        System.arraycopy(temp, 0, newArray, 0, newlen);
        this.array_ = newArray;
        return true;
    }

    public synchronized int addAllAbsent(Collection c) {
        int numNew = c.size();
        if (numNew == 0) {
            return 0;
        }
        Object[] elementData = this.array_;
        int len = elementData.length;
        Object[] temp = new Object[numNew];
        int added = 0;
        Iterator e = c.iterator();
        while (e.hasNext()) {
            Object element = e.next();
            if (CopyOnWriteArrayList.indexOf(element, elementData, len) >= 0 || CopyOnWriteArrayList.indexOf(element, temp, added) >= 0) continue;
            temp[added++] = element;
        }
        if (added == 0) {
            return 0;
        }
        Object[] newArray = new Object[len + added];
        System.arraycopy(elementData, 0, newArray, 0, len);
        System.arraycopy(temp, 0, newArray, len, added);
        this.array_ = newArray;
        return added;
    }

    public synchronized void clear() {
        this.array_ = new Object[0];
    }

    public synchronized boolean addAll(Collection c) {
        int numNew = c.size();
        if (numNew == 0) {
            return false;
        }
        int len = this.array_.length;
        Object[] newArray = new Object[len + numNew];
        System.arraycopy(this.array_, 0, newArray, 0, len);
        Iterator e = c.iterator();
        int i = 0;
        while (i < numNew) {
            newArray[len++] = e.next();
            ++i;
        }
        this.array_ = newArray;
        return true;
    }

    public synchronized boolean addAll(int index, Collection c) {
        int len = this.array_.length;
        if (index > len || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + len);
        }
        int numNew = c.size();
        if (numNew == 0) {
            return false;
        }
        Object[] newArray = new Object[len + numNew];
        System.arraycopy(this.array_, 0, newArray, 0, len);
        int numMoved = len - index;
        if (numMoved > 0) {
            System.arraycopy(this.array_, index, newArray, index + numNew, numMoved);
        }
        Iterator e = c.iterator();
        int i = 0;
        while (i < numNew) {
            newArray[index++] = e.next();
            ++i;
        }
        this.array_ = newArray;
        return true;
    }

    protected void rangeCheck(int index, int length) {
        if (index >= length || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + length);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Object[] elementData = this.array();
        s.writeInt(elementData.length);
        int i = 0;
        while (i < elementData.length) {
            s.writeObject(elementData[i]);
            ++i;
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int arrayLength = s.readInt();
        Object[] elementData = new Object[arrayLength];
        int i = 0;
        while (i < elementData.length) {
            elementData[i] = s.readObject();
            ++i;
        }
        this.array_ = elementData;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator e = this.iterator();
        buf.append("[");
        int maxIndex = this.size() - 1;
        int i = 0;
        while (i <= maxIndex) {
            buf.append(String.valueOf(e.next()));
            if (i < maxIndex) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l2 = (List)o;
        if (this.size() != l2.size()) {
            return false;
        }
        ListIterator e1 = this.listIterator();
        ListIterator e2 = l2.listIterator();
        while (e1.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    public Iterator iterator() {
        return new COWIterator(this.array(), 0);
    }

    public ListIterator listIterator() {
        return new COWIterator(this.array(), 0);
    }

    public ListIterator listIterator(int index) {
        Object[] elementData = this.array();
        int len = elementData.length;
        if (index < 0 || index > len) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new COWIterator(this.array(), index);
    }

    public synchronized List subList(int fromIndex, int toIndex) {
        int len = this.array_.length;
        if (fromIndex < 0 || toIndex > len || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        return new COWSubList(this, fromIndex, toIndex);
    }

    protected static class COWSubList
    extends AbstractList {
        protected final CopyOnWriteArrayList l;
        protected final int offset;
        protected int size;
        protected Object[] expectedArray;

        protected COWSubList(CopyOnWriteArrayList list, int fromIndex, int toIndex) {
            this.l = list;
            this.expectedArray = this.l.array();
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
        }

        protected void checkForComodification() {
            if (this.l.array_ != this.expectedArray) {
                throw new ConcurrentModificationException();
            }
        }

        protected void rangeCheck(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ",Size: " + this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int index, Object element) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(index);
                this.checkForComodification();
                Object x = this.l.set(index + this.offset, element);
                this.expectedArray = this.l.array_;
                return x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(int index) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(index);
                this.checkForComodification();
                return this.l.get(index + this.offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int index, Object element) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (index < 0 || index > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                this.l.add(index + this.offset, element);
                this.expectedArray = this.l.array_;
                ++this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int index) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(index);
                this.checkForComodification();
                Object result = this.l.remove(index + this.offset);
                this.expectedArray = this.l.array_;
                --this.size;
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator iterator() {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return new COWSubListIterator(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListIterator listIterator(int index) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (index < 0 || index > this.size) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
                }
                return new COWSubListIterator(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List subList(int fromIndex, int toIndex) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (fromIndex < 0 || toIndex > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                return new COWSubList(this.l, fromIndex + this.offset, toIndex + this.offset);
            }
        }

        protected class COWSubListIterator
        implements ListIterator {
            protected final ListIterator i;
            protected final int index;

            protected COWSubListIterator(int index) {
                this.index = index;
                this.i = COWSubList.this.l.listIterator(index + COWSubList.this.offset);
            }

            public boolean hasNext() {
                return this.nextIndex() < COWSubList.this.size;
            }

            public Object next() {
                if (this.hasNext()) {
                    return this.i.next();
                }
                throw new NoSuchElementException();
            }

            public boolean hasPrevious() {
                return this.previousIndex() >= 0;
            }

            public Object previous() {
                if (this.hasPrevious()) {
                    return this.i.previous();
                }
                throw new NoSuchElementException();
            }

            public int nextIndex() {
                return this.i.nextIndex() - COWSubList.this.offset;
            }

            public int previousIndex() {
                return this.i.previousIndex() - COWSubList.this.offset;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(Object o) {
                throw new UnsupportedOperationException();
            }

            public void add(Object o) {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected static class COWIterator
    implements ListIterator {
        protected final Object[] array;
        protected int cursor;

        protected COWIterator(Object[] elementArray, int initialCursor) {
            this.array = elementArray;
            this.cursor = initialCursor;
        }

        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        public Object next() {
            try {
                return this.array[this.cursor++];
            }
            catch (IndexOutOfBoundsException ex) {
                throw new NoSuchElementException();
            }
        }

        public Object previous() {
            try {
                return this.array[--this.cursor];
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public int nextIndex() {
            return this.cursor;
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

