/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.selection;

import com.wily.ui.action.IExtendedAction;
import com.wily.ui.selection.ASelectable;
import com.wily.ui.selection.SelectionEnumeration;
import com.wily.util.HashCodeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Selection {
    private Set fTopLevelSelectables;

    Selection(Set topLevelSelectables) {
        this.fTopLevelSelectables = topLevelSelectables;
    }

    public SelectionEnumeration selectionEnumeration() {
        return new SelectionEnumeration(this.fTopLevelSelectables);
    }

    public Set getTopLevelSelectables() {
        return new HashSet(this.fTopLevelSelectables);
    }

    public int selectableTypeCount(String selectableType, boolean recursive) {
        int count = 0;
        SelectionEnumeration se = this.selectionEnumeration();
        while (se.hasMoreElements()) {
            ASelectable selectable = (ASelectable)se.nextElement();
            if (selectable.getSelectableType().equals(selectableType)) {
                ++count;
            }
            if (!recursive) continue;
            count += selectable.getChildSelectables().selectableTypeCount(selectableType, true);
        }
        return count;
    }

    public ASelectable getFirstSelectableByType(String selectableType) {
        return this.getFirstSelectableByType(selectableType, true);
    }

    public ASelectable getFirstSelectableByType(String selectableType, boolean recursive) {
        SelectionEnumeration aSelectionEnumeration = this.selectionEnumeration();
        ASelectable targetSelectable = null;
        while (aSelectionEnumeration.hasMoreElements() && targetSelectable == null) {
            ASelectable candidateSelectable = aSelectionEnumeration.nextSelectable();
            if (candidateSelectable.getSelectableType().equals(selectableType)) {
                targetSelectable = candidateSelectable;
                continue;
            }
            if (!recursive) continue;
            targetSelectable = candidateSelectable.getChildSelectables().getFirstSelectableByType(selectableType, true);
        }
        return targetSelectable;
    }

    public boolean hasSelectableOfType(String selectableType, boolean recursive) {
        return this.getFirstSelectableByType(selectableType, recursive) != null;
    }

    public int selectionCount() {
        int count = 0;
        SelectionEnumeration se = this.selectionEnumeration();
        while (se.hasMoreElements()) {
            ++count;
            ASelectable selectable = (ASelectable)se.nextElement();
            if (selectable.getNumberChildren() <= 0) continue;
            count += selectable.getChildSelectables().selectionCount();
        }
        return count;
    }

    public int selectionCountTopLevel() {
        return this.fTopLevelSelectables.size();
    }

    public int selectionCountAllChildren() {
        int count = 0;
        SelectionEnumeration se = this.selectionEnumeration();
        while (se.hasMoreElements()) {
            ASelectable selectable = (ASelectable)se.nextElement();
            count += selectable.getChildSelectables().selectionCount();
        }
        return count;
    }

    public boolean atLeastOneSelectableHasProperty(String propertyKey) {
        SelectionEnumeration aSelectionEnumeration = this.selectionEnumeration();
        boolean hasProperty = false;
        while (aSelectionEnumeration.hasMoreElements() && !hasProperty) {
            ASelectable selectable = aSelectionEnumeration.nextSelectable();
            if (selectable.hasProperty(propertyKey)) {
                hasProperty = true;
                continue;
            }
            hasProperty = selectable.getChildSelectables().atLeastOneSelectableHasProperty(propertyKey);
        }
        return hasProperty;
    }

    public List getAllSelectables() {
        ArrayList selectables = new ArrayList();
        this.addAllSelectables(selectables);
        return selectables;
    }

    private void addAllSelectables(Collection selectables) {
        SelectionEnumeration aSelectionEnumeration = this.selectionEnumeration();
        while (aSelectionEnumeration.hasMoreElements()) {
            ASelectable selectable = aSelectionEnumeration.nextSelectable();
            selectables.add(selectable);
            selectable.getChildSelectables().addAllSelectables(selectables);
        }
    }

    public List getAllSelectablesOfType(String type) {
        ArrayList selectables = new ArrayList();
        if (type != null) {
            this.addAllSelectablesOfType(type, selectables);
        }
        return selectables;
    }

    private void addAllSelectablesOfType(String type, Collection selectables) {
        SelectionEnumeration aSelectionEnumeration = this.selectionEnumeration();
        while (aSelectionEnumeration.hasMoreElements()) {
            ASelectable selectable = aSelectionEnumeration.nextSelectable();
            if (type.equals(selectable.getSelectableType())) {
                selectables.add(selectable);
            }
            selectable.getChildSelectables().addAllSelectablesOfType(type, selectables);
        }
    }

    public List getAllSelectablesWithProperty(String propertyKey) {
        ArrayList selectables = new ArrayList();
        this.addAllSelectablesWithProperty(propertyKey, selectables);
        return selectables;
    }

    private void addAllSelectablesWithProperty(String propertyKey, Collection selectables) {
        SelectionEnumeration aSelectionEnumeration = this.selectionEnumeration();
        while (aSelectionEnumeration.hasMoreElements()) {
            ASelectable selectable = aSelectionEnumeration.nextSelectable();
            if (selectable.hasProperty(propertyKey)) {
                selectables.add(selectable);
            }
            selectable.getChildSelectables().addAllSelectablesWithProperty(propertyKey, selectables);
        }
    }

    public Collection getAllExtendedActionsOfKey(String actionKey) {
        LinkedList extendedActions = new LinkedList();
        this.addAllExtendedActionsOfKey(actionKey, extendedActions);
        return extendedActions;
    }

    private void addAllExtendedActionsOfKey(String actionKey, Collection extendedActions) {
        SelectionEnumeration aSelectionEnumeration = this.selectionEnumeration();
        while (aSelectionEnumeration.hasMoreElements()) {
            ASelectable selectable = aSelectionEnumeration.nextSelectable();
            IExtendedAction anExtendedAction = selectable.getAction(actionKey);
            if (anExtendedAction != null) {
                extendedActions.add(anExtendedAction);
            }
            extendedActions.addAll(selectable.getChildSelectables().getAllExtendedActionsOfKey(actionKey));
        }
    }

    public boolean atLeastOneSelectableSupportsAction(String actionKey) {
        SelectionEnumeration aSelectionEnumeration = this.selectionEnumeration();
        boolean hasAction = false;
        while (aSelectionEnumeration.hasMoreElements() && !hasAction) {
            ASelectable selectable = aSelectionEnumeration.nextSelectable();
            if (selectable.hasAction(actionKey)) {
                hasAction = true;
                continue;
            }
            hasAction = selectable.getChildSelectables().atLeastOneSelectableSupportsAction(actionKey);
        }
        return hasAction;
    }

    public boolean allSelectablesSupportAction(String actionKey) {
        SelectionEnumeration aSelectionEnumeration = this.selectionEnumeration();
        boolean hasAction = true;
        while (aSelectionEnumeration.hasMoreElements() && hasAction) {
            ASelectable selectable = aSelectionEnumeration.nextSelectable();
            if (!selectable.hasAction(actionKey)) {
                hasAction = false;
                continue;
            }
            hasAction = selectable.getChildSelectables().allSelectablesSupportAction(actionKey);
        }
        return hasAction;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        SelectionEnumeration children = this.selectionEnumeration();
        if (children.hasMoreElements()) {
            stringBuffer.append(": child selectables = [");
            while (children.hasMoreElements()) {
                stringBuffer.append(children.nextSelectable().toString());
                stringBuffer.append(", ");
            }
            stringBuffer.replace(stringBuffer.length() - 1, stringBuffer.length(), "]");
        } else {
            stringBuffer.append(": empty selection");
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Selection)) {
            return false;
        }
        Selection candidateSelection = (Selection)o;
        if (this.selectionCount() != candidateSelection.selectionCount()) {
            return false;
        }
        SelectionEnumeration ourSelectionEnumeration = this.selectionEnumeration();
        SelectionEnumeration candidateSelectionEnumeration = candidateSelection.selectionEnumeration();
        while (ourSelectionEnumeration.hasMoreElements()) {
            ASelectable candidateSelectable;
            ASelectable ourSelectable = ourSelectionEnumeration.nextSelectable();
            if (ourSelectable.equals(candidateSelectable = candidateSelectionEnumeration.nextSelectable())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 17;
        int count = this.selectionCount();
        hash = HashCodeUtils.accumulateHashCode(hash, count);
        SelectionEnumeration selections = this.selectionEnumeration();
        while (selections.hasMoreElements()) {
            ASelectable selectable = selections.nextSelectable();
            hash = HashCodeUtils.accumulateHashCode(hash, selectable.hashCode());
        }
        return hash;
    }
}

