/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.hawk;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.util.ArrayList;

public class StatusMonitor
implements ITimestampedRunnable {
    private final IAgent iAgent;
    private static StatusMonitor instance = null;
    private DataAccumulatorFactory dataAccumulatorFactory;
    private ArrayList<Object> methodObjectList = new ArrayList();
    private static final String comp = "Status";
    private static final String kNewErrors = "New Errors";
    private static final String kTotalErrors = "Total Errors";
    private static final String kUptime = "Uptime";

    public StatusMonitor(IAgent agent) {
        instance = this;
        this.iAgent = agent;
        this.dataAccumulatorFactory = agent.IAgent_getDataAccumulatorFactory();
    }

    public static StatusMonitor getInstance(IAgent agent) {
        if (instance == null) {
            instance = new StatusMonitor(agent);
        }
        return instance;
    }

    public void init() {
    }

    public void ITimestampedRunnable_execute(long arg0) {
        try {
            for (Object obj : this.methodObjectList) {
                this.getStatusMetrics(obj);
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.iAgent, "ERROR_IN_HAWKMONITOR_STATUS", bomb);
        }
    }

    private void getStatusMetrics(Object methodObj) {
        String processName = null;
        try {
            TibcoBWUtils.getLogger().debug("StatusMonitor.getStatusMetrics()");
            Class<?> amiParameterList = Class.forName("COM.TIBCO.hawk.ami.AmiParameterList", false, ClassLoader.getSystemClassLoader());
            Object result = TibcoBWUtils.invokeMethodOnObject(methodObj, "onInvoke", new Class[]{amiParameterList}, new Object[1]);
            if (result != null) {
                Integer size = (Integer)TibcoBWUtils.invokeMethodOnObject(result, "size");
                TibcoBWUtils.getLogger().debug("StatusMonitor Size: " + size);
                int i = 0;
                while (i < size) {
                    Object param = TibcoBWUtils.invokeMethodOnObject(result, "getParameter", new Class[]{Integer.TYPE}, new Object[]{new Integer(i)});
                    if (param != null) {
                        String name = (String)TibcoBWUtils.invokeMethodOnObject(param, "getName");
                        Object value = TibcoBWUtils.invokeMethodOnObject(param, "getValue");
                        if (i == 0) {
                            processName = value.toString();
                        }
                        if (value != null) {
                            TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": " + value.toString());
                            this.reportMetric("Status|" + processName, name, value.toString());
                        } else {
                            TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": NULL");
                            this.reportMetric("Status|" + processName, name, "");
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.iAgent, "ERROR_IN_HAWKMONITOR_STATUS", bomb);
        }
    }

    private void reportMetric(String component, String name, String value) {
        try {
            if (name.equals(kNewErrors) || name.equals(kTotalErrors) || name.equals(kUptime)) {
                if (value == "") {
                    value = "0";
                }
                this.dataAccumulatorFactory.safeGetLongFluctuatingCounterDataAccumulator("Tibco|Hawk Metrics|" + component + ":" + name).ILongCounterDataAccumulator_setValue(new Long(value).longValue());
            } else {
                this.dataAccumulatorFactory.safeGetStringEveryEventDataAccumulator("Tibco|Hawk Metrics|" + component + ":" + name).IStringEveryEventDataAccumulator_addString(TibcoBWUtils.formatToBeResourceSafe(value));
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.iAgent, "ERROR_IN_HAWKMONITOR_STATUS", bomb);
        }
    }

    public void registerMethodObject(Object methodObj) {
        this.methodObjectList.add(methodObj);
    }

    public void deRegisterMethodObject(Object methodObj) {
        this.methodObjectList.remove(methodObj);
    }
}

