/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.encryption;

import com.sun.crypto.provider.SunJCE;
import com.wily.util.encryption.DecryptionException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class EncryptDecrypt {
    private static EncryptDecrypt sInstance;
    private static byte[] DESKeyBytes;
    private static byte[] ivBytes;
    private String characterEncoding;
    private Cipher encryptCipher;
    private Cipher decryptCipher;
    private BASE64Encoder base64Encoder = new BASE64Encoder();
    private BASE64Decoder base64Decoder = new BASE64Decoder();

    public EncryptDecrypt(SecretKey secretKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        this.initialize(secretKey);
    }

    public EncryptDecrypt() throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        SecretKeySpec key = new SecretKeySpec(DESKeyBytes, "DES");
        this.initialize(key);
    }

    private void initialize(SecretKey secretKey) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        this.characterEncoding = "ASCII";
        this.encryptCipher = Cipher.getInstance("DES/CBC/PKCS5Padding", "SunJCE");
        this.encryptCipher.init(1, (Key)secretKey, iv);
        this.decryptCipher = Cipher.getInstance("DES/CBC/PKCS5Padding", "SunJCE");
        this.decryptCipher.init(2, (Key)secretKey, iv);
    }

    public String encrypt(String password) {
        try {
            byte[] passwordBytes = password.getBytes(this.characterEncoding);
            byte[] encryptedPasswordBytes = this.encryptCipher.doFinal(passwordBytes);
            String encodedEncryptedPassword = this.base64Encoder.encode(encryptedPasswordBytes);
            return encodedEncryptedPassword;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String decrypt(String encodedEncryptedPassword) throws DecryptionException {
        try {
            byte[] encryptedPasswordBytes = this.base64Decoder.decodeBuffer(encodedEncryptedPassword);
            byte[] passwordBytes = this.decryptCipher.doFinal(encryptedPasswordBytes);
            String recoveredPassword = new String(passwordBytes, this.characterEncoding);
            return recoveredPassword;
        }
        catch (Exception e) {
            throw new DecryptionException(e);
        }
    }

    public static synchronized String encryptHelper(String value) {
        return sInstance.encrypt(value);
    }

    public static synchronized String decryptHelper(String value) throws DecryptionException {
        return sInstance.decrypt(value);
    }

    static {
        Security.addProvider(new SunJCE());
        DESKeyBytes = new byte[]{1, 2, 4, 8, 8, 4, 2, 1};
        ivBytes = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
        try {
            sInstance = new EncryptDecrypt();
        }
        catch (Throwable t) {
            sInstance = null;
        }
    }
}

