/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.appmap.agent.trace;

import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.appmap.agent.trace.AOwnerRepository;
import com.wily.introscope.appmap.agent.trace.IAppMapNameHelper;
import com.wily.introscope.spec.agent.beans.appmap.IOwnerRepository;
import com.wily.introscope.spec.server.appmap.IAppMapOwner;
import java.util.List;

public abstract class AbstractNameHelper
implements IAppMapNameHelper {
    protected static final Object kBootstrapClassloaderKey = "bootstrapClassloaderKey";

    @Override
    public IOwnerRepository getCurrentOwnerList(SharedCrossProcessData cache) {
        List localOwners;
        AOwnerRepository result = AOwnerRepository.getInstance();
        IAppMapOwner last = this.getLastRemoteOwnerInCrossProcess(cache);
        if (last != null) {
            result.setLastRemoteOwner(last);
            List owners = this.getOwnerNamesInCrossProcess(cache);
            if (owners != null && !owners.isEmpty()) {
                result.setCurrentRemoteOwners(owners);
            }
        }
        if ((localOwners = this.protectedGetCurrentOwnerNames()) != null && !localOwners.isEmpty()) {
            result.setCurrentLocalOwners(localOwners);
        }
        return result;
    }

    @Override
    public void pushCurrentOwnerName(SharedCrossProcessData cache, IAppMapOwner appName) {
        this.setCurrentOwnerName(appName);
        this.setOwnerNameInCrossProcess(cache, appName);
    }

    @Override
    public void popCurrentOwnerName(SharedCrossProcessData cache) {
        IAppMapOwner newCurrentAppName = this.unsetCurrentOwnerName();
        this.setOwnerNameInCrossProcess(cache, newCurrentAppName);
    }

    @Override
    public IAppMapOwner peekCurrentOwnerName() {
        IAppMapOwner currentAppName = this.protectedGetCurrentOwnerName();
        return currentAppName;
    }

    protected abstract void setCurrentOwnerName(IAppMapOwner var1);

    protected abstract IAppMapOwner protectedGetCurrentOwnerName();

    protected abstract List protectedGetCurrentOwnerNames();

    protected abstract IAppMapOwner unsetCurrentOwnerName();

    protected abstract void setOwnerNameInCrossProcess(SharedCrossProcessData var1, IAppMapOwner var2);

    protected abstract List getOwnerNamesInCrossProcess(SharedCrossProcessData var1);

    protected abstract IAppMapOwner getLastRemoteOwnerInCrossProcess(SharedCrossProcessData var1);
}

