/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.intelligent.instrumentation;

import com.wily.diagnos.cmp.directives.apply.PersistenceFileLockHelper;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.autoprobe.AutoProbeTransformer;
import com.wily.introscope.probebuilder.extension.instrument.intelligent.IntelligentInstrumentationService;
import com.wily.introscope.probebuilder.intelligent.instrumentation.FilePersistenceService;
import com.wily.introscope.probebuilder.intelligent.instrumentation.IntelligentInstrumentationConfig;
import com.wily.introscope.probebuilder.intelligent.instrumentation.util.ClassMethodInfo;
import com.wily.introscope.probebuilder.intelligent.instrumentation.util.ClassUtil;
import com.wily.introscope.probebuilder.intelligent.instrumentation.util.MethodInfo;
import com.wily.util.feedback.SeverityLevel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FilePersistenceHelper {
    public static final String FILE_HEADER_STRING = String.format("######################################################################## %n# Copyright (c) 2016 CA. All Rights Reserved. %n# Introscope(R) is a registered trademark of CA. %n# This is an Automatically generated file. Please DO NOT MODIFY this file %n######################################################################## %n%n", new Object[0]);
    public static final String SET_TRACER_CLASS_MAPPING_UNFORMATTED = "SetTracerClassMapping: %s %s %s%n";
    public static final String SET_TRACER_PARAMTETER_UNFORMATTED = "SetTracerParameter: %s %s %s%n";
    public static final String SET_TRACER_ORDERING_UNFORMATTED = "SetTracerOrdering: %s %d%n";
    public static final String TRACE_ONE_METHOD_OF_CLASS_DIRECTIVE_PREFIX = "TraceOneMethodWithParametersOfClass:";
    public static final String TRACE_ONE_METHOD_OF_CLASS_DIRECTIVE_UNFORMATTED = "TraceOneMethodWithParametersOfClass: %s %s %s %s%n";
    public static final String SKIP_METHOD_FOR_CLASS_DIRECTIVE_PREFIX = "SkipMethodForClass:";
    public static final String SKIP_METHOD_FOR_CLASS_DIRECTIVE_UNFORMATTED = "SkipMethodForClass: %s %s%n";
    public static final String RESOURCE_VALIDATOR_CLASS_NAME = "com.wily.introscope.probebuilder.validate.ResourceNameValidator";
    public static final String METRIC_NAME_VALIDATOR_CLASS_NAME = "com.wily.introscope.probebuilder.validate.MetricNameValidator";
    public static final String ENTRY_POINT_TRACER_CLASS_NAME = "com.wily.introscope.agent.trace.hc2.EntryPointTracer";
    public static final String ENTRY_POINT_BOUNDARY_MARKER_CLASS_NAME = "com.wily.introscope.agent.trace.hc2.EntryPointBoundaryMarkerTracer";
    public static final String EXIT_POINT_TRACER_CLASS_NAME = "com.wily.introscope.agent.trace.hc2.ExitPointTracer";
    public static final String EXIT_POINT_ERROR_REPORTER_CLASS_NAME = "com.wily.introscope.agent.trace.hc2.ExitPointErrorTracer";
    public static final String EXIT_POINT_BACKEND_TRACER_CLASS_NAME = "com.wily.introscope.agent.trace.hc2.ExitPointBackendTracer";
    public static final String EXIT_POINT_NAME_FORMATTER = "com.wily.introscope.agent.trace.hc2.DomainNameFormatter";
    private static final String BASE_DIRECTIVES;
    private static final String ENCODING;
    private static final String NEW_LINE;
    private static IAgent fAgent;
    private static boolean logPermissionMessageFlag;
    private static boolean logInvalidPathMessageFlag;
    private static int retryTimeout;
    private static int retryAttempts;
    private static int logBitMask;
    private static volatile String hotDeployDirPath;
    private static volatile File autoPersistFile;
    private static AtomicInteger entryPointsCountInPbd;
    private static AtomicInteger exitPointsCountInPbd;
    private static AtomicInteger skippedMethodsCountInPbd;

    static {
        ENCODING = System.getProperty("com.wily.introscope.default.encoding");
        NEW_LINE = String.format("%n", new Object[0]);
        logPermissionMessageFlag = false;
        logInvalidPathMessageFlag = false;
        retryTimeout = 0;
        retryAttempts = 0;
        logBitMask = 0;
        entryPointsCountInPbd = new AtomicInteger(0);
        exitPointsCountInPbd = new AtomicInteger(0);
        skippedMethodsCountInPbd = new AtomicInteger(0);
        String value = System.getProperty("introscope.agent.deep.persistence.retry.timeout");
        retryTimeout = value == null ? 500 : Integer.parseInt(value);
        value = System.getProperty("introscope.agent.deep.persistence.retry.attempts.writer");
        retryAttempts = value == null ? 3 : Integer.parseInt(value);
        StringBuffer buffer = new StringBuffer();
        buffer.append(FILE_HEADER_STRING);
        buffer.append(String.format(SET_TRACER_CLASS_MAPPING_UNFORMATTED, FilePersistenceService.TracerInfo.ENTRYPOINT.getAlias(), FilePersistenceService.TracerInfo.ENTRYPOINT.getClassName(), RESOURCE_VALIDATOR_CLASS_NAME));
        buffer.append(String.format(SET_TRACER_ORDERING_UNFORMATTED, FilePersistenceService.TracerInfo.ENTRYPOINT.getAlias(), 1));
        buffer.append(String.format(SET_TRACER_CLASS_MAPPING_UNFORMATTED, FilePersistenceService.TracerInfo.ENTRYPOINT_MARKER.getAlias(), FilePersistenceService.TracerInfo.ENTRYPOINT_MARKER.getClassName(), RESOURCE_VALIDATOR_CLASS_NAME));
        buffer.append(String.format(SET_TRACER_ORDERING_UNFORMATTED, FilePersistenceService.TracerInfo.ENTRYPOINT_MARKER.getAlias(), 2));
        buffer.append(NEW_LINE);
        buffer.append(String.format(SET_TRACER_CLASS_MAPPING_UNFORMATTED, FilePersistenceService.TracerInfo.EXITPOINT_BACKEND.getAlias(), FilePersistenceService.TracerInfo.EXITPOINT_BACKEND.getClassName(), RESOURCE_VALIDATOR_CLASS_NAME));
        buffer.append(String.format(SET_TRACER_PARAMTETER_UNFORMATTED, FilePersistenceService.TracerInfo.EXITPOINT_BACKEND.getAlias(), "nameformatter", EXIT_POINT_NAME_FORMATTER));
        buffer.append(String.format(SET_TRACER_PARAMTETER_UNFORMATTED, FilePersistenceService.TracerInfo.EXITPOINT_BACKEND.getAlias(), "reentrancy", "methodname"));
        buffer.append(String.format(SET_TRACER_PARAMTETER_UNFORMATTED, FilePersistenceService.TracerInfo.EXITPOINT_BACKEND.getAlias(), "generatetransactionelement", Boolean.FALSE));
        buffer.append(String.format(SET_TRACER_ORDERING_UNFORMATTED, FilePersistenceService.TracerInfo.EXITPOINT_BACKEND.getAlias(), 1));
        buffer.append(NEW_LINE);
        buffer.append(String.format(SET_TRACER_CLASS_MAPPING_UNFORMATTED, FilePersistenceService.TracerInfo.EXITPOINT.getAlias(), FilePersistenceService.TracerInfo.EXITPOINT.getClassName(), RESOURCE_VALIDATOR_CLASS_NAME));
        buffer.append(String.format(SET_TRACER_PARAMTETER_UNFORMATTED, FilePersistenceService.TracerInfo.EXITPOINT.getAlias(), "reentrancy", "methodname"));
        buffer.append(String.format(SET_TRACER_PARAMTETER_UNFORMATTED, FilePersistenceService.TracerInfo.EXITPOINT.getAlias(), "nameformatter", EXIT_POINT_NAME_FORMATTER));
        buffer.append(String.format(SET_TRACER_ORDERING_UNFORMATTED, FilePersistenceService.TracerInfo.EXITPOINT.getAlias(), 2));
        buffer.append(NEW_LINE);
        buffer.append(String.format(SET_TRACER_CLASS_MAPPING_UNFORMATTED, FilePersistenceService.TracerInfo.EXITPOINT_ERROR_REPORTER.getAlias(), FilePersistenceService.TracerInfo.EXITPOINT_ERROR_REPORTER.getClassName(), METRIC_NAME_VALIDATOR_CLASS_NAME));
        buffer.append(String.format(SET_TRACER_PARAMTETER_UNFORMATTED, FilePersistenceService.TracerInfo.EXITPOINT_ERROR_REPORTER.getAlias(), "reentrancy", "methodname"));
        buffer.append(String.format(SET_TRACER_PARAMTETER_UNFORMATTED, FilePersistenceService.TracerInfo.EXITPOINT_ERROR_REPORTER.getAlias(), "nameformatter", EXIT_POINT_NAME_FORMATTER));
        buffer.append(String.format(SET_TRACER_ORDERING_UNFORMATTED, FilePersistenceService.TracerInfo.EXITPOINT_ERROR_REPORTER.getAlias(), 3));
        buffer.append(NEW_LINE);
        BASE_DIRECTIVES = buffer.toString();
    }

    static void init(IAgent agent) {
        fAgent = agent;
        hotDeployDirPath = FilePersistenceHelper.getHotdeployInstallationPath();
        autoPersistFile = new File(String.valueOf(hotDeployDirPath) + File.separator + "AutoPersist.pbd");
    }

    static void updateClampBitMasks(FilePersistenceService service) {
        int lockFileBitMask = 1;
        int traceClampBitMask = 2;
        int blackListClampBitMask = 4;
        int queueSizeClampBitMask = 8;
        int notPersistedBitMask = 16;
        if (!PersistenceFileLockHelper.initializeSuccessful) {
            PersistenceFileLockHelper.initialize((IAgent)fAgent);
            IntelligentInstrumentationService.setBitMask(lockFileBitMask);
            return;
        }
        IntelligentInstrumentationService.clearBitMask(lockFileBitMask);
        if (FilePersistenceHelper.getInstrumentedMethodsCountInPbd() >= IntelligentInstrumentationConfig.INSTANCE.getPersistenceTraceDirectivesClampSize()) {
            IntelligentInstrumentationService.setBitMask(traceClampBitMask);
            if ((logBitMask & traceClampBitMask) == 0) {
                Logger.logWarningMessage((String)("No new entry point or backend will be discovered, because number of automatically detected boundary points have reached a clamp value of " + IntelligentInstrumentationConfig.INSTANCE.getPersistenceTraceDirectivesClampSize() + ", as defined in " + "introscope.agent.autopersist.instrumentation.count.max"));
                FilePersistenceHelper.setLogBitMask(traceClampBitMask);
            }
        } else {
            IntelligentInstrumentationService.clearBitMask(traceClampBitMask);
            FilePersistenceHelper.clearLogBitMask(traceClampBitMask);
        }
        if (FilePersistenceHelper.getSkippedMethodsCountInPbd() >= IntelligentInstrumentationConfig.INSTANCE.getPersistenceBlacklistClampSize()) {
            IntelligentInstrumentationService.setBitMask(blackListClampBitMask);
            if ((logBitMask & blackListClampBitMask) == 0) {
                Logger.logWarningMessage((String)("No new entry point or backend will be discovered, because Blacklist clamp introscope.agent.autopersist.blacklist.count.max reached max value of " + IntelligentInstrumentationConfig.INSTANCE.getPersistenceBlacklistClampSize()));
                FilePersistenceHelper.setLogBitMask(blackListClampBitMask);
            }
        } else {
            IntelligentInstrumentationService.clearBitMask(blackListClampBitMask);
            FilePersistenceHelper.clearLogBitMask(blackListClampBitMask);
        }
        if (FilePersistenceService.getQueueSize() >= IntelligentInstrumentationConfig.INSTANCE.getPersistenceQueueClampSize()) {
            IntelligentInstrumentationService.setBitMask(queueSizeClampBitMask);
            if ((logBitMask & queueSizeClampBitMask) == 0) {
                Logger.logWarningMessage((String)("No new entry point or backend will be discovered, because persistence queue clamp introscope.agent.autopersist.queue.size reached max value of " + IntelligentInstrumentationConfig.INSTANCE.getPersistenceQueueClampSize()));
                FilePersistenceHelper.setLogBitMask(queueSizeClampBitMask);
            }
        } else {
            IntelligentInstrumentationService.clearBitMask(queueSizeClampBitMask);
            FilePersistenceHelper.clearLogBitMask(queueSizeClampBitMask);
        }
        if (!service.getToPersistMap().isEmpty()) {
            IntelligentInstrumentationService.setBitMask(notPersistedBitMask);
            if ((logBitMask & notPersistedBitMask) == 0) {
                Logger.logWarningMessage((String)"No new entry point or backend will be discovered, because previously selected candidates are not persisted yet");
                FilePersistenceHelper.setLogBitMask(notPersistedBitMask);
            }
        } else {
            IntelligentInstrumentationService.clearBitMask(notPersistedBitMask);
            FilePersistenceHelper.clearLogBitMask(notPersistedBitMask);
        }
    }

    static void checkAndLogClampStatus() {
        if (IntelligentInstrumentationService.isMaskSet(31)) {
            Logger.logDebugMessage((String)"Stack Trace recording clamp status: Recording Not Allowed");
            if (Logger.isTraceEnabled()) {
                Logger.logTraceMessage((String)("clamp flag current value: " + IntelligentInstrumentationService.currentFlagValue()));
                Logger.logTraceMessage((String)("is lock file bit mask set: " + IntelligentInstrumentationService.isMaskSet(1)));
                Logger.logTraceMessage((String)("is directive clamp bit mask set: " + IntelligentInstrumentationService.isMaskSet(2)));
                Logger.logTraceMessage((String)("is blacklist clamp bit mask set: " + IntelligentInstrumentationService.isMaskSet(4)));
                Logger.logTraceMessage((String)("is persistence queue bit mask set: " + IntelligentInstrumentationService.isMaskSet(8)));
                Logger.logTraceMessage((String)("is previous persistence request still pending: " + IntelligentInstrumentationService.isMaskSet(16)));
            }
        }
    }

    static HashMap<String, ClassMethodInfo> filter(HashMap<String, ClassMethodInfo> toPersistMap) {
        if (toPersistMap == null || toPersistMap.isEmpty()) {
            return toPersistMap;
        }
        HashMap<String, ClassMethodInfo> toSkipClassMethodMap = new HashMap<String, ClassMethodInfo>();
        HashMap toInstrumentClassMethodMap = new HashMap();
        for (String className : toPersistMap.keySet()) {
            ClassMethodInfo cmvg = toPersistMap.get(className);
            for (String MethodSignature : cmvg.methodsWithGap.keySet()) {
                MethodInfo meth = cmvg.methodsWithGap.get(MethodSignature);
                Collection<FilePersistenceService.TracingType> types = meth.getTracingTypes();
                for (FilePersistenceService.TracingType type : types) {
                    ClassMethodInfo clInfo;
                    if (FilePersistenceService.TracingType.SKIP == type) {
                        clInfo = toSkipClassMethodMap.get(className);
                        if (clInfo == null) {
                            clInfo = new ClassMethodInfo(className);
                            toSkipClassMethodMap.put(className, clInfo);
                        }
                        clInfo.addMethod(meth.getMethodName(), meth.getMethodDesciptor(), type);
                        continue;
                    }
                    clInfo = (ClassMethodInfo)toInstrumentClassMethodMap.get(className);
                    if (clInfo == null) {
                        clInfo = new ClassMethodInfo(className);
                        toInstrumentClassMethodMap.put(className, clInfo);
                    }
                    clInfo.addMethod(meth.getMethodName(), meth.getMethodDesciptor(), type);
                }
            }
        }
        toInstrumentClassMethodMap = ClassUtil.getJavaClassFromVM(toInstrumentClassMethodMap, false, fAgent);
        toInstrumentClassMethodMap = ClassUtil.filterInstrumentedMethods(fAgent, toInstrumentClassMethodMap);
        FilePersistenceHelper.mergeEntries(toInstrumentClassMethodMap, toSkipClassMethodMap);
        return toInstrumentClassMethodMap;
    }

    public static void pruneAlreadySkippedEntries(HashMap<String, ClassMethodInfo> toPersistMap) {
        Map<String, ClassMethodInfo> persistedMap = FilePersistenceHelper.readPbdFileDirectives(autoPersistFile);
        Iterator<String> toInstClassesIterator = toPersistMap.keySet().iterator();
        while (toInstClassesIterator.hasNext()) {
            String className = toInstClassesIterator.next();
            ClassMethodInfo cmvg = toPersistMap.get(className);
            Iterator<String> methodsIterator = cmvg.methodsWithGap.keySet().iterator();
            while (methodsIterator.hasNext()) {
                String methodSignature = methodsIterator.next();
                if (!FilePersistenceHelper.isSkippedMethod(persistedMap, className, methodSignature)) continue;
                methodsIterator.remove();
            }
            if (!cmvg.methodsWithGap.isEmpty()) continue;
            toInstClassesIterator.remove();
        }
    }

    static void pruneSkippedAndExistingEntries(HashMap<String, ClassMethodInfo> toPersistMap) {
        FilePersistenceHelper.pruneSkippedAndExistingEntries(toPersistMap, FilePersistenceHelper.readPbdFileDirectives(autoPersistFile));
    }

    static void pruneSkippedAndExistingEntries(Map<String, ClassMethodInfo> toPersistMap, Map<String, ClassMethodInfo> alreadyPersistedMap) {
        Iterator<String> toInstClassesIterator = toPersistMap.keySet().iterator();
        while (toInstClassesIterator.hasNext()) {
            String className = toInstClassesIterator.next();
            ClassMethodInfo cmvg = toPersistMap.get(className);
            Iterator<String> methodsIterator = cmvg.methodsWithGap.keySet().iterator();
            while (methodsIterator.hasNext()) {
                String methodSignature = methodsIterator.next();
                if (FilePersistenceHelper.isSkippedMethod(alreadyPersistedMap, className, methodSignature)) {
                    methodsIterator.remove();
                    continue;
                }
                MethodInfo methodInfo = cmvg.getMethodInfo(methodSignature);
                Iterator<FilePersistenceService.TracingType> typesIterator = methodInfo.getTracingTypes().iterator();
                while (typesIterator.hasNext()) {
                    if (!FilePersistenceHelper.isExistingMethodTracing(alreadyPersistedMap, className, methodSignature, typesIterator.next())) continue;
                    typesIterator.remove();
                }
                if (!methodInfo.getTracingTypes().isEmpty()) continue;
                methodsIterator.remove();
            }
            if (!cmvg.methodsWithGap.isEmpty()) continue;
            toInstClassesIterator.remove();
        }
    }

    private static void mergeEntries(Map<String, ClassMethodInfo> toInstrumentMap1, Map<String, ClassMethodInfo> toInstrumentedMap2) {
        for (String className : toInstrumentedMap2.keySet()) {
            ClassMethodInfo cmvg = toInstrumentedMap2.get(className);
            for (String methodSignature : cmvg.methodsWithGap.keySet()) {
                MethodInfo meth = cmvg.methodsWithGap.get(methodSignature);
                ClassMethodInfo clInfo = toInstrumentMap1.get(className);
                if (clInfo == null) {
                    clInfo = new ClassMethodInfo(className);
                    toInstrumentMap1.put(className, clInfo);
                }
                clInfo.addMethod(meth);
            }
        }
    }

    static void reportSustainabilityMetrics() {
        FilePersistenceHelper.updateTracingCounters();
        SustainabilityMetricsHelper.reportEntryPointsPersisted((int)entryPointsCountInPbd.get());
        SustainabilityMetricsHelper.reportExitPointPersisted((int)exitPointsCountInPbd.get());
        SustainabilityMetricsHelper.reportSkippedMethodsPersisted((int)FilePersistenceHelper.getSkippedMethodsCountInPbd());
    }

    private static void updateTracingCounters() {
        int entryPointCount = 0;
        int exitPointCount = 0;
        int skippedMethods = 0;
        Map<String, ClassMethodInfo> directives = FilePersistenceHelper.readPbdFileDirectives(autoPersistFile);
        for (ClassMethodInfo clsInfo : directives.values()) {
            for (MethodInfo methodInfo : clsInfo.getMethods()) {
                Collection<FilePersistenceService.TracingType> tracingTypes = methodInfo.getTracingTypes();
                for (FilePersistenceService.TracingType type : tracingTypes) {
                    if (FilePersistenceService.TracingType.ENTRY_POINT.equals((Object)type)) {
                        ++entryPointCount;
                    }
                    if (FilePersistenceService.TracingType.EXIT_POINT.equals((Object)type)) {
                        ++exitPointCount;
                    }
                    if (!FilePersistenceService.TracingType.SKIP.equals((Object)type)) continue;
                    ++skippedMethods;
                }
            }
        }
        entryPointsCountInPbd.set(entryPointCount);
        exitPointsCountInPbd.set(exitPointCount);
        skippedMethodsCountInPbd.set(skippedMethods);
    }

    private static Map<String, ClassMethodInfo> readPbdFileDirectives(File pbdFile) {
        if (pbdFile.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(pbdFile);
                HashMap<String, ClassMethodInfo> hashMap = FilePersistenceHelper.readProbeDirectives(in);
                return hashMap;
            }
            catch (IOException e) {
                Logger.logException((Exception)e);
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        Logger.logException((Exception)e);
                    }
                }
            }
        }
        return Collections.emptyMap();
    }

    static HashMap<String, ClassMethodInfo> readProbeDirectives(InputStream in) {
        HashMap<String, ClassMethodInfo> instrumentedMap;
        block18: {
            instrumentedMap = new HashMap<String, ClassMethodInfo>();
            BufferedReader bufferedReader = null;
            try {
                try {
                    if (in != null) {
                        bufferedReader = ENCODING == null ? new BufferedReader(new InputStreamReader(in)) : new BufferedReader(new InputStreamReader(in, ENCODING));
                        String line = null;
                        String methName = null;
                        String methDesc = null;
                        Pattern p = null;
                        Matcher m = null;
                        block11: while ((line = bufferedReader.readLine()) != null) {
                            FilePersistenceService.TracingType[] tracingTypeArray = FilePersistenceService.TracingType.values();
                            int n = tracingTypeArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                FilePersistenceService.TracingType type = tracingTypeArray[n2];
                                p = Pattern.compile(type.getDirectiveRegex());
                                m = p.matcher(line);
                                if (m.matches()) {
                                    ClassMethodInfo clMethInfo;
                                    String className = m.group(1).trim();
                                    String methSignature = m.group(2).trim();
                                    int separatorIndex = methSignature.indexOf(40);
                                    if (separatorIndex != -1) {
                                        methName = methSignature.substring(0, separatorIndex);
                                        methDesc = methSignature.substring(separatorIndex);
                                    }
                                    if ((clMethInfo = instrumentedMap.get(className)) == null) {
                                        clMethInfo = new ClassMethodInfo(className, methName, methDesc, type);
                                        instrumentedMap.put(className, clMethInfo);
                                        continue block11;
                                    }
                                    clMethInfo.addMethod(methName, methDesc, type);
                                    continue block11;
                                }
                                ++n2;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    Logger.logException((String)"Error reading from pbd AutoPersist.pbd", (Exception)e);
                    if (bufferedReader == null) break block18;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e2) {
                        Logger.logException((String)"Error closing reader for AutoPersist.pbd", (Exception)e2);
                    }
                }
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e) {
                        Logger.logException((String)"Error closing reader for AutoPersist.pbd", (Exception)e);
                    }
                }
            }
        }
        return instrumentedMap;
    }

    private static boolean isExistingMethodTracing(Map<String, ClassMethodInfo> classToMethodsMap, String className, String methodSignature, FilePersistenceService.TracingType type) {
        return !FilePersistenceHelper.isNewMethodTracing(classToMethodsMap, className, methodSignature, type);
    }

    private static boolean isNewMethodTracing(Map<String, ClassMethodInfo> classToMethodsMap, String className, String methodSignature, FilePersistenceService.TracingType type) {
        MethodInfo methodInfo;
        ClassMethodInfo cmvg = classToMethodsMap.get(className);
        if (cmvg != null && (methodInfo = cmvg.getMethodInfo(methodSignature)) != null) {
            return !methodInfo.getTracingTypes().contains((Object)type);
        }
        return true;
    }

    private static boolean isSkippedMethod(Map<String, ClassMethodInfo> classToMethodsMap, String className, String methodSignature) {
        ClassMethodInfo cmvg = classToMethodsMap.get(className);
        if (cmvg != null) {
            MethodInfo methInfo = cmvg.getMethodInfo(methodSignature);
            return methInfo != null && methInfo.isSkipped();
        }
        return false;
    }

    private static void addMethodToList(Map<String, ClassMethodInfo> finalMethodListToWrite, String className, MethodInfo meth) {
        ClassMethodInfo clMethInfo = finalMethodListToWrite.get(className);
        if (clMethInfo == null) {
            clMethInfo = new ClassMethodInfo(className);
            finalMethodListToWrite.put(className, clMethInfo);
        }
        clMethInfo.addMethod(meth.getMethodName(), meth.getMethodDesciptor(), meth.getTracingTypes());
    }

    private static int mergeToFinalMap(Map<String, ClassMethodInfo> finalMethodsToPersist, Map<String, ClassMethodInfo> toInstrumentMap, Map<String, ClassMethodInfo> alreadyInstrumentedMap) {
        Iterator<String> toInsClassesIterator = toInstrumentMap.keySet().iterator();
        int traceDirectivesClamp = IntelligentInstrumentationConfig.INSTANCE.getPersistenceTraceDirectivesClampSize();
        int blacklistClamp = IntelligentInstrumentationConfig.INSTANCE.getPersistenceBlacklistClampSize();
        int instrumentCount = 0;
        int skipCount = 0;
        while (toInsClassesIterator.hasNext()) {
            String className = toInsClassesIterator.next();
            ClassMethodInfo cmvg = toInstrumentMap.get(className);
            for (String methodSignature : cmvg.methodsWithGap.keySet()) {
                MethodInfo mInfo = cmvg.methodsWithGap.get(methodSignature);
                Collection<FilePersistenceService.TracingType> types = mInfo.getTracingTypes();
                for (FilePersistenceService.TracingType type : types) {
                    FilePersistenceService.DirectiveType dirType = type.getDirectiveType();
                    if (FilePersistenceService.DirectiveType.SKIP == dirType) {
                        if (FilePersistenceHelper.getSkippedMethodsCountInPbd() + skipCount >= blacklistClamp) continue;
                        FilePersistenceHelper.addMethodToList(finalMethodsToPersist, className, mInfo);
                        ++skipCount;
                        continue;
                    }
                    if (FilePersistenceService.DirectiveType.INSTRUMENT != dirType || FilePersistenceHelper.getInstrumentedMethodsCountInPbd() + instrumentCount >= traceDirectivesClamp) continue;
                    FilePersistenceHelper.addMethodToList(finalMethodsToPersist, className, mInfo);
                    ++instrumentCount;
                }
            }
        }
        FilePersistenceHelper.mergeEntries(finalMethodsToPersist, alreadyInstrumentedMap);
        return instrumentCount + skipCount;
    }

    private static void addInstrumentationDirectives(HashMap<String, ClassMethodInfo> finalMethodListToWrite, StringBuffer fileContents) {
        Iterator<String> classesIterator = finalMethodListToWrite.keySet().iterator();
        StringBuffer instEntryPointBuffer = new StringBuffer();
        StringBuffer instExitPointBuffer = new StringBuffer();
        StringBuffer skipBuffer = new StringBuffer();
        while (classesIterator.hasNext()) {
            String className = classesIterator.next();
            ClassMethodInfo cmInfo = finalMethodListToWrite.get(className);
            for (String methodSignature : cmInfo.methodsWithGap.keySet()) {
                MethodInfo meth = cmInfo.methodsWithGap.get(methodSignature);
                if (!FilePersistenceHelper.isEligibeForPersistence(className, meth)) continue;
                Collection<FilePersistenceService.TracingType> types = meth.getTracingTypes();
                for (FilePersistenceService.TracingType type : types) {
                    FilePersistenceService.DirectiveType dirType = type.getDirectiveType();
                    if (FilePersistenceService.DirectiveType.SKIP == dirType) {
                        skipBuffer.append(String.format(SKIP_METHOD_FOR_CLASS_DIRECTIVE_UNFORMATTED, className, methodSignature));
                        continue;
                    }
                    if (FilePersistenceService.DirectiveType.INSTRUMENT != dirType) continue;
                    instEntryPointBuffer.append(String.format(TRACE_ONE_METHOD_OF_CLASS_DIRECTIVE_UNFORMATTED, className, methodSignature, type.getTracerInfo().getAlias(), type.getTracerInfo().getResourcePath()));
                }
            }
        }
        if (instEntryPointBuffer.length() > 0) {
            fileContents.append(instEntryPointBuffer).append(NEW_LINE);
        }
        if (instExitPointBuffer.length() > 0) {
            fileContents.append(instExitPointBuffer).append(NEW_LINE);
        }
        if (skipBuffer.length() > 0) {
            fileContents.append(skipBuffer);
        }
    }

    static boolean persistDirectivesToFile(HashMap<String, ClassMethodInfo> toPersistMap) {
        if (toPersistMap == null || toPersistMap.isEmpty()) {
            return false;
        }
        if (hotDeployDirPath == null && !logInvalidPathMessageFlag) {
            Logger.logMessage((String)"Cannot write to the persistence file AutoPersist.pbd since hotdeploy directory is not available", (SeverityLevel)SeverityLevel.ERROR);
            logInvalidPathMessageFlag = true;
            return false;
        }
        boolean lockAcquired = true;
        boolean status = false;
        BufferedWriter bufferedWriter = null;
        try {
            int count = 0;
            while ((PersistenceFileLockHelper.hasLock() && PersistenceFileLockHelper.isLockValid() || PersistenceFileLockHelper.tryExclusiveLock() == null) && count < retryAttempts) {
                Thread.sleep(retryTimeout);
                ++count;
            }
            if (count == retryAttempts) {
                lockAcquired = false;
                Logger.logDebugMessage((String)("Skipping the write to " + autoPersistFile.getAbsolutePath() + " since the filelock is acquired by another thread/process"));
                return false;
            }
            IDynamicInstrumentationTransformer dit = fAgent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer();
            if (autoPersistFile.exists() && autoPersistFile.lastModified() > dit.getMostRecentLoadTimeStamp()) {
                Logger.logDebugMessage((String)("Skipping the write to " + autoPersistFile.getAbsolutePath() + " because the file has been modified since it was last read"));
                return false;
            }
            try {
                if (!autoPersistFile.exists()) {
                    autoPersistFile.createNewFile();
                }
                if (autoPersistFile.canWrite()) {
                    Map<String, ClassMethodInfo> alreadyPersistedMap = FilePersistenceHelper.readPbdFileDirectives(autoPersistFile);
                    FilePersistenceHelper.pruneSkippedAndExistingEntries(toPersistMap, alreadyPersistedMap);
                    if (!toPersistMap.isEmpty()) {
                        HashMap<String, ClassMethodInfo> finalClassMethodsMap = new HashMap<String, ClassMethodInfo>();
                        int newEntriesCount = FilePersistenceHelper.mergeToFinalMap(finalClassMethodsMap, toPersistMap, alreadyPersistedMap);
                        if (Logger.isDebugEnabled()) {
                            Logger.logDebugMessage((String)("FilePersistenceService - already persisted directives: " + alreadyPersistedMap));
                            Logger.logDebugMessage((String)("FilePersistenceService - filtered out skipped and already persisted entries, new directives to persist: " + toPersistMap));
                            Logger.logDebugMessage((String)("FilePersistenceService - final set of directives (existing + new) to persist: " + finalClassMethodsMap));
                        }
                        StringBuffer fileContentsToWrite = new StringBuffer(BASE_DIRECTIVES);
                        FilePersistenceHelper.addInstrumentationDirectives(finalClassMethodsMap, fileContentsToWrite);
                        FileOutputStream out = new FileOutputStream(autoPersistFile, false);
                        bufferedWriter = ENCODING == null ? new BufferedWriter(new OutputStreamWriter(out)) : new BufferedWriter(new OutputStreamWriter((OutputStream)out, ENCODING));
                        bufferedWriter.write(fileContentsToWrite.toString());
                        status = true;
                        Logger.logDebugMessage((String)(String.valueOf(newEntriesCount) + " new entries were persisted in " + autoPersistFile.getAbsolutePath()));
                    }
                } else if (!logPermissionMessageFlag) {
                    Logger.logMessage((String)("Cannot write to the persistence file " + autoPersistFile.getAbsolutePath() + ". Please enable write permissions"), (SeverityLevel)SeverityLevel.ERROR);
                    logPermissionMessageFlag = true;
                }
            }
            catch (Exception e) {
                Logger.logMessage((String)("Error writing to pbd " + autoPersistFile.getAbsolutePath() + " " + e.getMessage()), (SeverityLevel)SeverityLevel.ERROR);
            }
        }
        finally {
            try {
                if (lockAcquired) {
                    PersistenceFileLockHelper.releaseLock();
                    lockAcquired = false;
                }
            }
            catch (IOException e) {
                Logger.logException((String)"Error releasing lock after writing to AutoPersist.pbd", (Exception)e);
            }
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException e) {
                    Logger.logException((String)"Error closing writer after writing to AutoPersist.pbd", (Exception)e);
                }
            }
        }
        return status;
    }

    private static boolean isEligibeForPersistence(String className, MethodInfo methodInfo) {
        return className != null && methodInfo.getMethodName() != null && methodInfo.getMethodDesciptor() != null && methodInfo.getTracingTypes().size() > 0;
    }

    private static void setLogBitMask(int mask) {
        logBitMask |= mask;
    }

    private static void clearLogBitMask(int mask) {
        logBitMask &= ~mask;
    }

    static int getInstrumentedMethodsCountInPbd() {
        return entryPointsCountInPbd.get() + exitPointsCountInPbd.get();
    }

    public static int getEntryPointMethodsCountInPbd() {
        return entryPointsCountInPbd.get();
    }

    public static int getSkippedMethodsCountInPbd() {
        return skippedMethodsCountInPbd.get();
    }

    private static String getHotdeployInstallationPath() {
        String hotDeployDirPath = null;
        String[] directivesList = AutoProbeTransformer.getDirectivesFileList();
        if (directivesList == null) {
            throw new IllegalStateException("Missing Directive List");
        }
        int i = 0;
        while (i < directivesList.length) {
            if (directivesList[i].endsWith("hotdeploy")) {
                hotDeployDirPath = directivesList[i];
                break;
            }
            ++i;
        }
        return hotDeployDirPath;
    }

    public String getHotDeployPath() {
        return hotDeployDirPath == null ? FilePersistenceHelper.getHotdeployInstallationPath() : hotDeployDirPath;
    }
}

