/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.handlers.weblogic8;

import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.handlers.WsdmGenericHandler;
import com.wily.powerpack.webservices.handlers.WsdmMessageContext;
import java.util.Iterator;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Node;

public class WsdmWebLogicGenericHandler
extends WsdmGenericHandler {
    protected String removeBodyTags(String input) {
        if (log.isDebugLogging().booleanValue()) {
            log.debug("removeBodyTags(" + input + ")");
        }
        String output = input.substring("SOAPBody[".length(), input.length() - 1);
        return output;
    }

    private void genericParse(SOAPEnvelope se, SOAPBody sb, WsdmMessageContext wsdmMessageContext, String operationNamespace) {
        if (operationNamespace == null || operationNamespace.equals("")) {
            log.debug("genericParse(...)");
            String inputString = "";
            if (se != null) {
                try {
                    sb = se.getBody();
                }
                catch (SOAPException soape) {
                    log.error("WsdmWebLogicGenericHandler::genericParse)" + (Object)((Object)soape));
                }
                if (sb != null) {
                    inputString = this.removeBodyTags(sb.toString());
                }
            }
            operationNamespace = this.getOperationNamespaceFromSoapBody(inputString);
            if (log.isDebugLogging().booleanValue()) {
                log.debug("genericParse: parsed service name = " + operationNamespace);
                log.debug("genericParse: parsed operation name = " + wsdmMessageContext.getOperationName());
            }
        }
    }

    public boolean handleFault(MessageContext context) {
        boolean ret = true;
        try {
            ret = this.wsdmHandleFault(context);
        }
        catch (NullPointerException e) {
            log.error("WsdmWebLogicGenericHandler::handleFault " + e.getMessage() + this.dumpStackTrace(e));
            ret = true;
        }
        catch (NoClassDefFoundError e) {
            log.error("WsdmWebLogicGenericHandler::handleFault " + e.getMessage() + this.dumpStackTrace(e));
            ret = true;
        }
        return ret;
    }

    public boolean handleResponse(MessageContext context) {
        boolean ret = true;
        try {
            this.wsdmHandleResponse(context);
        }
        catch (NullPointerException e) {
            log.error("WsdmWebLogicGenericHandler::handleResponse " + e.getMessage() + this.dumpStackTrace(e));
        }
        catch (NoClassDefFoundError e) {
            log.error("WsdmWebLogicGenericHandler::handleResponse " + e.getMessage() + this.dumpStackTrace(e));
        }
        return ret;
    }

    protected String walkEnvelope(SOAPEnvelope env) {
        if (log.isDebugLogging().booleanValue()) {
            log.debug("walkEnvelope(" + env + ")");
        }
        if (env == null) {
            return "";
        }
        SOAPHeader header = null;
        try {
            header = env.getHeader();
        }
        catch (SOAPException sOAPException) {
            header = null;
        }
        String headerStr = "";
        if (header != null) {
            headerStr = header.toString();
        }
        SOAPBody soapBody = null;
        try {
            soapBody = env.getBody();
        }
        catch (SOAPException sOAPException) {
            soapBody = null;
        }
        StringBuffer bodyStr = new StringBuffer(headerStr);
        if (soapBody != null) {
            Iterator iter = soapBody.getChildElements();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof SOAPBodyElement)) continue;
                SOAPBodyElement el = (SOAPBodyElement)element;
                bodyStr.append(el.toString());
            }
        }
        String result = bodyStr.toString();
        if (log.isDebugLogging().booleanValue()) {
            log.debug("walkEnvelope(...) = '" + result + "'");
        }
        return result;
    }

    private void processClientCorrelationId(WsdmMessageContext wsdmMessageContext, SOAPEnvelope envelope, String correlationString, MessageContext context) throws SOAPException {
        wsdmMessageContext.setCorrelationId(correlationString);
        if (WSMUtils.correlationSOAPInsertionEnabled()) {
            if (envelope == null) {
                log.error("WsdmJaxRpcHandler:processCorrelationId: Correlation ID over SOAP enabled but SOAP envolope is not available");
            } else {
                this.processSOAPClientCorrelationId(envelope, correlationString);
            }
        }
        if (WSMUtils.correlationHTTPInsertionEnabled()) {
            SOAPMessage soapMess = ((SOAPMessageContext)context).getMessage();
            MimeHeaders httpheaders = soapMess.getMimeHeaders();
            if (httpheaders == null) {
                log.error("WsdmJaxRpcHandler:processCorrelationId: Correlation ID over HTTP enabled but HTTP envolope is not available");
            } else {
                this.processHTTPClientCorrelationId(httpheaders, correlationString);
            }
        }
    }

    private void processSOAPClientCorrelationId(SOAPEnvelope envelope, String correlationString) throws SOAPException {
        try {
            SOAPHeader header = envelope.getHeader();
            Name attrName = envelope.createName("CorID");
            SOAPElement headerElement = header.addChildElement("WSCorIDSOAPHeader", "", "http://www.ca.com/apm");
            headerElement.addAttribute(attrName, correlationString);
            headerElement.addNamespaceDeclaration("", "http://www.ca.com/apm");
            if (log.isDebugLogging().booleanValue()) {
                log.debug("WsdmWebLogicGenericHandler::element=" + headerElement);
            }
        }
        catch (SOAPException se) {
            log.error("WsdmWebLogicGenericHandler::processSOAPClientCorrelationId cannot set header " + (Object)((Object)se));
        }
    }

    private void processHTTPClientCorrelationId(MimeHeaders httpheaders, String correlationString) {
        String[] corid = httpheaders.getHeader("CorID");
        if (corid == null || corid.length == 0) {
            httpheaders.addHeader("CorID", correlationString);
        } else {
            httpheaders.setHeader("CorID", correlationString);
        }
    }

    private void processCorrelationId(WsdmMessageContext wsdmMessageContext, SOAPEnvelope envelope, MessageContext context) throws SOAPException {
        if (log.isDebugLogging().booleanValue()) {
            log.debug("WsdmWebLogicGenericHandler::processCorrelationId: observationType=" + wsdmMessageContext.getObservationType());
        }
        if (this.getObservationType() == 1) {
            boolean correlationIdFound = false;
            if (WSMUtils.correlationHTTPReadEnabled()) {
                SOAPMessage soapMess = ((SOAPMessageContext)context).getMessage();
                MimeHeaders httpheader = soapMess.getMimeHeaders();
                if (httpheader != null) {
                    String[] corid = httpheader.getHeader("CorID");
                    if (corid != null && corid.length > 0) {
                        if (corid.length > 1) {
                            log.info("WsdmWeblogicGenericHandler:processCorrelationId: multiple Correlation ID values found, the first value will be used");
                        }
                        correlationIdFound = true;
                        String correlationId = corid[0];
                        new CorrelationId(correlationId);
                        wsdmMessageContext.setCorrelationId(correlationId);
                    }
                } else {
                    log.debug("WsdmJaxRpcHandler:processCorrelationId: Correlation ID over HTTP enabled but HTTP header is not available");
                }
            }
            if (!correlationIdFound && WSMUtils.correlationSOAPReadEnabled()) {
                if (envelope == null) {
                    log.error("WsdmJaxRpcHandler:processCorrelationId: Correlation ID over SOAP enabled but SOAP header is not available");
                    return;
                }
                SOAPHeader header = envelope.getHeader();
                Name attrName = envelope.createName("CorID");
                if (header != null) {
                    Iterator it = header.getChildElements();
                    while (it.hasNext()) {
                        SOAPHeaderElement headerElement;
                        String headerName;
                        Object childElement = it.next();
                        if (!(childElement instanceof SOAPHeaderElement) || !(headerName = (headerElement = (SOAPHeaderElement)childElement).getElementName().getLocalName()).equals("WSCorIDSOAPHeader")) continue;
                        correlationIdFound = true;
                        String correlationId = headerElement.getAttributeValue(attrName);
                        if (log.isDebugLogging().booleanValue()) {
                            log.debug("WsdmWebLogicGenericHandler::processCorrelationId: server correlationId=" + correlationId);
                        }
                        new CorrelationId(correlationId);
                        wsdmMessageContext.setCorrelationId(correlationId);
                        this.cleanSOAPHeader(header, headerElement);
                        break;
                    }
                }
            }
            if (!correlationIdFound) {
                new CorrelationId();
            }
            return;
        }
        if (this.getObservationType() == 2) {
            CorrelationId corrId = new CorrelationId();
            corrId.incrementSequenceId();
            this.setNameCache(wsdmMessageContext.getOperationName(), wsdmMessageContext.getOperationNameSpace());
            if (log.isDebugLogging().booleanValue()) {
                log.debug("WsdmWebLogicGenericHandler processcorrelationid::operationname=" + wsdmMessageContext.getOperationName() + " operationnamespace=" + wsdmMessageContext.getOperationNameSpace());
            }
            this.mapDependency();
            String correlationString = corrId.getCurrentOutgoingCorrelationIdStrippedForHeader();
            this.processClientCorrelationId(wsdmMessageContext, envelope, correlationString, context);
        } else {
            log.error("WsdmWebLogicGenericHandler::processCorrelationId: observationType is not set");
        }
    }

    protected boolean weblogicHandleRequest(MessageContext context, WsdmMessageContext wsdmMessageContext, String operationNamespace) {
        SOAPBody sb;
        SOAPEnvelope se;
        block9: {
            log.debug("WsdmWebLogicGenericHandler::weblogicHandleRequest");
            SOAPMessage soapMess = ((SOAPMessageContext)context).getMessage();
            wsdmMessageContext.setRequestSOAPMessage(soapMess);
            se = null;
            SOAPPart sp = null;
            sb = null;
            try {
                if (log.isDebugLogging().booleanValue()) {
                    log.debug("WsdmWebLogicGenericHandler::weblogicHandleRequest(...) soapMess = " + soapMess);
                }
                if (soapMess != null) {
                    sp = soapMess.getSOAPPart();
                    if (sp != null) {
                        se = sp.getEnvelope();
                    }
                    break block9;
                }
                log.error("WsdmWebLogicHandler::weblogicHandleRequest: SoapMess is null");
                return true;
            }
            catch (SOAPException e) {
                log.error("WsdmWebLogicHandler::weblogicHandleRequest: failed to handle request: " + (Object)((Object)e));
                return true;
            }
        }
        this.genericParse(se, sb, wsdmMessageContext, operationNamespace);
        if (operationNamespace == null || operationNamespace.equals("")) {
            operationNamespace = wsdmMessageContext.getPortName();
        }
        wsdmMessageContext.setOperationNameSpace(operationNamespace);
        this.wsdmHandlerUtil.observeRequest(wsdmMessageContext);
        context.setProperty("WSDM_TRANSID", (Object)wsdmMessageContext);
        if (se != null) {
            try {
                this.processCorrelationId(wsdmMessageContext, se, context);
            }
            catch (SOAPException e) {
                log.error("WsdmWebLogicHandler::weblogicHandleRequest: failed to handle request: " + (Object)((Object)e));
            }
        }
        return true;
    }

    private boolean wsdmHandleFault(MessageContext context) {
        int correlationCount = new CorrelationId().decrementCorrelationCount();
        WsdmMessageContext wsdmMessageContext = this.setupTransactionId(context);
        if (log.isDebugLogging().booleanValue()) {
            log.debug("WsdmWebLogicGenericHandler::wsdmHandleFault correlationCount=" + correlationCount);
            log.debug("WsdmWebLogicGenericHandler::wsdmHandleFault operationName= " + wsdmMessageContext.getOperationName());
        }
        if (wsdmMessageContext.getOperationNameSpace() == null || wsdmMessageContext.getOperationNameSpace().equals("")) {
            log.error("WsdmWebLogicGenericHandler::handleFault unable to get serviceName");
            return true;
        }
        if (wsdmMessageContext.getOperationName() == null || wsdmMessageContext.getOperationName().equals("")) {
            log.error("WsdmWebLogicGenericHandler::handleFault unable to get operationName");
            return true;
        }
        this.setNameCache(wsdmMessageContext.getOperationName(), wsdmMessageContext.getOperationNameSpace());
        SOAPMessage soapMess = ((SOAPMessageContext)context).getMessage();
        this.processSoapFault(soapMess, wsdmMessageContext);
        return true;
    }

    @Override
    protected WsdmMessageContext wsdmHandleResponse(MessageContext context) {
        int correlationCount = new CorrelationId().decrementCorrelationCount();
        if (log.isDebugLogging().booleanValue()) {
            log.debug("WsdmWebLogicGenericHandler wsdmHandleResponse correlationCount=" + correlationCount);
        }
        WsdmMessageContext wsdmMessageContext = super.wsdmHandleResponse(context);
        SOAPMessage soapMess = ((SOAPMessageContext)context).getMessage();
        wsdmMessageContext.setResponseSOAPMessage(soapMess);
        this.wsdmHandlerUtil.observeResponse(wsdmMessageContext);
        return wsdmMessageContext;
    }

    @Override
    public boolean hasSOAPHeader(MessageContext context, String headerName) {
        boolean headerFound;
        block4: {
            SOAPEnvelope envelope = null;
            SOAPPart sp = null;
            headerFound = false;
            SOAPMessage soapMess = ((SOAPMessageContext)context).getMessage();
            try {
                if (soapMess != null) {
                    SOAPHeader header;
                    sp = soapMess.getSOAPPart();
                    if (sp == null || (header = (envelope = sp.getEnvelope()).getHeader()) == null) break block4;
                    Iterator it = header.examineHeaderElements("http://www.ca.com/apm");
                    while (it.hasNext()) {
                        SOAPHeaderElement headerElement = (SOAPHeaderElement)it.next();
                        String hdrName = headerElement.getNodeName();
                        if (!hdrName.equals(headerName)) continue;
                        headerFound = true;
                        break block4;
                    }
                    break block4;
                }
                log.error("WsdmWebLogicHandler::hasSOAPHeader: SoapMess is null");
            }
            catch (SOAPException sOAPException) {
                log.error("WsdmWebLogicHandler::hasSOAPHeader: SoapMess is null");
            }
        }
        return headerFound;
    }

    @Override
    public void addSOAPHeader(MessageContext context, String headerName) {
        SOAPEnvelope envelope = null;
        SOAPPart sp = null;
        SOAPMessage soapMess = ((SOAPMessageContext)context).getMessage();
        try {
            if (soapMess != null) {
                sp = soapMess.getSOAPPart();
                if (sp != null) {
                    boolean headerFound = false;
                    headerFound = this.hasSOAPHeader(context, headerName);
                    if (!headerFound) {
                        envelope = sp.getEnvelope();
                        SOAPHeader header = envelope.getHeader();
                        SOAPElement headerElement = header.addChildElement(headerName, "", "http://www.ca.com/apm");
                        headerElement.addTextNode("WSDM_TRUE");
                        headerElement.addAttribute(envelope.createName("actor", envelope.getPrefix(), envelope.getNamespaceURI()), "http://www.ca.com/apm");
                        if (log.isDebugLogging().booleanValue()) {
                            log.debug("WsdmWebLogicGenericHandler::addSOAPHeader: add actor attribute ... " + envelope.getPrefix() + "::" + envelope.getNamespaceURI() + "::" + "http://www.ca.com/apm");
                        }
                    } else if (log.isDebugLogging().booleanValue()) {
                        log.debug("WsdmWebLogicGenericHandler::addSOAPHeader: soap header found ... " + headerName);
                    }
                } else {
                    log.debug("WsdmWebLogicGenericHandler::addSOAPHeader: soapMess.getSOAPPart() returns null.");
                }
            } else {
                log.error("WsdmWebLogicGenericHandler::addSOAPHeader: SoapMess is null");
            }
        }
        catch (SOAPException e) {
            log.error("WsdmWebLogicGenericHandler::addSOAPHeader: SOAPException while parsing SoapMess ... " + (Object)((Object)e));
        }
    }

    protected void cleanSOAPHeader(SOAPHeader header, SOAPHeaderElement headerElement) {
        header.removeChild((Node)headerElement);
    }
}

