/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.sqlagent.ICallbackOnObjectKeyNotFound;
import com.wily.introscope.agent.sqlagent.ProbeStatementIdToStatementMappingTracer;
import com.wily.introscope.agent.sqlagent.ProbeStatementToSQLMappingTracer;
import com.wily.introscope.agent.sqlagent.SQLAgentConfiguration;
import com.wily.introscope.agent.sqlagent.hc2.SQLObjectKeyHelper;
import com.wily.introscope.agent.trace.ICacheableBlameKeyNameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.introscope.agent.trace.jdbc.SQLNameFormatterUtilities;
import com.wily.util.WilyStringBuilder;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import java.sql.Connection;
import java.sql.Statement;

public class ProbeStatementNameFormatter
implements ICacheableBlameKeyNameFormatter,
ICallbackOnObjectKeyNotFound {
    private static final int kDebugErrorClamp = 50;
    private static volatile int nConsecutiveErrors = 0;
    private IModuleFeedbackChannel fFeedback;
    private IStringLocalizer fLocalizer;
    private SQLAgentConfiguration fConfiguration;
    private static final char[] kUrlPlaceHolder = new String("{url}").toCharArray();
    private static final char[] kDatabasePlaceHolder = new String("{database}").toCharArray();
    private static final char[] kCommandTypePlaceHolder = new String("{commandtype}").toCharArray();
    private static final char[] kQueryTypePlaceHolder = new String("{querytype}").toCharArray();
    private static final char[] kNormalizedSQLPlaceHolder = new String("{sql}").toCharArray();
    public static final String kNormalizedDynamicSQLCacheKey = "com.wily.introscope.agent.sqlagent.dynamic.query.normalized.sql.cache";
    private static ThreadLocal NameFormatterBuilder = new ThreadLocal(){

        protected Object initialValue() {
            return new WilyStringBuilder();
        }
    };

    public ProbeStatementNameFormatter(IAgent agent) {
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fLocalizer = agent.IAgent_getStringLocalizer();
        this.fConfiguration = SQLAgentConfiguration.getInstance(agent);
    }

    private Statement getStatement(InvocationData data) {
        Statement stmt = null;
        if (data.hasInvocationParametersAvailable()) {
            Object key = data.getInvocationParameterAsObject(0);
            stmt = ProbeStatementIdToStatementMappingTracer.getStatement(key);
        }
        return stmt;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        String result = name;
        try {
            if (name != null) {
                int urlIndex;
                int sqlIndex;
                int queryIndex;
                int cmdIndex;
                WilyStringBuilder bldr = (WilyStringBuilder)NameFormatterBuilder.get();
                bldr.setString(name);
                Statement stmt = this.getStatement(data);
                int dbIndex = bldr.indexOf(kDatabasePlaceHolder);
                if (dbIndex >= 0) {
                    bldr = bldr.replace(dbIndex, dbIndex + kDatabasePlaceHolder.length, this.getDatabaseName(this.fFeedback, data, stmt));
                }
                if ((cmdIndex = bldr.indexOf(kCommandTypePlaceHolder)) >= 0) {
                    bldr = bldr.replace(cmdIndex, cmdIndex + kCommandTypePlaceHolder.length, this.getCommandType(this.fFeedback, data, stmt));
                }
                if ((queryIndex = bldr.indexOf(kQueryTypePlaceHolder)) >= 0) {
                    bldr = bldr.replace(queryIndex, queryIndex + kQueryTypePlaceHolder.length, this.getQueryType(this.fFeedback, data, stmt));
                }
                if ((sqlIndex = bldr.indexOf(kNormalizedSQLPlaceHolder)) >= 0) {
                    bldr = bldr.replace(sqlIndex, sqlIndex + kNormalizedSQLPlaceHolder.length, this.getNormalizedSQL(this.fFeedback, data, stmt));
                }
                if ((urlIndex = bldr.indexOf(kUrlPlaceHolder)) >= 0) {
                    bldr = bldr.replace(urlIndex, urlIndex + kUrlPlaceHolder.length, this.getURL(this.fFeedback, data, stmt));
                }
                result = bldr.toString();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.fFeedback.error("An error occurred formatting database name.");
                this.fFeedback.verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    public String getURL(IModuleFeedbackChannel feedback, InvocationData data, Statement stmt) {
        Connection c = this.getConnection(feedback, data.getInvocationObject());
        return SQLNameFormatterUtilities.getSafeCachedURL((IModuleFeedbackChannel)feedback, (Connection)c);
    }

    @Override
    public String getURL(IModuleFeedbackChannel feedback, InvocationData data, Object conn) {
        Statement stmt = this.getStatement(data);
        Connection c = conn instanceof Connection ? (Connection)conn : this.getConnection(feedback, stmt);
        return SQLNameFormatterUtilities.getSafeCachedURL((IModuleFeedbackChannel)feedback, (Connection)c);
    }

    protected Connection getConnection(IModuleFeedbackChannel feedback, Object tracedObject) {
        Connection result;
        block12: {
            result = null;
            if (tracedObject != null) {
                if (tracedObject instanceof Statement) {
                    Statement stmt = (Statement)tracedObject;
                    try {
                        try {
                            result = stmt.getConnection();
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable throwable) {}
                        nConsecutiveErrors = 0;
                    }
                    catch (Exception sqle) {
                        if (++nConsecutiveErrors < 50) {
                            feedback.debug("An unexpected error occurred getting a database connection: ", (Throwable)sqle);
                        }
                        break block12;
                    }
                }
                if (tracedObject instanceof Connection) {
                    result = (Connection)tracedObject;
                } else {
                    feedback.debug("[StatementNameFormatter] unexpected traced object type: " + tracedObject.getClass().getName());
                }
            } else {
                feedback.debug("[StatementNameFormatter] traced object is null");
            }
        }
        return result;
    }

    public String getCommandType(IModuleFeedbackChannel feedback, InvocationData data, Object statement) {
        String commandType;
        block3: {
            try {
                Statement stmt = (Statement)statement;
                commandType = ProbeStatementToSQLMappingTracer.getSQLType(stmt);
                if (commandType != null) break block3;
                return "Dynamic";
            }
            catch (Exception e) {
                feedback.debug("An error occurred while attempting to get command type: ", (Throwable)e);
                return "Unknown";
            }
        }
        return commandType;
    }

    public String getQueryType(IModuleFeedbackChannel feedback, InvocationData data, Object statement) {
        String queryType;
        block3: {
            try {
                Statement stmt = (Statement)statement;
                queryType = ProbeStatementToSQLMappingTracer.getSQLOPType(stmt);
                if (queryType != null) break block3;
                return "Query";
            }
            catch (Exception e) {
                feedback.debug("An error occurred while attempting to get query type: ", (Throwable)e);
                return "Unknown";
            }
        }
        return queryType;
    }

    public IBlameComponent getKey(IModuleFeedbackChannel feedback, String name, InvocationData data) {
        Object key = data.getInvocationParameterAsObject(0);
        if (key != null) {
            Statement stmt = ProbeStatementIdToStatementMappingTracer.getStatement(key);
            if (stmt != null) {
                try {
                    String normalizedSQL = this.getNormalizedSQL(feedback, data, stmt);
                    Object URL2 = SQLObjectKeyHelper.getURL(data, feedback, this.getConnection(feedback, stmt), this);
                    return ABlameComponent.getArrayInstance((Object[])new Object[]{name, URL2, normalizedSQL});
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public Object getObjectKey(IModuleFeedbackChannel feedback, int tracerIndex, InvocationData data) {
        return null;
    }

    public String getNormalizedSQL(IModuleFeedbackChannel feedback, InvocationData data, Statement stmt) {
        return ProbeStatementNameFormatter.getNormalizedSQL(feedback, data, this.fConfiguration.getNormalizedMaxSQLLength(), stmt);
    }

    public String getDatabaseName(IModuleFeedbackChannel feedback, InvocationData data, Statement stmt) {
        String name = null;
        try {
            Connection conn = this.getConnection(feedback, stmt);
            SQLNameFormatterUtilities utilities = SQLNameFormatterUtilities.getInstance();
            name = utilities.getFormattedString(conn, this.getURL(feedback, data, conn), this.fFeedback, this.fLocalizer);
        }
        catch (Exception exception) {}
        if (name == null) {
            name = "Unknown Driver";
        }
        return name;
    }

    public static String getNormalizedSQL(IModuleFeedbackChannel feedback, InvocationData data, int maxLength, Statement stmt) {
        String normalizedSQLForMetricName = null;
        try {
            normalizedSQLForMetricName = ProbeStatementToSQLMappingTracer.getSQL(stmt);
        }
        catch (Throwable e) {
            normalizedSQLForMetricName = null;
            try {
                feedback.error("Failed to normalize SQL.");
                feedback.verbose(e);
            }
            catch (Throwable throwable) {}
        }
        if (normalizedSQLForMetricName == null) {
            normalizedSQLForMetricName = "Unknown SQL";
        }
        return normalizedSQLForMetricName;
    }

    public static String getNormalizedSQLForUserView(IModuleFeedbackChannel feedback, InvocationData data, int maxLength, Statement stmt) {
        String normalizedSQLForUserView = ProbeStatementToSQLMappingTracer.getSQL(stmt, false);
        if (normalizedSQLForUserView == null) {
            normalizedSQLForUserView = "Unknown SQL";
        }
        return normalizedSQLForUserView;
    }
}

