/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.resource;

import com.wily.util.resource.IResource;
import com.wily.util.resource.IResourceReader;
import com.wily.util.resource.IResourceWriter;
import com.wily.util.resource.systemresource.InvalidSystemResourceException;
import com.wily.util.resource.systemresource.SystemResource;
import com.wily.util.resource.systemresource.SystemResourceBasedResourceReader;
import com.wily.util.resource.systemresource.SystemResourceBasedResourceWriter;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class SystemResourceBasedResource
implements IResource {
    private final SystemResource fSource;
    private final IStringLocalizer fLocalizer;

    public SystemResourceBasedResource(String name, IStringLocalizer localizer) throws InvalidSystemResourceException {
        this(new SystemResource(name, true), localizer);
    }

    public SystemResourceBasedResource(SystemResource source, IStringLocalizer localizer) {
        Assertion.wilyAssert(false);
        this.fSource = source;
        this.fLocalizer = localizer;
    }

    private IStringLocalizer getStringLocalizer() {
        return this.fLocalizer;
    }

    public boolean IResource_isFileResource() {
        return false;
    }

    public String IResource_getLocation() {
        return this.fSource.toString();
    }

    public URL IResource_getURL() throws MalformedURLException {
        return this.fSource.getURL();
    }

    public InputStream IResource_getContents() throws IOException {
        return this.fSource.getInputStream();
    }

    public FileReader IResource_getSourceContents() throws IOException {
        return null;
    }

    public IResourceReader IResource_getResourceReader() {
        return new SystemResourceBasedResourceReader(this.fSource);
    }

    public IResourceWriter IResource_getResourceWriter() {
        return new SystemResourceBasedResourceWriter(this.fSource, this.getStringLocalizer());
    }
}

