/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge.profile;

import com.wily.introscope.agent.upgrade.merge.IMergeable;
import com.wily.introscope.agent.upgrade.merge.IRulesEngine;
import com.wily.introscope.agent.upgrade.merge.Line;
import com.wily.introscope.agent.upgrade.merge.profile.Key;
import com.wily.introscope.agent.upgrade.merge.profile.Value;
import com.wily.introscope.agent.upgrade.merge.util.UpgradeUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Profile
implements IMergeable<Profile> {
    private List<Line> fHeader = new ArrayList<Line>();
    private Map<String, Key> fGroupMap = new HashMap<String, Key>();
    private Map<Key, List<Value>> fEntryMap = new LinkedHashMap<Key, List<Value>>();
    private Map<Key, List<Value>> fFinalMergedMap;
    private List<Key> fKeyOrderList = new LinkedList<Key>();

    public Profile() {
        this.fFinalMergedMap = new LinkedHashMap<Key, List<Value>>();
    }

    public List<Line> getHeader() {
        return Collections.unmodifiableList(this.fHeader);
    }

    public void setHeader(List<Line> header) {
        this.fHeader.clear();
        for (Line line : header) {
            this.fHeader.add(line);
        }
    }

    public void add(Key key, Value value) {
        this.fGroupMap.put(key.getGroup(), key);
        List<Object> values = null;
        if (!this.fEntryMap.containsKey(key)) {
            values = new ArrayList();
            this.fEntryMap.put(key, values);
        } else {
            values = this.fEntryMap.get(key);
        }
        values.add(value);
    }

    public Set<Key> getKeys() {
        return Collections.unmodifiableSet(this.fEntryMap.keySet());
    }

    public static Profile read(BufferedReader reader) throws IOException {
        Profile profile = new Profile();
        int header = 0;
        ArrayList<Line> comments = new ArrayList<Line>();
        String line = null;
        int count = 0;
        while ((line = reader.readLine()) != null) {
            ++count;
            if (UpgradeUtil.isCompleteHashedLine(line)) {
                comments.add(new Line(line, count));
                if (header == 1) {
                    profile.setHeader(comments);
                    comments.clear();
                }
                ++header;
                continue;
            }
            if (UpgradeUtil.isBlank(line)) {
                comments.add(new Line("", count));
                continue;
            }
            if (line.trim().startsWith("#")) {
                boolean success = Profile.isCommentedKey(profile, line, comments);
                if (success) {
                    comments.clear();
                    continue;
                }
                comments.add(new Line(line, count));
                continue;
            }
            Profile.handleKey(profile, line, comments, false);
            comments.clear();
        }
        return profile;
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write(this.getProfile());
        writer.flush();
    }

    @Override
    public Profile merge(Profile otherProfile) {
        Profile profile = new Profile();
        profile.setHeader(otherProfile.fHeader);
        HashSet<Key> commonKeys = new HashSet<Key>();
        for (Key key : this.fEntryMap.keySet()) {
            if (otherProfile.fEntryMap.containsKey(key)) {
                commonKeys.add(key);
                List<Value> lvalues = this.fEntryMap.get(key);
                boolean uncommentedKeyFlag = false;
                for (Value value : lvalues) {
                    profile.add(key, value);
                    if (value.isCommented()) continue;
                    uncommentedKeyFlag = true;
                }
                List<Value> rvalues = otherProfile.fEntryMap.get(key);
                Iterator iterator = rvalues.iterator();
                while (iterator.hasNext()) {
                    Value value = (Value)iterator.next();
                    if (lvalues.contains(value)) continue;
                    if (!value.isCommented() && uncommentedKeyFlag) {
                        profile.add(key, new Value(value.getValue(), true, new ArrayList<Line>()));
                        continue;
                    }
                    profile.add(key, value);
                }
                continue;
            }
            List<Value> values = this.fEntryMap.get(key);
            for (Value value : values) {
                profile.add(key, value);
            }
        }
        for (Key key : otherProfile.fEntryMap.keySet()) {
            if (commonKeys.contains(key)) continue;
            int index = this.fKeyOrderList.indexOf(this.fGroupMap.get(key.getGroup()));
            if (index != -1) {
                this.fKeyOrderList.add(index + 1, key);
            } else {
                this.fKeyOrderList.add(key);
            }
            this.fGroupMap.put(key.getGroup(), key);
            List<Value> values = otherProfile.fEntryMap.get(key);
            for (Value value : values) {
                profile.add(key, value);
            }
        }
        commonKeys.clear();
        for (Key key : this.fKeyOrderList) {
            this.fFinalMergedMap.put(key, profile.fEntryMap.get(key));
        }
        profile.fEntryMap = this.fFinalMergedMap;
        return profile;
    }

    @Override
    public Profile merge(Profile otherProfile, IRulesEngine engine) {
        Profile profile = new Profile();
        profile.setHeader(otherProfile.fHeader);
        LinkedHashMap<Key, List<Value>> finalMergedMap = new LinkedHashMap<Key, List<Value>>();
        LinkedList<Key> keyOrderList = new LinkedList<Key>();
        for (Key key : this.fEntryMap.keySet()) {
            keyOrderList.add(key);
        }
        HashSet<Key> commonKeys = new HashSet<Key>();
        for (Key key : this.fEntryMap.keySet()) {
            if (engine.isEntryDelete(IRulesEngine.MergeableType.PROFILE, key)) {
                keyOrderList.remove(key);
                continue;
            }
            if (otherProfile.fEntryMap.containsKey(key)) {
                commonKeys.add(key);
                IRulesEngine.PreferenceType type = engine.getPreferredType(IRulesEngine.MergeableType.PROFILE, key);
                if (type == IRulesEngine.PreferenceType.CURRENT) {
                    this.handleCommonKey(key, profile, this, otherProfile);
                    continue;
                }
                if (type != IRulesEngine.PreferenceType.UPGRADE) continue;
                this.handleCommonKey(key, profile, otherProfile, this);
                continue;
            }
            List<Value> values = this.fEntryMap.get(key);
            for (Value value : values) {
                profile.add(key, value);
            }
        }
        this.handleNonCollidingKeys(commonKeys, profile, otherProfile, keyOrderList);
        commonKeys.clear();
        for (Key key : keyOrderList) {
            finalMergedMap.put(key, profile.fEntryMap.get(key));
        }
        profile.fEntryMap = finalMergedMap;
        return profile;
    }

    private void handleCommonKey(Key key, Profile profile, Profile preferredProfile, Profile otherProfile) {
        List<Value> lvalues = preferredProfile.fEntryMap.get(key);
        boolean uncommentedKeyFlag = false;
        for (Value value : lvalues) {
            profile.add(key, value);
            if (value.isCommented()) continue;
            uncommentedKeyFlag = true;
        }
        List<Value> rvalues = otherProfile.fEntryMap.get(key);
        for (Value value : rvalues) {
            if (lvalues.contains(value)) continue;
            if (!value.isCommented() && uncommentedKeyFlag) {
                profile.add(key, new Value(value.getValue(), true, new ArrayList<Line>()));
                continue;
            }
            profile.add(key, value);
        }
    }

    private void handleNonCollidingKeys(Set<Key> commonKeys, Profile profile, Profile otherProfile, List<Key> keyOrderList) {
        for (Key key : otherProfile.fEntryMap.keySet()) {
            if (commonKeys.contains(key)) continue;
            int index = keyOrderList.indexOf(this.fGroupMap.get(key.getGroup()));
            if (index != -1) {
                keyOrderList.add(index + 1, key);
            } else {
                keyOrderList.add(key);
            }
            this.fGroupMap.put(key.getGroup(), key);
            List<Value> values = otherProfile.fEntryMap.get(key);
            for (Value value : values) {
                profile.add(key, value);
            }
        }
        commonKeys.clear();
    }

    public void clear() {
        this.fGroupMap.clear();
        for (List<Value> values : this.fEntryMap.values()) {
            values.clear();
        }
        this.fEntryMap.clear();
    }

    private static boolean isCommentedKey(Profile profile, String line, List<Line> comments) {
        boolean success = false;
        if (line.trim().startsWith("#")) {
            line = line.trim();
            String modLine = "";
            int i = 0;
            while (i < line.length()) {
                if (line.charAt(i) != '#') {
                    modLine = line.substring(i);
                    break;
                }
                ++i;
            }
            modLine = modLine.trim();
            String[] tokens = line.trim().split("=");
            if (tokens.length == 2 || modLine.endsWith("=")) {
                success = Profile.handleKey(profile, modLine, comments, true);
            }
        }
        return success;
    }

    private static boolean handleKey(Profile profile, String line, List<Line> comments, boolean commented) {
        boolean success = false;
        String[] tokens = line.trim().split("=");
        if (line.trim().endsWith("=") && tokens.length == 1) {
            Key key = new Key(tokens[0]);
            Value value = new Value("", commented, comments);
            profile.add(key, value);
            success = true;
        } else if (tokens.length == 2) {
            Key key = new Key(tokens[0]);
            Value value = new Value(tokens[1], commented, comments);
            profile.add(key, value);
            success = true;
        }
        return success;
    }

    public String toString() {
        StringBuilder strBldr = new StringBuilder("Class: Profile\n");
        strBldr.append(this.getProfile());
        return strBldr.toString();
    }

    private String getProfile() {
        StringBuilder strBldr = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        for (Line line : this.fHeader) {
            strBldr.append(line).append(newLine);
        }
        for (Key key : this.fEntryMap.keySet()) {
            List<Value> values = this.fEntryMap.get(key);
            if (values.isEmpty()) continue;
            for (Value value : values) {
                List<Line> lines = value.getComments();
                for (Line line : lines) {
                    strBldr.append(line.getContent()).append(newLine);
                }
                if (value.isCommented()) {
                    strBldr.append("#");
                }
                strBldr.append(String.valueOf(key.getKey()) + "=" + value.getValue()).append(newLine);
            }
        }
        return strBldr.toString();
    }
}

