/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.v1;

import com.wily.isengard.message.AMessage;
import com.wily.isengard.message.PingMessage;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.CorruptedMessage;
import com.wily.isengard.postoffice.MessageUndeliverableMessage;
import com.wily.isengard.postofficehub.link.NonTerminalIOException;
import com.wily.isengard.postofficehub.link.v1.ABaseTransport;
import com.wily.isengard.postofficehub.link.v1.AMessageDeliveryTask;
import com.wily.isengard.postofficehub.link.v1.CacheCorruptionException;
import com.wily.isengard.postofficehub.link.v1.IsengardObjectInputStream;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.wilyassert.Assertion;
import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import java.net.SocketException;

public class IncomingMessageDeliveryTask
extends AMessageDeliveryTask {
    private static Module sModule = new Module("IncomingMessageDeliveryTask");
    private final IsengardObjectInputStream fObjectInput;
    static /* synthetic */ Class class$0;

    public IncomingMessageDeliveryTask(IsengardObjectInputStream objectInput, ABaseTransport transport) {
        super(transport, sModule);
        this.fObjectInput = objectInput;
        this.setContinueDelivery();
    }

    public int deliverNextMessage(boolean waitForData) {
        int numHandled;
        block49: {
            Address destination = null;
            numHandled = 0;
            try {
                String errMsg;
                IsengardObjectInputStream objectInput = this.fObjectInput;
                boolean isTraceEnabled = this.fIsTraceEnabled;
                boolean messageOK = false;
                Throwable readMessageFailureCause = null;
                AMessage message = null;
                objectInput.setLastMessageSourceAddress(null);
                long startTime = 0L;
                if (this.fIsTraceEnabled) {
                    startTime = System.currentTimeMillis();
                }
                long readTime = 0L;
                long routeTime = 0L;
                destination = (Address)objectInput.readObject();
                try {
                    message = (AMessage)objectInput.readObject();
                    Assertion.wilyAssert(message != null, "Message should not be null.");
                    messageOK = true;
                    ++numHandled;
                    if (this.fIsTraceEnabled) {
                        readTime = System.currentTimeMillis();
                    }
                }
                catch (InvalidClassException e) {
                    messageOK = false;
                    readMessageFailureCause = e;
                    errMsg = "Caught exception while deserializing object: " + e;
                    if (this.getFeedbackChannel().isDebugEnabled(sModule)) {
                        this.getFeedbackChannel().debug(sModule, errMsg, e);
                    } else {
                        this.getFeedbackChannel().verbose(sModule, errMsg);
                    }
                }
                catch (NoClassDefFoundError e) {
                    messageOK = false;
                    readMessageFailureCause = e;
                    errMsg = "Caught exception while deserializing object: " + e;
                    if (this.getFeedbackChannel().isDebugEnabled(sModule)) {
                        this.getFeedbackChannel().debug(sModule, errMsg, e);
                    } else {
                        this.getFeedbackChannel().verbose(sModule, errMsg);
                    }
                }
                catch (ClassNotFoundException e) {
                    messageOK = false;
                    readMessageFailureCause = e;
                    errMsg = "Caught exception while deserializing object: " + e;
                    if (this.getFeedbackChannel().isDebugEnabled(sModule)) {
                        this.getFeedbackChannel().debug(sModule, errMsg, e);
                    }
                    this.getFeedbackChannel().verbose(sModule, errMsg);
                }
                Assertion.wilyAssert(destination != null, "Destination should not be null.");
                if (messageOK) {
                    if (message.getShouldTrace()) {
                        this.getFeedbackChannel().info("Deserialized message: " + message);
                    }
                    if (isTraceEnabled) {
                        this.getFeedbackChannel().trace(sModule, "Received " + message.toString(destination));
                    }
                    if (!(message instanceof PingMessage)) {
                        message.setRemoteHost(this.getTransport().getRouteConnectionInfo());
                        this.getTransport().routeMessage(message, destination);
                    }
                } else {
                    Address source = objectInput.getLastMessageSourceAddress();
                    if (source == null) {
                        source = destination;
                    }
                    if (source != null) {
                        MessageUndeliverableMessage reportError = new MessageUndeliverableMessage("Cannot deserialize message.", readMessageFailureCause);
                        this.getTransport().routeMessage(reportError, source);
                    }
                }
                if (!this.fIsTraceEnabled) break block49;
                routeTime = System.currentTimeMillis();
                if (readTime - startTime <= 10000L) break block49;
                IModuleFeedbackChannel iModuleFeedbackChannel = this.getFeedbackChannel();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.wily.isengard.postofficehub.link.v1.IncomingMessageDeliveryTask");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                iModuleFeedbackChannel.trace(sModule, String.valueOf(clazz.getName()) + " read time " + (readTime - startTime) + " route time " + (routeTime - readTime) + " message is from " + message.getRemoteHost() + " of type " + message);
            }
            catch (ClassNotFoundException e) {
                String message = "Unrecoverable connection exception";
                if (this.getFeedbackChannel().isDebugEnabled(sModule)) {
                    this.getFeedbackChannel().debug(sModule, message, e);
                } else {
                    this.getFeedbackChannel().verbose(sModule, message);
                }
                this.setStopDelivery();
            }
            catch (StreamCorruptedException e) {
                String message = "Corrupted stream while reading from node at: " + this.getTransport();
                if (this.getFeedbackChannel().isDebugEnabled(sModule)) {
                    this.getFeedbackChannel().debug(sModule, message, e);
                } else {
                    this.getFeedbackChannel().verbose(sModule, message);
                }
                this.setStopDelivery();
                this.getTransport().incrementCorruptedMessageCount();
            }
            catch (ObjectStreamException e) {
                String message = "Caught an exception reading from hub";
                if (this.getFeedbackChannel().isDebugEnabled(sModule)) {
                    this.getFeedbackChannel().debug(sModule, message, e);
                } else {
                    this.getFeedbackChannel().verbose(sModule, message);
                }
                this.setStopDelivery();
            }
            catch (SocketException e) {
                if (!this.getTransport().isClosed()) {
                    String message = "Unrecoverable socket exception while reading from node at" + this.getTransport();
                    if (this.getFeedbackChannel().isDebugEnabled(sModule)) {
                        this.getFeedbackChannel().debug(sModule, message, e);
                    } else {
                        this.getFeedbackChannel().verbose(sModule, message);
                    }
                }
                this.setStopDelivery();
            }
            catch (NonTerminalIOException e) {
                this.getFeedbackChannel().debug(sModule, "Recoverable socket exception while reading from node at: " + this.getTransport(), e);
                if (e.isMethodCallResult()) {
                    MessageUndeliverableMessage undeliverable = new MessageUndeliverableMessage("The result message failed to deserialize because of an Exception", e);
                    if (destination != null) {
                        this.getTransport().routeMessage(undeliverable, destination);
                    }
                }
            }
            catch (EOFException e) {
                String message = "Unexpected end of stream while reading from node at: " + this.getTransport();
                if (this.getFeedbackChannel().isDebugEnabled(sModule)) {
                    this.getFeedbackChannel().debug(sModule, message, e);
                } else {
                    this.getFeedbackChannel().verbose(sModule, message);
                }
                this.setStopDelivery();
                this.getTransport().incrementCorruptedMessageCount();
            }
            catch (CacheCorruptionException e) {
                String message = "Cannot deserialize message while reading from node at: " + this.getTransport();
                this.getFeedbackChannel().error(sModule, message, e);
                this.setStopDelivery();
                if (destination != null) {
                    CorruptedMessage reportError = new CorruptedMessage(e);
                    this.getTransport().routeMessage(reportError, destination);
                }
            }
            catch (IOException e) {
                String message = "Unrecoverable socket exception while reading from node at: " + this.getTransport();
                if (this.getFeedbackChannel().isDebugEnabled(sModule)) {
                    this.getFeedbackChannel().debug(sModule, message, e);
                } else {
                    this.getFeedbackChannel().verbose(sModule, message);
                }
                this.setStopDelivery();
            }
            catch (Throwable e) {
                String message = "Unrecoverable exception while reading from " + this.getTransport();
                if (this.getFeedbackChannel().isDebugEnabled(sModule)) {
                    this.getFeedbackChannel().debug(sModule, message, e);
                } else {
                    this.getFeedbackChannel().verbose(sModule, message);
                }
                this.setStopDelivery();
            }
        }
        return numHandled;
    }
}

