/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.hawk;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public class ProcessDefsMonitor
implements ITimestampedRunnable {
    private final IAgent iAgent;
    private static ProcessDefsMonitor instance = null;
    private DataAccumulatorFactory dataAccumulatorFactory;
    private ArrayList<Object> methodObjectList = new ArrayList();
    private static final String comp = "ProcessDefs";
    private Object activitiesMethodObject = null;
    private static final String kName = "Name";
    private static final String kStarter = "Starter";
    private static final String kTracing = "Tracing";
    private static final String kLastReturnCode = "LastReturnCode";
    private static final String kCalledProcessDefs = "CalledProcessDefs";
    private static final String kActivityClass = "ActivityClass";

    public ProcessDefsMonitor(IAgent agent) {
        instance = this;
        this.iAgent = agent;
        this.dataAccumulatorFactory = agent.IAgent_getDataAccumulatorFactory();
    }

    public static ProcessDefsMonitor getInstance(IAgent agent) {
        if (instance == null) {
            instance = new ProcessDefsMonitor(agent);
        }
        return instance;
    }

    public void init() {
    }

    public void ITimestampedRunnable_execute(long arg0) {
        try {
            for (Object obj : this.methodObjectList) {
                this.getProcessDefsMetrics(obj);
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.iAgent, "ERROR_IN_HAWKMONITOR_PROCESSDEFS", bomb);
        }
    }

    private void getProcessDefsMetrics(Object methodObj) {
        String processName = null;
        int limit = 21;
        try {
            TibcoBWUtils.getLogger().debug("ProcessDefsMonitor.getProcessDefsMetrics()");
            Class<?> amiParameterList = Class.forName("COM.TIBCO.hawk.ami.AmiParameterList", false, ClassLoader.getSystemClassLoader());
            Object result = TibcoBWUtils.invokeMethodOnObject(methodObj, "onInvoke", new Class[]{amiParameterList}, new Object[1]);
            if (result != null) {
                Integer size = (Integer)TibcoBWUtils.invokeMethodOnObject(result, "size");
                TibcoBWUtils.getLogger().debug("ProcessDefs Size: " + size);
                int i = 0;
                while (i < size) {
                    Object param = TibcoBWUtils.invokeMethodOnObject(result, "getParameter", new Class[]{Integer.TYPE}, new Object[]{new Integer(i)});
                    if (param != null) {
                        String name = (String)TibcoBWUtils.invokeMethodOnObject(param, "getName");
                        Object value = TibcoBWUtils.invokeMethodOnObject(param, "getValue");
                        if (i % limit == 0) {
                            processName = value.toString();
                            if (TibcoBWUtils.getHawkPropertyValue("com.wily.soaextension.tibcobw.hawkmonitor.activities")) {
                                this.getActivitiesMetrics(processName);
                            }
                        }
                        if (value != null) {
                            TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": " + value.toString());
                            this.reportMetric("ProcessDefs|" + processName, name, value.toString());
                        } else {
                            TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": NULL");
                            this.reportMetric("ProcessDefs|" + processName, name, "");
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.iAgent, "ERROR_IN_HAWKMONITOR_PROCESSDEFS", bomb);
        }
    }

    private void getActivitiesMetrics(String processName) {
        String activityName = null;
        int limit = 18;
        try {
            TibcoBWUtils.getLogger().debug("ProcessDefsMonitor.getActivitiesMetrics()");
            Class<?> amiParameterList = Class.forName("COM.TIBCO.hawk.ami.AmiParameterList", false, ClassLoader.getSystemClassLoader());
            Class<?> amiParameter = Class.forName("COM.TIBCO.hawk.ami.AmiParameter", false, ClassLoader.getSystemClassLoader());
            Class[] stringArgClass = new Class[]{String.class, String.class, Object.class};
            Constructor<?> constAmiParameter = amiParameter.getConstructor(stringArgClass);
            Object[] amiElement = new Object[]{"ProcessDefName", "", processName};
            Object amiParObject = constAmiParameter.newInstance(amiElement);
            Constructor<?> constAmiParameterList = amiParameterList.getConstructor(null);
            Object amiParListObject = constAmiParameterList.newInstance(new Object[0]);
            TibcoBWUtils.invokeMethodOnObject(amiParListObject, "add", new Class[]{amiParameter}, new Object[]{amiParObject});
            Object result = TibcoBWUtils.invokeMethodOnObject(this.activitiesMethodObject, "onInvoke", new Class[]{amiParameterList}, new Object[]{amiParListObject});
            if (result != null) {
                Integer size = (Integer)TibcoBWUtils.invokeMethodOnObject(result, "size");
                TibcoBWUtils.getLogger().debug("ActivitiesMetric Size: " + size);
                int i = 1;
                while (i < size) {
                    Object param = TibcoBWUtils.invokeMethodOnObject(result, "getParameter", new Class[]{Integer.TYPE}, new Object[]{new Integer(i)});
                    if (param != null) {
                        String name = (String)TibcoBWUtils.invokeMethodOnObject(param, "getName");
                        Object value = TibcoBWUtils.invokeMethodOnObject(param, "getValue");
                        if (i % limit == 1) {
                            activityName = value.toString();
                        }
                        if (i % limit != 0) {
                            if (value != null) {
                                TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": " + value.toString());
                                this.reportActivityMetric("ProcessDefs|" + processName + "|" + activityName, name, value.toString());
                            } else {
                                TibcoBWUtils.getLogger().debug(String.valueOf(name) + ": NULL");
                                this.reportActivityMetric("ProcessDefs|" + processName + "|" + activityName, name, "");
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.iAgent, "ERROR_IN_HAWKMONITOR_ACTIVITIES", bomb);
        }
    }

    private void reportMetric(String component, String name, String value) {
        try {
            if (name.equals(kName) || name.equals(kStarter)) {
                this.dataAccumulatorFactory.safeGetStringEveryEventDataAccumulator("Tibco|Hawk Metrics|" + component + ":" + name).IStringEveryEventDataAccumulator_addString(TibcoBWUtils.formatToBeResourceSafe(value));
            } else {
                if (value == "") {
                    value = "0";
                }
                this.dataAccumulatorFactory.safeGetLongFluctuatingCounterDataAccumulator("Tibco|Hawk Metrics|" + component + ":" + name).ILongCounterDataAccumulator_setValue(new Long(value).longValue());
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.iAgent, "ERROR_IN_HAWKMONITOR_PROCESSDEFS", bomb);
        }
    }

    private void reportActivityMetric(String component, String name, String value) {
        try {
            if (name.equals(kName) || name.equals(kTracing) || name.equals(kLastReturnCode) || name.equals(kCalledProcessDefs) || name.equals(kActivityClass)) {
                this.dataAccumulatorFactory.safeGetStringEveryEventDataAccumulator("Tibco|Hawk Metrics|" + component + ":" + name).IStringEveryEventDataAccumulator_addString(TibcoBWUtils.formatToBeResourceSafe(value));
            } else {
                if (value == null) {
                    value = "0";
                }
                this.dataAccumulatorFactory.safeGetLongFluctuatingCounterDataAccumulator("Tibco|Hawk Metrics|" + component + ":" + name).ILongCounterDataAccumulator_setValue(new Long(value).longValue());
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.iAgent, "ERROR_IN_HAWKMONITOR_ACTIVITIES", bomb);
        }
    }

    public void registerMethodObject(Object methodObj) {
        this.methodObjectList.add(methodObj);
    }

    public void deRegisterMethodObject(Object methodObj) {
        this.methodObjectList.remove(methodObj);
    }

    public void registerActivitiesMethodObject(Object methodObj) {
        this.activitiesMethodObject = methodObj;
    }
}

