/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.rv;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.soaextension.tibcobw.KConstants;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class RVQAndQueueGroupMonitor
implements ITimestampedRunnable,
KConstants {
    private final IAgent fAgent;
    private static RVQAndQueueGroupMonitor sInstance = null;
    private DataAccumulatorFactory fDataAccumulatorFactory = null;
    private List fMonitorPool = new ArrayList();
    private Class fQueueType = null;
    private Class fQueueGroupType = null;
    private Field queueGroupField = null;
    private static final Object lock = new Object();

    private void init() {
        try {
            this.fQueueType = Class.forName("com.tibco.tibrv.TibrvQueue", false, ClassLoader.getSystemClassLoader());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            this.fQueueGroupType = Class.forName("com.tibco.tibrv.TibrvQueueGroup", false, ClassLoader.getSystemClassLoader());
            try {
                this.queueGroupField = this.fQueueGroupType.getDeclaredField(kF_TibrvQueueGroup_queues);
                this.queueGroupField.setAccessible(true);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public RVQAndQueueGroupMonitor(IAgent agent) {
        sInstance = this;
        this.fAgent = agent;
        this.fDataAccumulatorFactory = this.fAgent.IAgent_getDataAccumulatorFactory();
        this.init();
    }

    public static RVQAndQueueGroupMonitor getInstance(IAgent agent) {
        if (sInstance == null) {
            sInstance = new RVQAndQueueGroupMonitor(agent);
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ITimestampedRunnable_execute(long l) {
        Object object = lock;
        synchronized (object) {
            try {
                for (Object obj : this.fMonitorPool) {
                    if (obj.getClass().equals(this.fQueueType)) {
                        this.reportQueueMetric(obj, "Tibco|Transports|RV|Queues|");
                    }
                    if (!obj.getClass().equals(this.fQueueGroupType)) continue;
                    this.reportQueueGroupMetric(obj, "Tibco|Transports|RV|Queue Groups|");
                }
            }
            catch (Throwable bomb) {
                TibcoBWUtils.handleError(this.fAgent, "Error while monitoring Queue", bomb);
            }
        }
    }

    private int getCurrentEventFromQueue(Object queueObject) {
        int currentEvents = 0;
        try {
            currentEvents = (Integer)TibcoBWUtils.invokeMethodOnObject(queueObject, kM_TibrvQueue_getCount);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return currentEvents;
    }

    private int getDiscardedEventFromQueue(Object queueObject) {
        int discardedEvents = 0;
        try {
            discardedEvents = (Integer)TibcoBWUtils.invokeMethodOnObject(queueObject, kM_TibrvQueue_getDiscardAmount);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return discardedEvents;
    }

    private int getMaxEventFromQueue(Object queueObject) {
        int maxEvents = 0;
        try {
            maxEvents = (Integer)TibcoBWUtils.invokeMethodOnObject(queueObject, kM_TibrvQueue_getMaxEvents);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return maxEvents;
    }

    private void reportQueueMetric(Object queueObject, String metricPath) {
        String queueName = "UnknownQueue";
        try {
            queueName = (String)TibcoBWUtils.invokeMethodOnObject(queueObject, kM_TibrvQueue_getName);
            StringBuilder queueMetricPath = new StringBuilder(metricPath);
            queueMetricPath.append(queueName);
            queueMetricPath.append(":");
            this.fDataAccumulatorFactory.safeGetIntegerAverageDataAccumulator(queueMetricPath + "Current Events").IIntegerAggregatingDataAccumulator_recordDataPoint(this.getCurrentEventFromQueue(queueObject));
            this.fDataAccumulatorFactory.safeGetIntegerAverageDataAccumulator(queueMetricPath + "Maximum Events").IIntegerAggregatingDataAccumulator_recordDataPoint(this.getDiscardedEventFromQueue(queueObject));
            this.fDataAccumulatorFactory.safeGetIntegerAverageDataAccumulator(queueMetricPath + "Discarded Events").IIntegerAggregatingDataAccumulator_recordDataPoint(this.getMaxEventFromQueue(queueObject));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void reportQueueGroupMetric(Object queueGroupObject, String metricPath) {
        int totalCurrentEvents = 0;
        int totalDiscardedEvents = 0;
        try {
            StringBuilder queueGroupMetricPath = new StringBuilder(metricPath);
            queueGroupMetricPath.append("TibrvQueueGroup");
            queueGroupMetricPath.append(":");
            Vector queueGroup = (Vector)this.queueGroupField.get(queueGroupObject);
            for (Object queueObject : queueGroup) {
                totalCurrentEvents += this.getCurrentEventFromQueue(queueObject);
                totalDiscardedEvents += this.getDiscardedEventFromQueue(queueObject);
            }
            this.fDataAccumulatorFactory.safeGetIntegerAverageDataAccumulator(queueGroupMetricPath + "Total Current Events").IIntegerAggregatingDataAccumulator_recordDataPoint(totalCurrentEvents);
            this.fDataAccumulatorFactory.safeGetIntegerAverageDataAccumulator(queueGroupMetricPath + "Total Discarded Events").IIntegerAggregatingDataAccumulator_recordDataPoint(totalDiscardedEvents);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerItem(Object queueObj) {
        Object object = lock;
        synchronized (object) {
            TibcoBWUtils.getLogger().debug("Registering Object");
            this.fMonitorPool.add(queueObj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deRegisterItem(Object queueObj) {
        Object object = lock;
        synchronized (object) {
            TibcoBWUtils.getLogger().debug("Deregistering Object");
            this.fMonitorPool.remove(queueObj);
        }
    }
}

