/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.file;

import com.wily.util.file.FileUtils;
import com.wily.util.string.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class PropertyFileUtils {
    public static Properties convertFileToProperties(String fileStr) {
        return PropertyFileUtils.convertFileToProperties(new File(fileStr));
    }

    public static Properties convertFileToProperties(File file) {
        Properties props = new Properties();
        if (file.exists()) {
            try {
                FileInputStream input = new FileInputStream(file);
                props.load(input);
                input.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return props;
    }

    public static boolean propertyExistsInTable(String prop, Properties propTable) {
        boolean result = false;
        Enumeration<?> propEnum = propTable.propertyNames();
        while (propEnum.hasMoreElements()) {
            String key = propEnum.nextElement().toString();
            String expr = "";
            expr = key.replaceAll("\\.", "\\\\.");
            if (!prop.matches(expr = expr.replaceAll("\\*", "\\(.*\\)"))) continue;
            result = true;
            return result;
        }
        return result;
    }

    public static boolean propertyShouldBeInsertedToFile(String prop, String fileString) {
        return PropertyFileUtils.propertyShouldBeInsertedToFile(prop, new File(fileString));
    }

    public static boolean propertyShouldBeInsertedToFile(String prop, File file) {
        boolean result = false;
        if (StringUtils.getPropLength(prop) < 3) {
            return result;
        }
        String shortProp = StringUtils.shortenProp(prop);
        String escapedShortProp = shortProp.replaceAll("\\.", "\\\\\\.");
        try {
            result = FileUtils.isExpressionInFile(escapedShortProp, file);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result;
    }

    public static String getPropertyValue(String prop, Properties propTable) {
        String result = "";
        Enumeration<?> propEnum = propTable.propertyNames();
        while (propEnum.hasMoreElements()) {
            String key = propEnum.nextElement().toString();
            if (!prop.intern().equalsIgnoreCase(key.intern())) continue;
            result = propTable.getProperty(key);
            return result;
        }
        return result;
    }

    public static String extractPropertyFromFile(String key, String fileStr) {
        return PropertyFileUtils.extractPropertyFromFile(key, new File(fileStr));
    }

    public static String extractPropertyFromFile(String key, File file) {
        String val = "";
        Properties propTable = PropertyFileUtils.convertFileToProperties(file);
        Enumeration<?> propEnum = propTable.propertyNames();
        while (propEnum.hasMoreElements()) {
            String propKey = propEnum.nextElement().toString();
            if (!propKey.equals(key)) continue;
            val = propTable.getProperty(propKey);
            break;
        }
        return val;
    }

    public static String editPropertyInFile(String fileStr, String propertyToEdit, String newValue) throws IOException {
        String result = PropertyFileUtils.editPropertyInFile(new File(fileStr), propertyToEdit, newValue);
        return result;
    }

    public static String editPropertyInFile(String fileStr, String propertyToEdit, String newValue, String paddingSpace) throws IOException {
        String result = PropertyFileUtils.editPropertyInFile(new File(fileStr), propertyToEdit, newValue, paddingSpace);
        return result;
    }

    public static String editPropertyInFile(File file, String propertyToEdit, String newValue) throws IOException {
        String result = PropertyFileUtils.editPropertyInFile(file, propertyToEdit, newValue, "");
        return result;
    }

    public static String editPropertyInFile(File file, String propertyToEdit, String newValue, String paddingSpace) throws IOException {
        String workstring = "";
        StringBuffer buf = new StringBuffer();
        workstring = FileUtils.convertFileToString(file);
        String escapedValue = newValue.replaceAll("\\\\", "\\\\\\\\\\\\\\\\");
        escapedValue = escapedValue.replaceAll("\\$", "\\\\\\$");
        String before = String.valueOf(propertyToEdit) + paddingSpace + "=" + paddingSpace + "(.*)";
        String after = String.valueOf(propertyToEdit) + paddingSpace + "=" + paddingSpace + escapedValue;
        workstring = workstring.replaceFirst(before, after);
        FileUtils.convertStringToFile(workstring, file);
        return buf.toString();
    }

    public static void insertPropertyToFile(String fileStr, String propertyToInsert, String valueToInsert) throws IOException {
        PropertyFileUtils.insertPropertyToFile(new File(fileStr), propertyToInsert, valueToInsert);
    }

    public static void insertPropertyToFile(String fileStr, String propertyToInsert, String valueToInsert, String paddingSpace) throws IOException {
        PropertyFileUtils.insertPropertyToFile(new File(fileStr), propertyToInsert, valueToInsert, paddingSpace);
    }

    public static String insertPropertyToFile(File file, String propertyToInsert, String valueToInsert) throws IOException {
        return PropertyFileUtils.insertPropertyToFile(file, propertyToInsert, valueToInsert, "");
    }

    public static String insertPropertyToFile(File file, String propertyToInsert, String valueToInsert, String paddingSpace) throws IOException {
        StringBuffer buf = new StringBuffer();
        String escapedProp = propertyToInsert.replaceAll("\\.", "\\\\\\.");
        String lineToInsert = String.valueOf(propertyToInsert) + paddingSpace + "=" + paddingSpace + valueToInsert;
        boolean shouldInsertAfterLine = false;
        try {
            shouldInsertAfterLine = FileUtils.isExpressionInFile(escapedProp, file);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        String workStr = "";
        try {
            workStr = FileUtils.convertFileToString(file);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        buf.append("Inserting line: \n\t");
        buf.append(lineToInsert);
        if (shouldInsertAfterLine) {
            buf.append("After last line containing expression: \n\t");
            buf.append(escapedProp);
            workStr = StringUtils.insertLineAfterLine(workStr, lineToInsert, escapedProp);
        } else {
            String shortProp = StringUtils.shortenProp(propertyToInsert);
            String escShortProp = shortProp.replaceAll("\\.", "\\\\\\.");
            buf.append("After last paragraph containing expression: \n\t");
            buf.append(escShortProp);
            workStr = StringUtils.insertLineAfterParagraph(workStr, lineToInsert, escShortProp);
        }
        try {
            FileUtils.convertStringToFile(workStr, file);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return buf.toString();
    }

    public static String convertPropertiesToString(Properties table) {
        return PropertyFileUtils.convertPropertiesToString(table, "\t");
    }

    public static String convertPropertiesToString(Properties table, String delimiter) {
        StringBuffer buf = new StringBuffer();
        Enumeration<?> propEnum = table.propertyNames();
        while (propEnum.hasMoreElements()) {
            String name = propEnum.nextElement().toString();
            String value = table.getProperty(name);
            buf.append(name).append(delimiter);
            buf.append(value).append(System.getProperty("line.separator"));
        }
        return buf.toString();
    }

    public static void printProperties(Properties table) {
        System.out.println(PropertyFileUtils.convertPropertiesToString(table));
    }

    public static void printProperties(Properties table, String delimiter) {
        System.out.println(PropertyFileUtils.convertPropertiesToString(table, delimiter));
    }
}

