/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.validate;

import com.wily.util.text.CompoundLocalizableMessage;
import com.wily.util.text.ILocalizableException;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.LocalizedMessage;
import com.wily.util.text.SimpleLocalizableMessage;
import com.wily.util.text.TextUtilities;

public class ValidationException
extends Exception
implements ILocalizableException {
    private static final long serialVersionUID = -7191870039016966229L;
    private ILocalizableMessage fUserMessagePrefix;
    private ILocalizableMessage fRequiredCondition;
    protected static final ILocalizableMessage kEmptyMessage = new LocalizedMessage("");

    public ValidationException() {
        this((ILocalizableMessage)null, (ILocalizableMessage)null);
    }

    public ValidationException(ILocalizableMessage requiredCondition) {
        this(null, requiredCondition);
    }

    public ValidationException(ILocalizableMessage requiredCondition, boolean usePrefix) {
        this(usePrefix ? null : kEmptyMessage, requiredCondition);
    }

    public ValidationException(ILocalizableMessage userMessagePrefix, ILocalizableMessage requiredCondition) {
        this.init(userMessagePrefix, requiredCondition);
    }

    private void init(ILocalizableMessage userMessagePrefix, ILocalizableMessage requiredCondition) {
        this.fUserMessagePrefix = userMessagePrefix;
        if (this.fUserMessagePrefix == null) {
            this.fUserMessagePrefix = new SimpleLocalizableMessage("Validation_Default_User_Message_Prefix");
        }
        this.fRequiredCondition = requiredCondition;
        if (this.fRequiredCondition == null) {
            this.fRequiredCondition = new SimpleLocalizableMessage("Validation_Default_Required_Condition");
        }
    }

    public ILocalizableMessage getUserMessagePrefix() {
        return this.fUserMessagePrefix;
    }

    public ILocalizableMessage getRequiredCondition() {
        return this.fRequiredCondition;
    }

    public ILocalizableMessage ILocalizableException_getLocalizableMessage() {
        return new CompoundLocalizableMessage(this.fUserMessagePrefix, TextUtilities.getSpaceLocalizableMessage(), this.fRequiredCondition, TextUtilities.getSentenceTerminatorLocalizableMessage());
    }
}

