/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class PropertiesUtils {
    public static final boolean kIgnoreComments = true;
    public static final boolean kIncludeComments = false;
    public static final String[] kNoStringArrayProperties = new String[0];
    public static final String kDefaultDelimiter = ",";

    private PropertiesUtils() {
    }

    public static void renumberIndexedPropertiesInFile(File inFile, File outFile, boolean ignoreComments) throws IOException {
        String line;
        FileInputStream inStream = new FileInputStream(inFile);
        LineNumberReader in = new LineNumberReader(new InputStreamReader(inStream));
        FileOutputStream outStream = new FileOutputStream(outFile);
        PrintStream out = new PrintStream(outStream);
        HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
        while ((line = in.readLine()) != null) {
            if (!ignoreComments || line.charAt(0) != '#') {
                int equalsIndex = line.indexOf("=");
                if (equalsIndex != -1) {
                    String key = line.substring(0, equalsIndex);
                    int lastDotIndex = key.lastIndexOf(".");
                    if (lastDotIndex != -1) {
                        String lastSegment = key.substring(lastDotIndex + 1);
                        try {
                            int index = Integer.parseInt(lastSegment);
                            String linePrefix = key.substring(0, lastDotIndex);
                            String lineSuffix = line.substring(equalsIndex);
                            String keyPrefix = linePrefix.substring(linePrefix.lastIndexOf("#") + 1);
                            Integer lastIndex = (Integer)keyMap.remove(keyPrefix);
                            int nextIndex = 0;
                            if (lastIndex != null) {
                                nextIndex = lastIndex + 1;
                            }
                            keyMap.put(keyPrefix, new Integer(nextIndex));
                            out.println(linePrefix + "." + nextIndex + lineSuffix);
                        }
                        catch (NumberFormatException e) {
                            out.println(line);
                        }
                        continue;
                    }
                    out.println(line);
                    continue;
                }
                out.println(line);
                continue;
            }
            out.println(line);
        }
        inStream.close();
        outStream.close();
    }

    public static String getProperty(Map properties, String propertyKey) {
        return (String)properties.get(propertyKey);
    }

    public static String getProperty(Map properties, String propertyKey, String defaultValue) {
        String value = PropertiesUtils.getProperty(properties, propertyKey);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static String[] getStringArray(String propertyValue, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(propertyValue, delimiter);
        ArrayList<String> elements = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            String element = (String)tokenizer.nextElement();
            elements.add(element.trim());
        }
        return elements.toArray(kNoStringArrayProperties);
    }

    public static void checkEntryTypes(Map properties) throws Exception {
        Iterator iter = properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!(entry.getKey() instanceof String)) {
                throw new Exception("Entry key is not a string: " + entry.getKey());
            }
            if (entry.getValue() instanceof String) continue;
            throw new Exception("Entry value is not a string: " + entry.getValue());
        }
    }
}

