/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.MonitoredClasses;

import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.MonitoredClasses.PlaceHolder;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.CAMQUtils;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.CAQueueManagerUtils;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.QueueVO;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.MQTransactionTracerUtil;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.TraceProperties;
import java.lang.reflect.Field;

public class CAMQDistributionList
extends PlaceHolder {
    private static Field fMQDistributionList_mgr = null;

    public String getHostName(InvocationData invocationdata) {
        Object mqObject = invocationdata.getInvocationObject();
        Class<?> mqDistributionListclass = mqObject.getClass();
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQDistributionList:getHostName:mqDistributionListclass: " + mqDistributionListclass.getName());
        try {
            if (fMQDistributionList_mgr == null) {
                fMQDistributionList_mgr = mqDistributionListclass.getDeclaredField("mgr");
                fMQDistributionList_mgr.setAccessible(true);
            }
            Object mqQueueManagerObject = fMQDistributionList_mgr.get(mqObject);
            this.hostname = CAMQUtils.getPropertyMQQueueManager(mqQueueManagerObject, "hostname");
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(MQPPLog.getModule(), "CAMQDistributionList:getHostName:Exception: " + e.getMessage());
            MQPPLog.getLogger().debug((Throwable)e);
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQDistributionList:getHostName:Host Name: " + this.hostname);
        return this.hostname;
    }

    public String getQueueManagerName(InvocationData invocationdata) {
        Object mqObject = invocationdata.getInvocationObject();
        Class<?> mqDistributionListclass = mqObject.getClass();
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQDistributionList:getQueueManagerName:mqDistributionListclass: " + mqDistributionListclass.getName());
        try {
            if (fMQDistributionList_mgr == null) {
                fMQDistributionList_mgr = mqDistributionListclass.getDeclaredField("mgr");
                fMQDistributionList_mgr.setAccessible(true);
            }
            Object mqQueueManagerObject = fMQDistributionList_mgr.get(mqObject);
            this.qmname = CAQueueManagerUtils.getQMName(mqQueueManagerObject);
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(MQPPLog.getModule(), "CAMQDistributionList:getQueueManagerName:Exception: " + e.getMessage());
            MQPPLog.getLogger().debug((Throwable)e);
        }
        if (TraceProperties.shouldStartDiscovery()) {
            this.sendToDiscovery(invocationdata);
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQDistributionList:getQueueManagerName:Queue Manager Name: " + this.qmname);
        return this.qmname;
    }

    public String getQueueName(InvocationData invocationdata) {
        return this.queuename;
    }

    private void sendToDiscovery(InvocationData data) {
        try {
            Object object = data.getInvocationObject();
            QueueVO queueVO = null;
            Object mqPutMessageOptions = null;
            String objectClassName = object.getClass().getName();
            int invocationParameterCount = data.getInvocationParameterCount();
            if (objectClassName.equals("com.ibm.mq.MQDistributionList") && invocationParameterCount > 1) {
                mqPutMessageOptions = data.getInvocationParameterAsObject(1);
                MQTransactionTracerUtil.updatePutMessageOptions(mqPutMessageOptions);
                Object distributionListQM = MQTransactionTracerUtil.getDistributionListQueueManager(object);
                String distributionListQMName = MQTransactionTracerUtil.getDistributionListQueueManagerName(object);
                Object[] distributionListItems = MQTransactionTracerUtil.getDistributionListItems(object);
                int i = 0;
                while (i < distributionListItems.length) {
                    queueVO = MQTransactionTracerUtil.getDistributionListItemQueueVO(object, distributionListItems[i], distributionListQM, distributionListQMName);
                    if (queueVO != null) {
                        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQDistributionList:sendToDiscovery:Host Name: " + this.hostname + " QueueManager Name: " + this.qmname + " is sent for discovery.");
                    } else {
                        MQPPLog.getLogger().error(MQPPLog.getModule(), "CAMQDistributionList:sendToDiscovery:Host Name: " + this.hostname + " QueueManager Name: " + this.qmname + " will not be sent for discovery.");
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(MQPPLog.getModule(), "CAMQDistributionList:sendToDiscovery:Exception: " + e.getMessage());
            MQPPLog.getLogger().debug((Throwable)e);
        }
    }
}

