/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.thread.management;

import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.Frequency;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.timeslice.IntegerTimeslicedValue;
import com.wily.introscope.thread.management.ThreadPerfStats;
import com.wily.introscope.thread.management.ThreadTrackingStats;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ThreadTracking {
    private static final Pattern sHexPattern = Pattern.compile("(.*)@[a-f,0-9]+");
    private HashMap<Long, ThreadTrackingStats> fCPUTracking = new HashMap();
    private int fEMCPUUsedPercent = 0;

    public ThreadTracking() {
    }

    public ThreadTracking(boolean enableCPUTime, boolean enableContention) {
        try {
            ManagementFactory.getThreadMXBean().setThreadCpuTimeEnabled(enableCPUTime);
            ManagementFactory.getThreadMXBean().setThreadContentionMonitoringEnabled(enableContention);
        }
        catch (Throwable throwable) {}
    }

    public ThreadPerfStats[] getThreadCPUTimes() {
        HashMap<ThreadInfo, ThreadPerfStats> result = new HashMap<ThreadInfo, ThreadPerfStats>();
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        HashSet<Long> deadThreads = new HashSet<Long>(this.fCPUTracking.keySet());
        long[] ids = bean.getAllThreadIds();
        ThreadInfo[] infos = bean.getThreadInfo(ids);
        int i = 0;
        while (i < ids.length) {
            long userTime;
            long cpuTime;
            Long threadID = ids[i];
            try {
                cpuTime = bean.getThreadCpuTime(ids[i]);
            }
            catch (Throwable throwable) {
                cpuTime = -1L;
            }
            try {
                userTime = bean.getThreadUserTime(ids[i]);
            }
            catch (Throwable throwable) {
                userTime = -1L;
            }
            deadThreads.remove(threadID);
            if (infos[i] != null) {
                cpuTime /= 1000000L;
                userTime /= 1000000L;
                ThreadTrackingStats oldStats = this.fCPUTracking.get(threadID);
                if (oldStats == null) {
                    oldStats = new ThreadTrackingStats(infos[i], cpuTime, userTime);
                }
                ThreadPerfStats perfStats = ThreadPerfStats.create(oldStats.getCPUTimeMS(), cpuTime, oldStats.getUserTimeMS(), userTime, oldStats.getThreadInfo(), infos[i]);
                result.put(infos[i], perfStats);
                this.fCPUTracking.put(threadID, new ThreadTrackingStats(infos[i], cpuTime, userTime));
            }
            ++i;
        }
        for (Long deadKey : deadThreads) {
            this.fCPUTracking.remove(deadKey);
        }
        return result.values().toArray(new ThreadPerfStats[result.size()]);
    }

    public String getNormalizedThreadName(String threadName) {
        char[] buffer = new char[threadName.length()];
        int charIndex = 0;
        int i = 0;
        while (i < threadName.length()) {
            int c = threadName.charAt(i);
            if (!Character.isDigit((char)c)) {
                if (c == 58 || c == 124) {
                    c = 32;
                }
                buffer[charIndex++] = c;
            }
            ++i;
        }
        String result = new String(buffer, 0, charIndex).trim();
        Matcher matcher = sHexPattern.matcher(result);
        if (matcher.matches()) {
            int index = result.lastIndexOf(64);
            return result.substring(0, ++index);
        }
        return result;
    }

    private AgentMetricData generateIntMetric(long startTime, long stopTime, String metric, int type, int value) throws BadlyFormedNameException {
        IntegerTimeslicedValue tsv = new IntegerTimeslicedValue(type, startTime, startTime, null, value);
        return new AgentMetricData(AgentMetric.getAgentMetric((String)metric, (int)type), Frequency.kDefaultSystemFrequency, (IMetricDataValue)tsv);
    }

    public int getEMCPUUsedPercent() {
        return this.fEMCPUUsedPercent;
    }

    public AgentMetricData[] harvestThreadMetrics(long startTime, long stopTime, String metricPrefix) throws BadlyFormedNameException {
        String metricName;
        HashMap<String, ThreadPerfStats> threadMap = new HashMap<String, ThreadPerfStats>();
        LinkedList<AgentMetricData> resultList = new LinkedList<AgentMetricData>();
        ThreadPerfStats[] threadStats = this.getThreadCPUTimes();
        ThreadPerfStats[] threadPerfStatsArray = threadStats;
        int n = threadStats.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadPerfStats stat = threadPerfStatsArray[n2];
            ThreadPerfStats prevStat = (ThreadPerfStats)threadMap.get(metricName = this.getNormalizedThreadName(stat.getThreadName()));
            threadMap.put(metricName, prevStat == null ? stat : ThreadPerfStats.aggregate(prevStat, stat));
            ++n2;
        }
        long overallTime = 0L;
        for (Map.Entry entry : threadMap.entrySet()) {
            metricName = String.valueOf(metricPrefix) + (String)entry.getKey();
            ThreadPerfStats stats = (ThreadPerfStats)entry.getValue();
            overallTime += stats.getCPUTimeMS();
            resultList.add(this.generateIntMetric(startTime, stopTime, String.valueOf(metricName) + ":CPU Time (ms)", 257, (int)stats.getCPUTimeMS()));
            resultList.add(this.generateIntMetric(startTime, stopTime, String.valueOf(metricName) + ":User Time (ms)", 257, (int)stats.getUserTimeMS()));
            resultList.add(this.generateIntMetric(startTime, stopTime, String.valueOf(metricName) + ":Blocked Time (ms)", 257, (int)stats.getBlockedTimeMS()));
            resultList.add(this.generateIntMetric(startTime, stopTime, String.valueOf(metricName) + ":Blocked Count", 257, (int)stats.getBlockedCount()));
            resultList.add(this.generateIntMetric(startTime, stopTime, String.valueOf(metricName) + ":Wait Time (ms)", 257, (int)stats.getWaitedTime()));
            resultList.add(this.generateIntMetric(startTime, stopTime, String.valueOf(metricName) + ":Wait Count", 257, (int)stats.getWaitedCount()));
        }
        double d = (double)overallTime / 15000.0;
        this.fEMCPUUsedPercent = (int)(d * 100.0);
        this.fEMCPUUsedPercent /= Runtime.getRuntime().availableProcessors();
        if (this.fEMCPUUsedPercent < 0) {
            this.fEMCPUUsedPercent = 0;
        }
        resultList.add(this.generateIntMetric(startTime, stopTime, "Enterprise Manager|CPU:EM CPU Used (%)", 4097, this.fEMCPUUsedPercent));
        return resultList.toArray(new AgentMetricData[resultList.size()]);
    }
}

