/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.bproc.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ICacheableBlameKeyNameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.soaextension.webmethods.KConstants;
import com.wily.soaextension.webmethods.bproc.BPCache;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.reflect.Method;

public class BPFormatter
implements ICacheableBlameKeyNameFormatter {
    private static Method mthGetModelId = null;
    private static Method mthGetModelVersion = null;

    public BPFormatter(IAgent agent) {
    }

    public String INameFormatter_format(String name, InvocationData data) {
        try {
            name = "WebMethods|Business Processes|{processName}";
            WMUtils.getLogger().debug("START:BPFormatter::name:" + name);
            String processName = (String)data.get("processname-url");
            if (processName == null) {
                processName = this.getProcessName(data);
                processName = KConstants.formatToBeResourceSafe(processName);
                if (name.indexOf("{processName}") != -1) {
                    name = StringUtils.replace((String)name, (String)"{processName}", (String)processName);
                }
                data.put("processname", (Object)processName);
                data.put("processname-url", (Object)name);
                WMUtils.getLogger().debug("END:BPFormatter::name:" + name);
                BPCache.setProcessName(processName);
            } else {
                name = processName;
            }
        }
        catch (Exception e) {
            WMUtils.getLogger().debug((Throwable)e);
        }
        return name;
    }

    private String getProcessName(InvocationData data) {
        String processName = null;
        try {
            Object objModelID = data.getInvocationParameterAsObject(1);
            mthGetModelId = WMUtils.getModelIdMethod(objModelID);
            mthGetModelVersion = WMUtils.getModelVersionMethod(objModelID);
            String strModelId = (String)mthGetModelId.invoke(objModelID, new Object[0]);
            String strModelVersion = (String)mthGetModelVersion.invoke(objModelID, new Object[0]);
            strModelId = StringUtils.replace((String)strModelId, (String)"/", (String)".");
            processName = String.valueOf(strModelId) + '_' + strModelVersion;
        }
        catch (Exception e) {
            WMUtils.getLogger().error(e.getMessage());
        }
        return processName;
    }

    public Object getObjectKey(IModuleFeedbackChannel imodulefeedbackchannel, int i, InvocationData invocationdata) {
        return null;
    }

    public IBlameComponent getKey(IModuleFeedbackChannel imodulefeedbackchannel, String name, InvocationData data) {
        try {
            String processName = (String)data.get("processname-url");
            if (processName == null) {
                processName = this.getProcessName(data);
                if (name.indexOf("{processName}") != -1) {
                    name = StringUtils.replace((String)name, (String)"{processName}", (String)processName);
                }
                data.put("processname", (Object)processName);
                data.put("processname-url", (Object)name);
                BPCache.setProcessName(processName);
            }
            return ABlameComponent.getArrayInstance((Object[])new Object[]{name, processName});
        }
        catch (Exception e) {
            WMUtils.getLogger().error(e.getMessage());
            imodulefeedbackchannel.equals(e.getMessage());
            return null;
        }
    }
}

