/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.bproc.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ICacheableBlameKeyNameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.soaextension.webmethods.bproc.BPCache;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.reflect.Method;

public class BPStepErrorFormatter
implements ICacheableBlameKeyNameFormatter {
    private IAgent fAgent;

    public BPStepErrorFormatter(IAgent agent) {
        this.fAgent = agent;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        String processName = null;
        String sid = null;
        try {
            processName = BPCache.getProcessName();
            if (processName == null) {
                processName = this.getProcessName(data);
                processName = StringUtils.replace((String)processName, (String)":", (String)"_");
                BPCache.setProcessName(processName);
            }
            if (StringUtils.isEmpty((String)processName)) {
                processName = "UnknownProcess";
            }
            if (StringUtils.isEmpty((String)(sid = BPCache.getStepsId()))) {
                sid = "UnknownStep";
            }
            name = name.replaceAll("\\{processName\\}", processName);
            name = name.replaceAll("\\{sid\\}", sid);
        }
        catch (Exception e) {
            name = name.replaceAll("\\{processName\\}", "UnknownProcess");
            name = name.replaceAll("\\{sid\\}", "UnknownStep");
            WMUtils.handleError(this.fAgent, "ERROR_IN_BP_STEP_ERR_FMTR", e);
        }
        return name;
    }

    private String getProcessName(InvocationData data) {
        String processName = null;
        String modelid = null;
        String modelversion = null;
        try {
            Object modelIdentifierObj = data.getInvocationParameterAsObject(1);
            Method method = WMUtils.getModelIdMethod(modelIdentifierObj);
            modelid = (String)method.invoke(modelIdentifierObj, new Object[0]);
            modelid = StringUtils.replace((String)modelid, (String)"/", (String)".");
            method = null;
            method = WMUtils.getModelVersionMethod(modelIdentifierObj);
            modelversion = (String)method.invoke(modelIdentifierObj, new Object[0]);
            modelversion = StringUtils.replace((String)modelversion, (String)":", (String)"_");
            modelid = modelid.concat("_");
            processName = modelid.concat(modelversion);
        }
        catch (Exception e) {
            WMUtils.getLogger().error(e.getMessage());
        }
        return processName;
    }

    public Object getObjectKey(IModuleFeedbackChannel imodulefeedbackchannel, int i, InvocationData invocationdata) {
        return null;
    }

    public IBlameComponent getKey(IModuleFeedbackChannel imodulefeedbackchannel, String name, InvocationData data) {
        try {
            String processName = BPCache.getProcessName();
            if (processName == null) {
                processName = this.getProcessName(data);
                BPCache.setProcessName(processName);
            }
            return ABlameComponent.getArrayInstance((Object[])new Object[]{name, processName, BPCache.getStepsId()});
        }
        catch (Exception e) {
            WMUtils.getLogger().error(e.getMessage());
            return null;
        }
    }
}

