/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.services.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.spec.metric.ESEException;
import com.wily.soaextension.webmethods.services.ServiceFilter;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;

public class WMMethodThrewErrorReportingTracer
extends ASingleMetricTracerFactory {
    public WMMethodThrewErrorReportingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
        try {
            Object invObj = data.getInvocationObject();
            if (invObj != null && ServiceFilter.isServiceInteresting(invObj.toString(), null)) {
                String component = this.formatParameterizedResource(data);
                this.getAgent().IAgent_getComponentTracer().addComponent(component);
            }
        }
        catch (Throwable bomb) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", bomb);
        }
    }

    protected final IDataAccumulator createDataAccumulator(String formattedMetricName) {
        return null;
    }

    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        try {
            Object invObj = data.getInvocationObject();
            if (invObj != null && ServiceFilter.isServiceInteresting(invObj.toString(), null)) {
                String component = this.formatParameterizedResource(data);
                this.getAgent().IAgent_getComponentTracer().removeComponent(component);
                if (data.hasInvocationThrownException()) {
                    Throwable error = data.getInvocationThrownException();
                    String name = this.formatParameterizedName(data);
                    String errorMessage = error.getMessage();
                    if (errorMessage != null) {
                        if (errorMessage.equals("")) {
                            errorMessage = String.valueOf(component) + "::" + "Error Occured";
                        }
                    } else {
                        errorMessage = String.valueOf(component) + "::" + "Error Occured";
                    }
                    if (ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)errorMessage)) {
                        this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                    }
                    this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(name).ILongIntervalCounterDataAccumulator_addSingleIncident();
                }
            }
        }
        catch (ESEException e) {
            Assertion.wilyFail((String)("Metric type conflict" + e.getMessage()));
        }
        catch (Throwable bomb) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", bomb);
        }
    }
}

