/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.webservices.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.soaextension.webmethods.KConstants;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.soaextension.webmethods.webservices.nameformatter.WSNameFormatter;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class WS80NameFormatter
extends WSNameFormatter {
    public WS80NameFormatter(IAgent agent) {
        super(agent);
    }

    public String INameFormatter_format(String name, InvocationData data) {
        try {
            String wsname = (String)data.get("com.wily.soaextension.webmethods.webservices.NamespaceKey");
            String operation = (String)data.get("com.wily.soaextension.webmethods.webservices.OperationNameKey");
            String soapactionObj = (String)data.get(KConstants.kSoapAction);
            if (wsname == null || operation == null) {
                Field soapActionField;
                Object wsdObj = null;
                Object wsImplObject = data.getInvocationObject();
                Field wsdObjectField = WMUtils.getWsdField(wsImplObject);
                wsdObj = wsdObjectField.get(wsImplObject);
                if (soapactionObj == null && (soapactionObj = (String)(soapActionField = WMUtils.getSoapActionField(wsImplObject)).get(wsImplObject)) == null) {
                    soapactionObj = WMUtils.getSoapActionFromProtocolState(wsImplObject);
                }
                this.process(wsdObj, soapactionObj, wsname, operation, data);
                WMUtils.getLogger().debug("WSNameFormatter Server::WebService Namespace:" + wsname);
                WMUtils.getLogger().debug("WSNameFormatter Server::WebService Operation:" + operation);
            }
            name = this.formatName(name, data);
        }
        catch (Exception e) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_NAMEFORMATTER", e);
            WMUtils.getLogger().debug("Error in Nameformatter:" + e.getMessage());
        }
        return name;
    }

    protected void process(Object wsdObj, Object soapactionObj, String wsname, String operation, InvocationData data) throws Exception {
        if (wsdObj != null && soapactionObj != null) {
            Class[] clArr = new Class[]{String.class};
            Object[] obArr = new Object[]{soapactionObj};
            Method binderMethod = WMUtils.getFindBinderonWSD(wsdObj, clArr);
            Object binderObj = binderMethod.invoke(wsdObj, obArr);
            Method targetNSMethod = WMUtils.getTargetNSonWSD(wsdObj);
            wsname = (String)targetNSMethod.invoke(wsdObj, new Object[0]);
            if (binderObj != null) {
                operation = (String)WMUtils.invokeDeclaredMethodOnObject(binderObj, "findOperationName", clArr, obArr);
            }
        }
        WMUtils.getLogger().debug("WSNameFormatter Server::WebService Namespace:" + wsname);
        WMUtils.getLogger().debug("WSNameFormatter Server::WebService Operation:" + operation);
        data.put("com.wily.soaextension.webmethods.webservices.NamespaceKey", (Object)wsname);
        data.put("com.wily.soaextension.webmethods.webservices.OperationNameKey", (Object)operation);
    }

    public IBlameComponent getKey(IModuleFeedbackChannel imodulefeedbackchannel, String name, InvocationData data) {
        String wsname = (String)data.get("com.wily.soaextension.webmethods.webservices.NamespaceKey");
        String operation = (String)data.get("com.wily.soaextension.webmethods.webservices.OperationNameKey");
        String soapactionObj = (String)data.get(KConstants.kSoapAction);
        if (wsname == null || operation == null) {
            try {
                Field soapActionField;
                Object wsdObj = null;
                Object wsImplObject = data.getInvocationObject();
                Field wsdObjectField = WMUtils.getWsdField(wsImplObject);
                wsdObj = wsdObjectField.get(wsImplObject);
                if (soapactionObj == null && (soapactionObj = (String)(soapActionField = WMUtils.getSoapActionField(wsImplObject)).get(wsImplObject)) == null) {
                    soapactionObj = WMUtils.getSoapActionFromProtocolState(wsImplObject);
                }
                this.process(wsdObj, soapactionObj, wsname, operation, data);
                WMUtils.getLogger().debug("WSNameFormatter Server::WebService Namespace:" + wsname);
                WMUtils.getLogger().debug("WSNameFormatter Server::WebService Operation:" + operation);
            }
            catch (Exception e) {
                WMUtils.handleError(this.getAgent(), "ERROR_IN_NAMEFORMATTER", e);
                WMUtils.getLogger().debug("Error in Nameformatter:" + e.getMessage());
            }
        }
        try {
            return ABlameComponent.getArrayInstance((Object[])new Object[]{name, "WebServices", "Server", wsname, operation});
        }
        catch (Exception e) {
            imodulefeedbackchannel.error(e.getMessage());
            return null;
        }
    }
}

