/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.webservices.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ICacheableBlameKeyNameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.reflect.Method;

public class WSNameFormatter
implements ICacheableBlameKeyNameFormatter {
    private IAgent fAgent;

    public WSNameFormatter(IAgent agent) {
        this.fAgent = agent;
    }

    protected IAgent getAgent() {
        return this.fAgent;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        try {
            String wsname = (String)data.get("com.wily.soaextension.webmethods.webservices.NamespaceKey");
            String operation = (String)data.get("com.wily.soaextension.webmethods.webservices.OperationNameKey");
            if (wsname == null || operation == null) {
                Object wsdObj = null;
                String soapactionObj = null;
                wsdObj = data.getInvocationParameterAsObject(6);
                soapactionObj = (String)data.getInvocationParameterAsObject(2);
                this.process(wsdObj, soapactionObj, wsname, operation, data);
            }
            name = this.formatName(name, data);
        }
        catch (Exception e) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_NAMEFORMATTER", e);
            WMUtils.getLogger().debug("Error in Nameformatter:" + e.getMessage());
        }
        return name;
    }

    protected String formatName(String name, InvocationData data) {
        String wsname = (String)data.get("com.wily.soaextension.webmethods.webservices.NamespaceKey");
        String operation = (String)data.get("com.wily.soaextension.webmethods.webservices.OperationNameKey");
        if (name.indexOf("{namespace}", 0) >= 0) {
            if ((wsname = WMUtils.formatToBeResourceSafe(wsname)) == null || wsname.equals("")) {
                wsname = "UnknownService";
            }
            name = StringUtils.replace((String)name, (String)"{namespace}", (String)wsname);
        }
        if (name.indexOf("{operationname}", 0) >= 0) {
            if ((operation = WMUtils.formatToBeResourceSafe(operation)) == null || operation.equals("")) {
                operation = "UnknownOperation";
            }
            name = StringUtils.replace((String)name, (String)"{operationname}", (String)operation);
        }
        return name;
    }

    protected void process(Object wsdObj, Object soapactionObj, String wsname, String operation, InvocationData data) throws Exception {
        if (wsdObj != null && soapactionObj != null) {
            Class[] clArr = new Class[]{String.class};
            Object[] obArr = new Object[]{soapactionObj};
            Method binderMethod = WMUtils.getFindBinderonWSD(wsdObj, clArr);
            Object binderObj = binderMethod.invoke(wsdObj, obArr);
            Method targetNSMethod = WMUtils.getTargetNSonWSD(wsdObj);
            wsname = (String)targetNSMethod.invoke(wsdObj, new Object[0]);
            if (binderObj != null) {
                operation = (String)WMUtils.invokeDeclaredMethodOnObject(binderObj, "findOperationName", clArr, obArr);
            }
        }
        WMUtils.getLogger().debug("WSNameFormatter Server::WebService Namespace:" + wsname);
        WMUtils.getLogger().debug("WSNameFormatter Server::WebService Operation:" + operation);
        data.put("com.wily.soaextension.webmethods.webservices.NamespaceKey", (Object)wsname);
        data.put("com.wily.soaextension.webmethods.webservices.OperationNameKey", (Object)operation);
    }

    public Object getObjectKey(IModuleFeedbackChannel imodulefeedbackchannel, int i, InvocationData invocationdata) {
        return null;
    }

    public IBlameComponent getKey(IModuleFeedbackChannel imodulefeedbackchannel, String name, InvocationData data) {
        String wsname = (String)data.get("com.wily.soaextension.webmethods.webservices.NamespaceKey");
        String operation = (String)data.get("com.wily.soaextension.webmethods.webservices.OperationNameKey");
        if (wsname == null || operation == null) {
            try {
                Object wsdObj = null;
                String soapactionObj = null;
                wsdObj = data.getInvocationParameterAsObject(6);
                soapactionObj = (String)data.getInvocationParameterAsObject(2);
                this.process(wsdObj, soapactionObj, wsname, operation, data);
                data.put("com.wily.soaextension.webmethods.webservices.NamespaceKey", (Object)wsname);
                data.put("com.wily.soaextension.webmethods.webservices.OperationNameKey", (Object)operation);
            }
            catch (Exception e) {
                WMUtils.handleError(this.getAgent(), "ERROR_IN_NAMEFORMATTER", e);
                WMUtils.getLogger().debug("Error in Nameformatter:" + e.getMessage());
            }
        }
        try {
            return ABlameComponent.getArrayInstance((Object[])new Object[]{name, "WebServices", "Server", wsname, operation});
        }
        catch (Exception e) {
            imodulefeedbackchannel.error(e.getMessage());
            return null;
        }
    }
}

