/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.log;

import com.wily.diagnos.cmp.batch.DGFileSettings;
import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.CompilerLogDetailsSession;
import com.wily.diagnos.cmp.log.CurrentCompilerLogDetails;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.log.ISummaryInfo;
import com.wily.diagnos.cmp.tracer.MethodTracer;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.task.IExecutableItem;
import com.wily.util.task.IExecutionQueue;
import java.util.List;

public class AsynchCompilerLogWrapper
implements ICompilerLog {
    private final ICompilerLog fDelegate;
    private final IExecutionQueue fQueue;

    static {
        try {
            Class.forName(AAsynchLoggingCommand.class.getName());
            Class.forName(LogHeaderCommand.class.getName());
            Class.forName(LogSkippedBootstrapClassCommand.class.getName());
            Class.forName(LogDetailsCommand.class.getName());
            Class.forName(LogSkippedClassCommand.class.getName());
            Class.forName(CompilerLogDetailsSession.class.getName());
            Class.forName(CompilerLogDetails.class.getName());
            Class.forName(CurrentCompilerLogDetails.class.getName());
            Class.forName(IModeledClass.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public AsynchCompilerLogWrapper(ICompilerLog delegateLog, IExecutionQueue queue) {
        this.fDelegate = delegateLog;
        this.fQueue = queue;
    }

    private void addAsyncLoggingCommand(IExecutableItem item) {
        this.fQueue.IExecutionQueue_addExecutableItem(item);
    }

    public String ICompilerLog_getPath() {
        return this.fDelegate.ICompilerLog_getPath();
    }

    public void ICompilerLog_logHeader(String copyrightString, String releaseAndBuildVersion, String dgVersion) {
        this.addAsyncLoggingCommand(new LogHeaderCommand(copyrightString, releaseAndBuildVersion, dgVersion));
    }

    public void ICompilerLog_logSkippedBootstrapClass(String className) {
        this.addAsyncLoggingCommand(new LogSkippedBootstrapClassCommand(className));
    }

    public void ICompilerLog_logSkippedClass(String className) {
        this.addAsyncLoggingCommand(new LogSkippedClassCommand(className));
    }

    public void ICompilerLog_logSkippedMethod(final IClassName className, final IMethodName methodName) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_logSkippedMethod(className, methodName);
            }
        });
    }

    public void ICompilerLog_logSkippedClassForFlag(final String flagName) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_logSkippedClassForFlag(flagName);
            }
        });
    }

    public void ICompilerLog_setCurrentClass(final IClassName className) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_setCurrentClass(className);
            }
        });
    }

    public void ICompilerLog_setCurrentMethod(final IClassName className, final IMethodName methodName) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_setCurrentMethod(className, methodName);
            }
        });
    }

    public void ICompilerLog_setSkippedClass(final IClassName className) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_setSkippedClass(className);
            }
        });
    }

    public void ICompilerLog_setCopiedFile(final String filename) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_setCopiedFile(filename);
            }
        });
    }

    public void ICompilerLog_setSkippedFile(final String filename) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_setSkippedFile(filename);
            }
        });
    }

    public void ICompilerLog_startArchive(final String archive) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_startArchive(archive);
            }
        });
    }

    public void ICompilerLog_finishArchive(final String archive) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_finishArchive(archive);
            }
        });
    }

    public void ICompilerLog_startDirectory(final String directory) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_startDirectory(directory);
            }
        });
    }

    public void ICompilerLog_finishDirectory(final String directory) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_finishDirectory(directory);
            }
        });
    }

    public void ICompilerLog_finishAborted(final String element) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_finishAborted(element);
            }
        });
    }

    public void ICompilerLog_finishException(final String element) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_finishException(element);
            }
        });
    }

    public void ICompilerLog_logInheritanceChange(final IClassName originalSuperClass, final IClassName newSuperClass) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_logInheritanceChange(originalSuperClass, newSuperClass);
            }
        });
    }

    public void ICompilerLog_logMemberReferenceChange(final String originalMember, final String newMember) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_logMemberReferenceChange(originalMember, newMember);
            }
        });
    }

    public void ICompilerLog_logStartupCallInsertion(final IModeledMethod method, final int lineNumber, final IClassName traceClassName) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_logStartupCallInsertion(method, lineNumber, traceClassName);
            }
        });
    }

    public void ICompilerLog_logClassSubstitution(final IModeledMethod method, final int lineNumber, final String originalClassName, final String substituteClassName) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_logClassSubstitution(method, lineNumber, originalClassName, substituteClassName);
            }
        });
    }

    public void ICompilerLog_logInstrumentation(final IModeledMethod method, final int lineNumber, final String fullyQualifiedMethodName) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_logInstrumentation(method, lineNumber, fullyQualifiedMethodName);
            }
        });
    }

    public void ICompilerLog_logMethodTracer(final IModeledMethod method, final int lineNumber, final MethodTracer tracer) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_logMethodTracer(method, lineNumber, tracer);
            }
        });
    }

    public void ICompilerLog_logMethodCalls(final IModeledMethod method, final List methodCalls) {
        if (this.ICompilerLog_isLogDynamicInstrEnabled()) {
            this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

                public void IExecutableItem_execute() {
                    fDelegate.ICompilerLog_logMethodCalls(method, methodCalls);
                }
            });
        }
    }

    public void ICompilerLog_logMethodTraced(final IModeledMethod method) {
        if (this.ICompilerLog_isLogDynamicInstrEnabled()) {
            this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

                public void IExecutableItem_execute() {
                    fDelegate.ICompilerLog_logMethodTraced(method);
                }
            });
        }
    }

    public void ICompilerLog_logSubstituteResult(final IModeledMethod method, final String substituteMethod) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_logSubstituteResult(method, substituteMethod);
            }
        });
    }

    public void ICompilerLog_logNoticeConstructorCompletion(final IModeledMethod method, final String notificationMethod) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_logNoticeConstructorCompletion(method, notificationMethod);
            }
        });
    }

    public void ICompilerLog_logNoticeObjectCreation(final IModeledMethod method, final String createdType, final IClassName notificationClass) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_logNoticeObjectCreation(method, createdType, notificationClass);
            }
        });
    }

    public void ICompilerLog_logNoticeFieldAssignment(final IModeledMethod method, final String fieldClass, final String fieldName, final IClassName notificationClass) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_logNoticeFieldAssignment(method, fieldClass, fieldName, notificationClass);
            }
        });
    }

    public void ICompilerLog_logClassAlreadyInstrumented() {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_logClassAlreadyInstrumented();
            }
        });
    }

    public void ICompilerLog_logInternalError(final IModeledMethod method, final int lineNumber, final String msg) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_logInternalError(method, lineNumber, msg);
            }
        });
    }

    public void ICompilerLog_logFileSettings(final DGFileSettings fileSettings) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_logFileSettings(fileSettings);
            }
        });
    }

    public void ICompilerLog_dumpFile(final String context, final String filename, final List contents) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_dumpFile(context, filename, contents);
            }
        });
    }

    public void ICompilerLog_logInvalidSettings(final String specifics) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_logInvalidSettings(specifics);
            }
        });
    }

    public void ICompilerLog_logTitleMessage(final String title) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_logTitleMessage(title);
            }
        });
    }

    public void ICompilerLog_logErrorMessage(final String error) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_logErrorMessage(error);
            }
        });
    }

    public void ICompilerLog_logMessage(final String message) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_logMessage(message);
            }
        });
    }

    public void ICompilerLog_logException(final Throwable e) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_logException(e);
            }
        });
    }

    public void ICompilerLog_logException(final String context, final Throwable e) {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_logException(context, e);
            }
        });
    }

    public void ICompilerLog_close() {
        this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

            public void IExecutableItem_execute() {
                fDelegate.ICompilerLog_close();
            }
        });
    }

    public ISummaryInfo ICompilerLog_getSummaryInfo() {
        return this.fDelegate.ICompilerLog_getSummaryInfo();
    }

    public void ICompilerLog_logClassTraced(final String className) {
        if (this.ICompilerLog_isLogDynamicInstrEnabled()) {
            this.addAsyncLoggingCommand(new AAsynchLoggingCommand(this){

                public void IExecutableItem_execute() {
                    fDelegate.ICompilerLog_logClassTraced(className);
                }
            });
        }
    }

    public void ICompilerLog_suggestFlush() {
        this.fDelegate.ICompilerLog_suggestFlush();
    }

    public void ICompilerLog_logDetails(CompilerLogDetails details) {
        if (this.ICompilerLog_isLogDynamicInstrEnabled()) {
            this.addAsyncLoggingCommand(new LogDetailsCommand(details));
        }
    }

    public boolean ICompilerLog_isLogDynamicInstrEnabled() {
        return this.fDelegate.ICompilerLog_isLogDynamicInstrEnabled();
    }

    public void ICompilerLog_saveLastMutatedClass(IModeledClass mutatedClass) {
        this.fDelegate.ICompilerLog_saveLastMutatedClass(mutatedClass);
    }

    public void ICompilerLog_logLastMutatedClass() {
        this.fDelegate.ICompilerLog_logLastMutatedClass();
    }

    private abstract class AAsynchLoggingCommand
    implements IExecutableItem {
        private AAsynchLoggingCommand() {
        }

        public boolean IExecutableItem_shouldStillExecute() {
            return true;
        }

        public void IExecutableItem_executionAborted() {
        }

        public abstract void IExecutableItem_execute();
    }

    private class LogDetailsCommand
    extends AAsynchLoggingCommand {
        private final CompilerLogDetails fDetails;

        public LogDetailsCommand(CompilerLogDetails details) {
            this.fDetails = details;
        }

        public void IExecutableItem_execute() {
            AsynchCompilerLogWrapper.this.fDelegate.ICompilerLog_logDetails(this.fDetails);
        }
    }

    private class LogHeaderCommand
    extends AAsynchLoggingCommand {
        private final String fCopyright;
        private final String fReleaseAndBuildVersion;
        private final String fDGVersion;

        public LogHeaderCommand(String copyrightString, String releaseAndBuildVersionString, String dgVersion) {
            this.fCopyright = copyrightString;
            this.fReleaseAndBuildVersion = releaseAndBuildVersionString;
            this.fDGVersion = dgVersion;
        }

        public void IExecutableItem_execute() {
            AsynchCompilerLogWrapper.this.fDelegate.ICompilerLog_logHeader(this.fCopyright, this.fReleaseAndBuildVersion, this.fDGVersion);
        }
    }

    private class LogSkippedBootstrapClassCommand
    extends AAsynchLoggingCommand {
        private final String fClassName;

        public LogSkippedBootstrapClassCommand(String className) {
            this.fClassName = className;
        }

        public void IExecutableItem_execute() {
            AsynchCompilerLogWrapper.this.fDelegate.ICompilerLog_logSkippedBootstrapClass(this.fClassName);
        }
    }

    private class LogSkippedClassCommand
    extends AAsynchLoggingCommand {
        protected final String fClassName;

        public LogSkippedClassCommand(String className) {
            this.fClassName = className;
        }

        public void IExecutableItem_execute() {
            AsynchCompilerLogWrapper.this.fDelegate.ICompilerLog_logSkippedClass(this.fClassName);
        }
    }
}

