/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.transform.builder;

import com.wily.diagnos.cmp.classmatcher.DGAllClassMatcher;
import com.wily.diagnos.cmp.classmatcher.IClassMatcher;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.transform.ITransformation;
import com.wily.diagnos.cmp.transform.NoticeObjectCreationTransformation;
import com.wily.diagnos.cmp.transform.builder.ITransformationBuilder;
import com.wily.util.classfile.IClassName;
import java.util.Map;

public final class NoticeObjectCreationTransformationBuilder
implements ITransformationBuilder {
    private final TracerGroupBuilder fTracerGroup;
    private final IClassName fEventNoticingClass;
    private final TracerGroupBuilder fScopeTracerGroup;

    public NoticeObjectCreationTransformationBuilder(TracerGroupBuilder tracerGroup, IClassName eventNoticingClass, TracerGroupBuilder scopeTracerGroup) {
        this.fTracerGroup = tracerGroup;
        this.fEventNoticingClass = eventNoticingClass;
        this.fScopeTracerGroup = scopeTracerGroup;
    }

    public TracerGroupBuilder getTracerGroupBuilder() {
        return this.fTracerGroup;
    }

    public IClassName getEventNoticingClass() {
        return this.fEventNoticingClass;
    }

    public TracerGroupBuilder getScopeTracerGroupBuilder() {
        return this.fScopeTracerGroup;
    }

    public IClassMatcher getScopeClassMatcher() {
        if (this.getScopeTracerGroupBuilder() == null) {
            return new DGAllClassMatcher();
        }
        return this.getScopeTracerGroupBuilder().getClassMatcher();
    }

    public ITransformation generateTransformation(ICompilerLog log, IClassName instrumentationClass, Map tracerGroups) {
        TracerGroup tracerGroup = this.getTracerGroupBuilder().lookupTracerGroup(tracerGroups);
        TracerGroup scopeTracerGroup = this.getScopeTracerGroupBuilder() == null ? null : this.getScopeTracerGroupBuilder().lookupTracerGroup(tracerGroups);
        return new NoticeObjectCreationTransformation(log, instrumentationClass, tracerGroup, this.getEventNoticingClass(), scopeTracerGroup);
    }
}

