/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.urlgroup;

import com.wily.introscope.agent.urlgroup.URLComponents;
import com.wily.introscope.agent.urlgroup.URLMatch;
import com.wily.introscope.agent.urlgroup.URLPattern;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLGroupRule {
    private URLPattern fPattern;
    private ArrayList fFormatUnits;
    private boolean fMatchesAll;
    private boolean fHasQueryParams;
    private boolean fHasComplexFormat;
    private String fCharEncoding;
    private static final String kWildcard = "*";
    private static final String kEmpty = "<empty>";

    public URLGroupRule(String patternString, String formatExpression) throws UnsupportedEncodingException {
        this(patternString, formatExpression, null);
    }

    public URLGroupRule(String patternString, String formatExpression, String charEncoding) throws UnsupportedEncodingException {
        this.fPattern = new URLPattern(patternString);
        this.fHasQueryParams = false;
        this.fHasComplexFormat = false;
        this.fFormatUnits = this.parseFormatExpression(formatExpression);
        this.fCharEncoding = charEncoding;
        this.fMatchesAll = patternString.equals(kWildcard);
    }

    private ArrayList parseFormatExpression(String formatExpression) {
        ArrayList result = new ArrayList();
        int len = formatExpression.length();
        int i = 0;
        int last = 0;
        while (i < len) {
            i = formatExpression.indexOf(123, last);
            if (i < 0) {
                if (last + 1 >= len) break;
                this.addFormatUnit(result, formatExpression.substring(last, len));
                break;
            }
            if (i > last) {
                this.addFormatUnit(result, formatExpression.substring(last, i));
            }
            if ((i = formatExpression.indexOf(125, last = i)) < 0) {
                if (last + 1 >= len) break;
                this.addFormatUnit(result, formatExpression.substring(last, len));
                break;
            }
            if (i > last) {
                this.addFormatUnit(result, formatExpression.substring(last, i + 1));
            }
            last = i + 1;
        }
        return result;
    }

    private void addFormatUnit(List ruleList, String formatExpression) {
        FormatUnit unit = new FormatUnit(formatExpression);
        if (unit.hasQueryParams()) {
            this.fHasQueryParams = true;
        }
        if (unit.isParametrized()) {
            this.fHasComplexFormat = true;
        }
        ruleList.add(unit);
    }

    public boolean hasComplexFormat() {
        return this.fHasComplexFormat;
    }

    public boolean hasQueryParams() {
        return this.fHasQueryParams;
    }

    public boolean isMatch(URLComponents urlComponents) {
        if (this.fMatchesAll) {
            return true;
        }
        if (urlComponents.m_partPath == null || this.fPattern == null) {
            return false;
        }
        return URLMatch.isMatch(urlComponents.m_partPath, urlComponents.m_params, this.fPattern);
    }

    public String format(URLComponents urlComponents, ArrayList<String> fFrontendUrlResourcesList) {
        StringBuffer result = new StringBuffer();
        ListIterator iter = this.fFormatUnits.listIterator();
        while (iter.hasNext()) {
            result.append(((FormatUnit)iter.next()).format(urlComponents));
        }
        String formattedPath = this.processResourcesList(result.toString(), fFrontendUrlResourcesList);
        return formattedPath;
    }

    public String processResourcesList(String urlPath, ArrayList<String> fFrontendUrlResourcesList) {
        String result = urlPath;
        int fileExtnIndex = urlPath.lastIndexOf(".");
        int len = urlPath.length();
        if (fileExtnIndex != -1 && fileExtnIndex < len) {
            String fileExtn = urlPath.substring(fileExtnIndex + 1, urlPath.length());
            if (fFrontendUrlResourcesList != null && fFrontendUrlResourcesList.contains(fileExtn)) {
                result = "Resources";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("URLGroupRule(m_pattern: ");
        result.append(this.fPattern);
        result.append(" m_formatUnits: ");
        ListIterator iter = this.fFormatUnits.listIterator();
        while (iter.hasNext()) {
            result.append(((FormatUnit)iter.next()).toString());
        }
        result.append(")");
        return result.toString();
    }

    public boolean isMatchesAll() {
        return this.fMatchesAll;
    }

    public String getCharEncoding() {
        return this.fCharEncoding;
    }

    private static class FormatUnit {
        static final int UNKNOWN = 0;
        static final int STRING_LITERAL = 1;
        static final int PROTOCOL = 2;
        static final int HOST = 3;
        static final int PATH_SUBSTRING = 4;
        static final int QUERY_PARAM = 5;
        static final int PORT = 6;
        static final int PATH_DELIMITED = 7;
        static final String[] typeNames = new String[]{"", "", "protocol", "host", "path_substring", "query_param", "port", "path_delimited"};
        private int m_type = 0;
        private String m_arg = null;
        private int m_start;
        private int m_end;
        private boolean m_hasQueryParams = false;
        private boolean m_isParametrized = true;

        FormatUnit(String singleExpression) {
            if (singleExpression == null) {
                return;
            }
            int openCurly = singleExpression.indexOf(123);
            int colon = singleExpression.indexOf(58, openCurly < 0 ? 0 : openCurly);
            int closeCurly = singleExpression.indexOf(125, openCurly < 0 ? 0 : openCurly);
            if (openCurly < 0 || closeCurly < openCurly) {
                this.m_type = 1;
                this.m_arg = singleExpression;
                this.m_isParametrized = false;
                return;
            }
            String expr = singleExpression.substring(openCurly + 1, colon < 0 ? closeCurly : colon);
            int i = 2;
            while (i < typeNames.length) {
                if (typeNames[i].equals(expr)) {
                    this.m_type = i;
                    if (colon <= openCurly || colon >= closeCurly) break;
                    this.m_arg = singleExpression.substring(colon + 1, closeCurly);
                    break;
                }
                ++i;
            }
            switch (this.m_type) {
                case 0: {
                    this.m_arg = expr;
                    this.m_isParametrized = false;
                    break;
                }
                case 4: {
                    this.m_start = 0;
                    this.m_end = 0;
                    if (this.m_arg == null || this.m_arg.length() <= 0) break;
                    StringTokenizer tokenizer = new StringTokenizer(this.m_arg, ":");
                    if (tokenizer.countTokens() < 0 || tokenizer.countTokens() > 2) {
                        throw new IllegalArgumentException("This formatter takes 0 to 2 args");
                    }
                    if (tokenizer.hasMoreTokens()) {
                        this.m_start = Integer.parseInt(tokenizer.nextToken());
                    }
                    if (!tokenizer.hasMoreTokens()) break;
                    this.m_end = Integer.parseInt(tokenizer.nextToken());
                    break;
                }
                case 7: {
                    StringTokenizer tokenizer;
                    if (this.m_arg == null || this.m_arg.length() == 0) {
                        this.m_arg = "/";
                    }
                    if ((tokenizer = new StringTokenizer(this.m_arg, ":")).countTokens() < 0 || tokenizer.countTokens() > 3) {
                        throw new IllegalArgumentException("This formatter takes 0 to 3 args");
                    }
                    String delims = "/";
                    this.m_start = 1;
                    this.m_end = 1;
                    if (tokenizer.hasMoreTokens()) {
                        delims = tokenizer.nextToken();
                    }
                    if (tokenizer.hasMoreTokens()) {
                        this.m_start = Integer.parseInt(tokenizer.nextToken());
                    }
                    if (tokenizer.hasMoreTokens()) {
                        this.m_end = Integer.parseInt(tokenizer.nextToken());
                    }
                    this.m_arg = delims;
                    break;
                }
                case 5: {
                    this.m_hasQueryParams = true;
                }
            }
        }

        public boolean hasQueryParams() {
            return this.m_hasQueryParams;
        }

        public boolean isParametrized() {
            return this.m_isParametrized;
        }

        public String format(URLComponents urlComponents) {
            switch (this.m_type) {
                case 1: {
                    return this.m_arg;
                }
                case 2: {
                    return urlComponents.m_protocol;
                }
                case 3: {
                    return urlComponents.m_host;
                }
                case 4: {
                    int end;
                    String path = urlComponents.m_partPath;
                    int pathLen = path.length();
                    int start = this.m_start > pathLen ? pathLen : this.m_start;
                    int n = end = this.m_end <= 0 ? pathLen + this.m_end : this.m_end;
                    if (start > end) {
                        return "";
                    }
                    return path.substring(start, end);
                }
                case 7: {
                    StringTokenizer tokenizer = new StringTokenizer(urlComponents.m_partPath, this.m_arg, true);
                    StringBuffer result = new StringBuffer();
                    if (this.m_start < 0) {
                        throw new IllegalArgumentException("start has to be non-negative");
                    }
                    if (this.m_end < 0) {
                        throw new IllegalArgumentException("end has to be non-negative");
                    }
                    if (this.m_start >= this.m_end) {
                        return "";
                    }
                    try {
                        int i = 0;
                        while (i < this.m_end) {
                            if (i >= this.m_start) {
                                result.append(tokenizer.nextToken());
                            } else {
                                tokenizer.nextToken();
                            }
                            ++i;
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                    return result.toString();
                }
                case 5: {
                    String[] values = (String[])urlComponents.m_params.get(this.m_arg);
                    if (values == null) {
                        return URLGroupRule.kEmpty;
                    }
                    StringBuffer result = new StringBuffer();
                    String value = null;
                    int i = 0;
                    while (i < values.length) {
                        if (i > 0) {
                            result.append(' ');
                        }
                        if ((value = values[i]) == null || value.trim().equals("")) {
                            value = URLGroupRule.kEmpty;
                        }
                        result.append(value);
                        ++i;
                    }
                    return result.toString();
                }
                case 6: {
                    return String.valueOf(urlComponents.m_port);
                }
            }
            return "{" + (this.m_arg == null ? URLGroupRule.kEmpty : this.m_arg) + "}";
        }

        public String toString() {
            switch (this.m_type) {
                case 1: {
                    return "(string literal: " + this.m_arg + ")";
                }
                case 2: {
                    return "(protocol)";
                }
                case 3: {
                    return "(host)";
                }
                case 4: {
                    return "(path substring: " + this.m_start + " " + this.m_end + ")";
                }
                case 7: {
                    return "(path delimited: " + this.m_arg + " " + this.m_start + " " + this.m_end + ")";
                }
                case 5: {
                    return "(query param: " + this.m_arg + ")";
                }
                case 6: {
                    return "(port)";
                }
            }
            return "{unknown: " + (this.m_arg == null ? URLGroupRule.kEmpty : this.m_arg) + "}";
        }
    }
}

