/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.api;

import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IndexedProperties;
import java.lang.reflect.Constructor;

public class SocketFactoryUtils {
    public static final String kReuseSocketAddrPropertyName = "introscope.enterprisemanager.serversockets.reuseaddr";
    public static final String kSocketReceiveBufferSizePropertyName = "introscope.enterprisemanager.sockets.receivebuffersize";
    public static final String kSocketAbortiveClosePropertyName = "introscope.enterprisemanager.sockets.abortiveclose";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private SocketFactoryUtils() {
    }

    public static Object createSocketFactory(Class factoryClass, IndexedProperties properties, IModuleFeedbackChannel feedback) throws Exception {
        Constructor<?>[] constructors = factoryClass.getConstructors();
        Object factory = null;
        int i = 0;
        while (factory == null && i < constructors.length) {
            Constructor<?> constructor = constructors[i];
            if (SocketFactoryUtils.isSocketFactoryConstructorNoProperties(constructor)) {
                System.setProperty(kReuseSocketAddrPropertyName, String.valueOf(properties.getBooleanProperty(kReuseSocketAddrPropertyName)));
                System.setProperty(kSocketAbortiveClosePropertyName, String.valueOf(properties.getBooleanProperty(kSocketAbortiveClosePropertyName)));
                System.setProperty(kSocketReceiveBufferSizePropertyName, String.valueOf(properties.getIntProperty(kSocketReceiveBufferSizePropertyName)));
                factory = constructor.newInstance(feedback);
            } else if (SocketFactoryUtils.isSocketFactoryConstructorWithProperties(constructor)) {
                factory = constructor.newInstance(properties, feedback);
            }
            ++i;
        }
        if (factory == null) {
            throw new Exception("No appropriate constructor found for socket factory named " + factoryClass);
        }
        return factory;
    }

    private static boolean isSocketFactoryConstructorNoProperties(Constructor constructor) {
        Class<?>[] paramTypes = constructor.getParameterTypes();
        if (paramTypes.length == 1) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.wily.util.feedback.IModuleFeedbackChannel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(paramTypes[0])) {
                return true;
            }
        }
        return false;
    }

    private static boolean isSocketFactoryConstructorWithProperties(Constructor constructor) {
        Class<?>[] paramTypes = constructor.getParameterTypes();
        if (paramTypes.length == 2) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("com.wily.util.properties.IndexedProperties");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(paramTypes[0])) {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("com.wily.util.feedback.IModuleFeedbackChannel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz2.isAssignableFrom(paramTypes[1])) {
                    return true;
                }
            }
        }
        return false;
    }
}

