/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives.builder;

import com.wily.diagnos.cmp.directives.ClassModificationFilterBuilder;
import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.DirectivesFile;
import com.wily.diagnos.cmp.directives.DirectivesListFile;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.IDirective;
import com.wily.diagnos.cmp.directives.IDirectiveCollection;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.builder.TracerClassMapping;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.log.NullCompilerLog;
import com.wily.diagnos.cmp.tracer.MethodTracer;
import com.wily.diagnos.cmp.tracer.builder.MethodTracerBuilder;
import com.wily.diagnos.cmp.transform.ITransformation;
import com.wily.diagnos.cmp.transform.builder.AgentInitializationTransformationBuilder;
import com.wily.diagnos.cmp.transform.builder.CatchExceptionTransformationBuilder;
import com.wily.diagnos.cmp.transform.builder.ITransformationBuilder;
import com.wily.diagnos.cmp.transform.builder.ThrowExceptionTransformationBuilder;
import com.wily.diagnos.personality.ICompilerPersonality;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.OptionalExtensionsManager;
import com.wily.introscope.autoprobe.IAutoProbeConfig;
import com.wily.util.classfile.IClassName;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.validate.ValidationException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CompilerSettingsBuilder {
    private static final String[] kNullTracerKeysArray = new String[1];
    private static final String kDirectivesFileContextPrefix = "Using directives specified in ";
    private static final String kDirectivesListFileContextPrefix = "Using directives list file ";
    public static final int kDefaultMinUnsignedOffsetForJumpWidening = 25000;
    public static final String kUnsignedOffsetForJumpWideningSystemProperty = "com.wily.introscope.probebuilder.widenJumpOffsetThreshold";
    private final IModuleFeedbackChannel fFeedback;
    private final ICompilerLog fLog;
    private final IStringLocalizer fLocalizer;
    private final ICompilerPersonality fPersonality;
    private String fInstrumentationInfo;
    private IClassName fTraceClassName;
    private int fMinOffsetForJumpWidening;
    private final ClassModificationFilterBuilder fFilterBuilder;
    private final TracerClassMapping fTracerMapping;
    private final Map fTracerGroupBuilders;
    private final List fTransformations;
    private final List fTracers;
    private boolean fIntelligentInstrumentationEnabled;
    private IAutoProbeConfig fAutoProbeConfig;
    private IAgent fAgent;

    public CompilerSettingsBuilder(IModuleFeedbackChannel feedback, ICompilerLog log, IStringLocalizer localizer, ICompilerPersonality personality) {
        this.fFeedback = feedback;
        this.fLog = log;
        this.fLocalizer = localizer;
        this.fPersonality = personality;
        this.fMinOffsetForJumpWidening = this.loadMinOffsetForJumpWidening();
        this.fFilterBuilder = new ClassModificationFilterBuilder(this.fLog);
        this.fTracerGroupBuilders = new HashMap();
        this.fTracerMapping = new TracerClassMapping();
        this.fTracers = new ArrayList();
        this.fTransformations = new ArrayList();
    }

    public CompilerSettingsBuilder(IModuleFeedbackChannel feedback, ICompilerLog log, IStringLocalizer localizer, DGCompilerSettings settings) {
        this(feedback, log, localizer, settings.getPersonality());
        this.applySettings(settings);
    }

    private IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }

    private IStringLocalizer getStringLocalizer() {
        return this.fLocalizer;
    }

    public ICompilerPersonality getPersonality() {
        return this.fPersonality;
    }

    private int loadMinOffsetForJumpWidening() {
        String value = null;
        int minOffset = 25000;
        try {
            value = System.getProperty(kUnsignedOffsetForJumpWideningSystemProperty);
        }
        catch (SecurityException se) {
            this.getModuleFeedback().warn(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Diagnos_Security_Exception_Getting_Widen_Jump_Offset_Threshold", kUnsignedOffsetForJumpWideningSystemProperty, Integer.toString(minOffset)));
            this.getModuleFeedback().verbose(se);
        }
        if (value != null) {
            try {
                minOffset = Integer.parseInt(value);
                if (minOffset <= 0) {
                    minOffset = 25000;
                    this.getModuleFeedback().warn(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Diagnos_Nonpositive_Widen_Jump_Offset_Threshold", kUnsignedOffsetForJumpWideningSystemProperty, Integer.toString(minOffset)));
                } else {
                    this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Diagnos_Using_Specified_Widen_Jump_Offset_Threshold", kUnsignedOffsetForJumpWideningSystemProperty, Integer.toString(minOffset)));
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.getModuleFeedback().warn(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Diagnos_Non_Number_Widen_Jump_Offset_Threshold", kUnsignedOffsetForJumpWideningSystemProperty, Integer.toString(minOffset)));
            }
        }
        return minOffset;
    }

    public String getInstrumentationInfo() {
        return this.fInstrumentationInfo;
    }

    public IClassName getInstrumentationClassName() {
        return this.fTraceClassName;
    }

    public int getMinOffsetForJumpWidening() {
        return this.fMinOffsetForJumpWidening;
    }

    public void applySettings(DirectivesListFile listFile, ICompilerLog log) throws ValidationException {
        if (log != null) {
            String location = listFile.getLocation();
            String logString = kDirectivesListFileContextPrefix + location;
            if (this.fAutoProbeConfig == null || this.fAutoProbeConfig.isDirectiveFileModified(location)) {
                log.ICompilerLog_dumpFile(logString, location, listFile.getText());
            }
        }
        Iterator files = listFile.getDirectiveFiles();
        while (files.hasNext()) {
            DirectivesFile curFile = (DirectivesFile)files.next();
            this.applySettings(curFile, log);
        }
    }

    public void applySettings(IDirectiveCollection file, ICompilerLog log) throws ValidationException {
        String name = file.getName();
        if (log != null) {
            String logString = kDirectivesListFileContextPrefix + name;
            if (this.fAutoProbeConfig == null || this.fAutoProbeConfig.isDirectiveFileModified(name)) {
                log.ICompilerLog_dumpFile(logString, name, file.getText());
            }
        }
        try {
            Iterator iter = file.getDirectives();
            while (iter.hasNext()) {
                IDirective directive = (IDirective)iter.next();
                directive.IDirective_applyToSettings(this);
            }
        }
        catch (ValidationException e) {
            this.reportErrorToExtensionManager(name);
            throw e;
        }
    }

    private void reportErrorToExtensionManager(String fileName) {
        if (this.fAgent != null) {
            String strExt = String.valueOf(File.separatorChar) + "extensions" + File.separatorChar;
            int index = fileName.lastIndexOf(strExt);
            OptionalExtensionsManager oem = this.fAgent.IAgent_getExtensionAdministrator().getOptionalExtensionManager();
            if (oem != null && index != -1) {
                int indexOfSep = fileName.indexOf(File.separatorChar, index + strExt.length());
                String ext = fileName.substring(index + strExt.length(), indexOfSep);
                oem.addExtensionWithError(ext);
            }
        }
    }

    public void applySettings(DGCompilerSettings settings) {
        Object builder;
        this.getFilterBuilder().addClassModificationFilter(settings.getFilter());
        this.setInstrumentationInfo(settings.getInstrumentationInfo());
        this.setMinOffsetForJumpWidening(settings.getMinOffsetForJumpWidening());
        this.setInstrumentationTraceClass(settings.getInstrumentationTraceClass());
        Iterator iterator = settings.getTransformationsIterator();
        while (iterator.hasNext()) {
            ITransformation transformation = (ITransformation)iterator.next();
            builder = transformation.generateTransformationBuilder(this);
            this.addTransformation((ITransformationBuilder)builder);
        }
        iterator = settings.getTracersIterator();
        while (iterator.hasNext()) {
            MethodTracer tracer = (MethodTracer)iterator.next();
            builder = new MethodTracerBuilder(this, tracer);
            this.addTracer((MethodTracerBuilder)builder);
        }
    }

    public void setInstrumentationInfo(String instrumentationInfo) {
        this.fInstrumentationInfo = instrumentationInfo;
    }

    public void setMinOffsetForJumpWidening(int minOffsetForJumpWidening) {
        this.fMinOffsetForJumpWidening = minOffsetForJumpWidening;
    }

    public void setInstrumentationTraceClass(IClassName className) {
        this.fTraceClassName = className;
    }

    public TracerClassMapping getTracerClassMapping() {
        return this.fTracerMapping;
    }

    public TracerGroupBuilder getTracerGroupBuilder(FlagName tracerGroupName) {
        TracerGroupBuilder tracerGroupBuilder = (TracerGroupBuilder)this.fTracerGroupBuilders.get(tracerGroupName);
        if (tracerGroupBuilder == null) {
            tracerGroupBuilder = new TracerGroupBuilder(this.fLog, tracerGroupName);
            tracerGroupBuilder.setAgent(this.fAgent);
            this.fTracerGroupBuilders.put(tracerGroupName, tracerGroupBuilder);
        }
        return tracerGroupBuilder;
    }

    public TracerGroupBuilder getTracerGroupBuilder(TracerGroup tracerGroup) {
        if (tracerGroup == null) {
            return null;
        }
        TracerGroupBuilder tracerGroupBuilder = (TracerGroupBuilder)this.fTracerGroupBuilders.get(tracerGroup.getName());
        if (tracerGroupBuilder == null) {
            tracerGroupBuilder = new TracerGroupBuilder(this.fLog, tracerGroup);
            tracerGroupBuilder.setAgent(this.fAgent);
            this.fTracerGroupBuilders.put(tracerGroup.getName(), tracerGroupBuilder);
        }
        return tracerGroupBuilder;
    }

    private boolean isDuplicateInstrumentPoint(ITransformationBuilder transformation) {
        if (transformation instanceof AgentInitializationTransformationBuilder && this.hasTransformation(AgentInitializationTransformationBuilder.class)) {
            if (this.getModuleFeedback().isDebugEnabled()) {
                this.getModuleFeedback().debug("Multiple AgentInitialization transformations applied");
            }
            return true;
        }
        if (transformation instanceof CatchExceptionTransformationBuilder && this.hasTransformation(CatchExceptionTransformationBuilder.class)) {
            if (this.getModuleFeedback().isDebugEnabled()) {
                this.getModuleFeedback().debug("Multiple CatchException transformations applied");
            }
            return true;
        }
        if (transformation instanceof ThrowExceptionTransformationBuilder && this.hasTransformation(ThrowExceptionTransformationBuilder.class)) {
            if (this.getModuleFeedback().isDebugEnabled()) {
                this.getModuleFeedback().debug("Multiple ThrowException transformations applied");
            }
            return true;
        }
        return false;
    }

    private boolean hasTransformation(Class transformationClass) {
        for (ITransformationBuilder builder : this.fTransformations) {
            if (builder.getClass() != transformationClass) continue;
            return true;
        }
        return false;
    }

    public void addTransformation(ITransformationBuilder transformation) {
        if (!this.isDuplicateInstrumentPoint(transformation)) {
            this.fTransformations.add(transformation);
        }
    }

    public void addTracer(MethodTracerBuilder tracer) {
        tracer.setTracerClassMapping(this.fTracerMapping);
        this.fTracers.add(tracer);
    }

    public ClassModificationFilterBuilder getFilterBuilder() {
        return this.fFilterBuilder;
    }

    private void evaluate() throws ValidationException {
        if (this.fTraceClassName == null) {
            throw new ValidationException(new FormattedLocalizableMessage("Diagnos_Exception_Invalid_Settings_Missing_Trace_Class", "InstrumentTraceClass:", false));
        }
        for (TracerGroupBuilder flag : this.fTracerGroupBuilders.values()) {
            flag.evaluate();
        }
        this.fTracerMapping.IValidatable_validate();
    }

    public void validate() throws ValidationException {
        this.generateSettings(NullCompilerLog.getInstance());
    }

    public DGCompilerSettings generateSettings(ICompilerLog log) throws ValidationException {
        this.evaluate();
        Map tracerGroups = this.generateTracerGroups(this.fTracerGroupBuilders);
        ITransformation[] transformations = this.generateTransformations(log, tracerGroups);
        HashMap tracerMap = new HashMap();
        MethodTracer[] tracers = this.generateMethodTracers(tracerGroups, tracerMap);
        MethodTracer intelligentTracer = this.fIntelligentInstrumentationEnabled ? this.getIntelligentInstrumentationTracer(tracers) : null;
        return new DGCompilerSettings(this.getPersonality(), this.getFilterBuilder().generateFilter(), this.getInstrumentationInfo(), this.getMinOffsetForJumpWidening(), transformations, tracers, tracerMap, this.getInstrumentationClassName(), tracerGroups, intelligentTracer);
    }

    private MethodTracer getIntelligentInstrumentationTracer(MethodTracer[] tracers) {
        int i = 0;
        while (i < tracers.length) {
            MethodTracer t = tracers[i];
            if (t.getTracerResource().equalsIgnoreCase("IntelligentAllMethodsResource")) {
                return t;
            }
            ++i;
        }
        return null;
    }

    private Map generateTracerGroups(Map flags) throws ValidationException {
        HashMap<FlagName, TracerGroup> results = new HashMap<FlagName, TracerGroup>();
        for (Map.Entry entry : flags.entrySet()) {
            FlagName name = (FlagName)entry.getKey();
            TracerGroupBuilder flag = (TracerGroupBuilder)entry.getValue();
            TracerGroup tracerGroup = flag.evaluate();
            results.put(name, tracerGroup);
        }
        return results;
    }

    private ITransformation[] generateTransformations(ICompilerLog log, Map tracerGroups) {
        ArrayList<ITransformation> results = new ArrayList<ITransformation>();
        for (ITransformationBuilder builder : this.fTransformations) {
            ITransformation transformation = builder.generateTransformation(log, this.getInstrumentationClassName(), tracerGroups);
            results.add(transformation);
        }
        return results.toArray(ITransformation.kZeroLengthArray);
    }

    private MethodTracer[] generateMethodTracers(Map tracerGroups, Map targetTracerMap) throws ValidationException {
        ArrayList<MethodTracer> results = new ArrayList<MethodTracer>();
        for (MethodTracerBuilder builder : this.fTracers) {
            MethodTracer tracer = builder.generateMethodTracer(this.getInstrumentationClassName(), tracerGroups);
            String[] tracerKeys = tracer.getTracerKeys();
            int i = 0;
            while (i < tracerKeys.length) {
                ArrayList<MethodTracer> currentMethodTracers = (ArrayList<MethodTracer>)targetTracerMap.get(tracerKeys[i]);
                if (currentMethodTracers == null) {
                    currentMethodTracers = new ArrayList<MethodTracer>();
                    targetTracerMap.put(tracerKeys[i], currentMethodTracers);
                }
                currentMethodTracers.add(tracer);
                ++i;
            }
            results.add(tracer);
        }
        return results.toArray(MethodTracer.kZeroLengthArray);
    }

    public Iterator getTracerIterator() {
        return this.fTracers.iterator();
    }

    TracerGroupBuilder[] debug_getFlags() {
        return this.fTracerGroupBuilders.values().toArray(TracerGroupBuilder.kZeroLengthArray);
    }

    ITransformationBuilder[] debug_getTransformations() {
        return this.fTransformations.toArray(ITransformationBuilder.kZeroLengthArray);
    }

    MethodTracerBuilder[] debug_getTracers() {
        return this.fTracers.toArray(MethodTracerBuilder.kZeroLengthArray);
    }

    public void setIntelligentInstrumentationEnabled(boolean bEnabled) {
        this.fIntelligentInstrumentationEnabled = bEnabled;
    }

    public void setAutoProbeConfig(IAutoProbeConfig conf) {
        this.fAutoProbeConfig = conf;
    }

    public void setAgent(IAgent agent) {
        this.fAgent = agent;
    }
}

