/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.extension;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.extension.IExtensionLocatorPolicy;
import com.wily.introscope.agent.extension.OptionalExtensionsManager;
import com.wily.introscope.agent.util.DefaultOptionalExtensionsProfileFinder;
import com.wily.introscope.agent.util.OptionalExtensionsProfileFinder;
import com.wily.util.ConfigurationWatcher;
import com.wily.util.ConfigurationWatcherElement;
import com.wily.util.IConfigurationVariableResolver;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.finder.IResourceFinderFeedback;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.resource.FileBasedResource;
import com.wily.util.resource.IResource;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtensionProfileAdministrator {
    private final IAgent fAgent;
    private final ExtensionAdministrator fExtensionAdministrator;
    private final IExtensionLocatorPolicy fPolicy;
    private final ConfigurationWatcher fConfigurationWatcher;
    private final IModuleFeedbackChannel fFeedback;
    private final IResource fCoreProfileResource;
    private IResource fResourceOptionalExtensionsProfile;
    private final IResourceFinderFeedback fResourceFinderFeedback;
    private final ExtensionProfileVariableResolver fVariableResolver = new ExtensionProfileVariableResolver();

    public ExtensionProfileAdministrator(IAgent agent, ExtensionAdministrator extensionAdministrator, ConfigurationWatcher configWatcher, IResource coreProfile, IExtensionLocatorPolicy policy, IResourceFinderFeedback resourceFinderFeedback) {
        this.fAgent = agent;
        this.fExtensionAdministrator = extensionAdministrator;
        this.fPolicy = policy;
        this.fConfigurationWatcher = configWatcher;
        this.fConfigurationWatcher.addVariableResolver(this.fVariableResolver);
        this.fFeedback = this.fAgent.IAgent_getModuleFeedback();
        this.fCoreProfileResource = coreProfile;
        this.fResourceFinderFeedback = resourceFinderFeedback;
        DefaultOptionalExtensionsProfileFinder finderOptionalExtensions = new DefaultOptionalExtensionsProfileFinder(this.fAgent, this.fCoreProfileResource);
        this.fResourceOptionalExtensionsProfile = finderOptionalExtensions.IResourceFinder_findResource(this.fResourceFinderFeedback);
    }

    public IResource getfOptionalExtensionsProfileResource() {
        return this.fResourceOptionalExtensionsProfile;
    }

    private void addExtensionProfile(String extName) {
        OptionalExtensionsProfileFinder finderOptionalExtensionsProfile = new OptionalExtensionsProfileFinder(this.fExtensionAdministrator.getOptionalExtensionDirectory().getAbsolutePath(), extName);
        IResource fResourceExtension = finderOptionalExtensionsProfile.IResourceFinder_findResource(this.fResourceFinderFeedback);
        if (fResourceExtension != null && fResourceExtension.IResource_isFileResource()) {
            ConfigurationWatcherElement configWatcherElem = new ConfigurationWatcherElement();
            FileBasedResource fileResource = (FileBasedResource)fResourceExtension;
            File fConfigurationFile = new File(fileResource.IResource_getLocation());
            long fLastModified = fConfigurationFile.lastModified();
            configWatcherElem.setfConfigurationFile(fConfigurationFile);
            configWatcherElem.setfLastModified(fLastModified);
            configWatcherElem.setResource(fResourceExtension);
            configWatcherElem.setConsecutiveFailures(0);
            this.fConfigurationWatcher.addConfigWatcherElement(extName, configWatcherElem);
            this.fFeedback.debug("Extension Profile Names Add: " + extName);
        }
    }

    public void initialLoadExtensionProfiles(OptionalExtensionsManager manager) {
        ConfigurationWatcherElement configWatcherElem = new ConfigurationWatcherElement();
        FileBasedResource fileResource = (FileBasedResource)this.fResourceOptionalExtensionsProfile;
        File configurationFile = new File(fileResource.IResource_getLocation());
        long lastModified = configurationFile.lastModified();
        configWatcherElem.setfConfigurationFile(configurationFile);
        configWatcherElem.setfLastModified(lastModified);
        configWatcherElem.setResource(this.fResourceOptionalExtensionsProfile);
        configWatcherElem.setConsecutiveFailures(0);
        this.fConfigurationWatcher.addConfigWatcherElement("optionalExtProfile", configWatcherElem);
        this.fFeedback.info("Extension Profile: " + configurationFile.getAbsolutePath());
        this.reloadConfiguration();
        try {
            String extensions;
            IndexedProperties newProps = new IndexedProperties();
            newProps.load(this.fResourceOptionalExtensionsProfile.IResource_getSourceContents());
            String extensionsBoot = (String)newProps.get("introscope.agent.extensions.bundles.boot.load");
            if (extensionsBoot != null) {
                String[] extensionsArr = extensionsBoot.trim().split("\\s*,\\s*");
                int i = 0;
                while (i < extensionsArr.length) {
                    String extName = extensionsArr[i];
                    if (extName.length() > 0) {
                        this.addExtensionProfile(extName);
                    }
                    ++i;
                }
            }
            if ((extensions = (String)newProps.get("introscope.agent.extensions.bundles.load")) != null) {
                String[] extensionsArr = extensions.trim().split("\\s*,\\s*");
                int i = 0;
                while (i < extensionsArr.length) {
                    String extName = extensionsArr[i];
                    if (extName.length() > 0) {
                        this.addExtensionProfile(extName);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            this.fFeedback.warn("Error loading configuration resource " + this.fResourceOptionalExtensionsProfile.IResource_getLocation());
            this.fFeedback.verbose(e);
        }
        this.reloadConfiguration();
    }

    public void loadExtensionProfiles(HashSet<String> add) {
        if (this.fConfigurationWatcher == null) {
            this.fAgent.IAgent_getModuleFeedback().info("ConfigurationWatcher is null, can't load extension profiles");
            return;
        }
        Iterator<String> iterator = add.iterator();
        this.fAgent.IAgent_getModuleFeedback().debug("Extension Profile Names Add:" + add.toString());
        while (iterator.hasNext()) {
            String extName = iterator.next();
            this.addExtensionProfile(extName);
        }
    }

    public void unloadExtensionProfiles(HashSet<String> remove) {
        if (this.fConfigurationWatcher == null) {
            this.fFeedback.info("ConfigurationWatcher is null, can't unload extension profiles");
            return;
        }
        Iterator<String> iterator = remove.iterator();
        this.fFeedback.info("Extension Profile Names Remove:" + remove.toString());
        while (iterator.hasNext()) {
            String extName = iterator.next();
            this.fConfigurationWatcher.removeConfigWatcherElement(extName);
            this.fFeedback.info("Extension Profile Names Remove: " + extName);
        }
        this.reloadConfiguration();
    }

    public void reloadConfiguration() {
        if (this.fConfigurationWatcher == null) {
            this.fFeedback.info("ConfigurationWatcher is null, can't reload extension profiles");
            return;
        }
        IndexedProperties prevProps = this.fConfigurationWatcher.getProperties();
        this.fFeedback.debug("Extension Profile Names reload Configuration");
        this.fConfigurationWatcher.reloadConfig();
        IndexedProperties newProps = this.fConfigurationWatcher.getProperties();
        HashSet<Object> newSet = new HashSet<Object>(newProps.keySet());
        HashSet<Object> prevSet = new HashSet<Object>(prevProps.keySet());
        newSet.removeAll(prevProps.keySet());
        prevSet.removeAll(newProps.keySet());
        if (!newSet.isEmpty()) {
            this.fFeedback.info("Loaded these new properties: " + newSet.toString());
            for (String string : newSet) {
                this.fFeedback.info(String.valueOf(string) + " = " + newProps.getProperty(string));
            }
        }
        if (!prevSet.isEmpty()) {
            this.fFeedback.info("Unloaded these properties: " + prevSet.toString());
            for (String string : prevSet) {
                this.fFeedback.info(String.valueOf(string) + " = " + prevProps.getProperty(string));
            }
        }
    }

    private static class ExtensionProfileVariableResolver
    implements IConfigurationVariableResolver {
        private ExtensionProfileVariableResolver() {
        }

        public void resolve(IndexedProperties props, ConfigurationWatcherElement element) {
            String extensionHome = null;
            File profile = element.getfConfigurationFile();
            if (profile.getName().equals("bundle.properties")) {
                try {
                    extensionHome = profile.getParentFile().getCanonicalPath();
                }
                catch (IOException iOException) {}
            }
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                if (!(e.getValue() instanceof String)) continue;
                String value = (String)e.getValue();
                if (extensionHome == null || !value.contains("{ApmExtensionHome}")) continue;
                value = value.replace("{ApmExtensionHome}", extensionHome);
                props.setProperty((String)e.getKey(), value);
            }
        }
    }
}

