/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.io.ASocketNameFormatter;
import com.wily.introscope.agent.trace.nio.SocketChannelMap;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;

public class SocketConnectNameFormatter
extends ASocketNameFormatter {
    public SocketConnectNameFormatter(IAgent agent) {
        super(agent);
    }

    @Override
    protected ASocketNameFormatter.ResourceAndAddress getResourceAndAddress(InvocationData data) {
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof SocketChannel) {
            String resourceName = SocketChannelMap.getResourceName(invocationObject);
            InetSocketAddress address = (InetSocketAddress)data.getInvocationParameterAsObject(0);
            SocketChannel channel = (SocketChannel)invocationObject;
            InetSocketAddress local = (InetSocketAddress)channel.socket().getLocalSocketAddress();
            if (resourceName != null && address != null) {
                return new ASocketNameFormatter.ResourceAndAddress(resourceName, local, address);
            }
        }
        return null;
    }
}

