/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.transactiontrace;

import com.wily.introscope.spec.server.transactiontrace.ATransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.ITailParameterTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.Glob;
import com.wily.util.text.IStringLocalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class ErrorTransactionTraceFilter
extends ATransactionTraceFilter
implements ITailParameterTransactionTraceFilter,
Externalizable {
    private static final long serialVersionUID = 4840499195319145419L;
    private Glob errorStringToMatch;

    public ErrorTransactionTraceFilter() {
        this.errorStringToMatch = null;
    }

    public ErrorTransactionTraceFilter(String toMatch) {
        this.errorStringToMatch = new Glob(toMatch);
    }

    public String getFilterSpecification() {
        return this.errorStringToMatch.getPattern();
    }

    public boolean ITransactionTraceFilter_passesFilter(TransactionComponentData root) {
        String traceType = root.getParameterValue("Trace Type");
        if (traceType != null && !traceType.equals("Normal")) {
            return false;
        }
        ArrayList<TransactionComponentData> toScan = new ArrayList<TransactionComponentData>();
        toScan.add(root);
        while (!toScan.isEmpty()) {
            TransactionComponentData cur = (TransactionComponentData)toScan.remove(toScan.size() - 1);
            String error = cur.getParameterValue("Error Message");
            if (error == null) {
                error = cur.getParameterValue("Exception");
            }
            if (error != null && this.errorStringToMatch.matches(error)) {
                return true;
            }
            int i = 0;
            while (i < cur.getCalledComponentCount()) {
                toScan.add(cur.getCalledComponent(i));
                ++i;
            }
        }
        return false;
    }

    public boolean shouldCollect(Map parameters) {
        return true;
    }

    public static int getFilterType() {
        return 4;
    }

    public int ITransactionTraceFilter_getFilterType() {
        return ErrorTransactionTraceFilter.getFilterType();
    }

    public String ITransactionTraceFilter_getLocalizedDescription(IStringLocalizer localizer) {
        return "Errors matching " + this.getFilterSpecification();
    }

    public static ErrorTransactionTraceFilter read(DataInput in) throws IOException {
        ErrorTransactionTraceFilter filter = new ErrorTransactionTraceFilter();
        filter.readInternal(in);
        return filter;
    }

    public int hashCode() {
        return this.errorStringToMatch.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ErrorTransactionTraceFilter) {
            ErrorTransactionTraceFilter filter = (ErrorTransactionTraceFilter)obj;
            return this.errorStringToMatch.equals(filter.errorStringToMatch);
        }
        return false;
    }

    public void ITransactionTraceFilter_write(DataOutput out) throws IOException {
        this.writeInternal(out);
    }

    public final void writeExternal(ObjectOutput out) throws IOException {
        this.writeInternal(out);
    }

    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readInternal(in);
    }

    public void writeInternal(DataOutput out) throws IOException {
        out.writeUTF(this.errorStringToMatch.getPattern());
    }

    protected void readInternal(DataInput in) throws IOException {
        this.errorStringToMatch = new Glob(in.readUTF());
    }

    public String toString() {
        return "[errorFilter = " + this.getFilterSpecification() + "]";
    }

    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer) {
        return "with errors matching " + this.getFilterSpecification();
    }

    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer, Locale locale) {
        return "with errors matching " + this.getFilterSpecification();
    }

    public boolean isHeadFilter() {
        return false;
    }

    public boolean ITailParameterTransactionTraceFilter_passesFilter(Map parameters) {
        HashSet errors = (HashSet)parameters.get("introscope.transactiontrace.errorfilter.key");
        if (errors != null) {
            for (Object value : errors) {
                String errMsg;
                if (!(value instanceof String) || !this.errorStringToMatch.matches(errMsg = (String)value)) continue;
                return true;
            }
        }
        return false;
    }
}

