/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import com.wily.util.adt.IConcurrentLinkedQueueFactory;
import com.wily.util.adt.IConcurrentMapFactory;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IndexedProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class ConcurrentFactoryLoader {
    private static final String kConcurrentMapFactoryClassName = "com.wily.util.adt.ConcurrentMapFactory";
    private static final String kConcurrentLinkedQueueFactoryClassName = "com.wily.util.adt.ConcurrentLinkedQueueFactory";

    public static final IConcurrentMapFactory getConcurrentMapFactory(IModuleFeedbackChannel feedback) {
        Object result = ConcurrentFactoryLoader.getConcurrentFactory(feedback, null, kConcurrentMapFactoryClassName, "Error while loading ConcurrentMapFactory.", "getConcurrentMapFactory()");
        if (result != null) {
            return (IConcurrentMapFactory)result;
        }
        return null;
    }

    public static final IConcurrentMapFactory getConcurrentMapFactory(IModuleFeedbackChannel feedback, IndexedProperties properties) {
        Object result = ConcurrentFactoryLoader.getConcurrentFactory(feedback, properties, kConcurrentMapFactoryClassName, "Error while loading ConcurrentMapFactory.", "getConcurrentMapFactory()");
        if (result != null) {
            return (IConcurrentMapFactory)result;
        }
        return null;
    }

    public static final IConcurrentLinkedQueueFactory getConcurrentLinkedQueueFactory(IModuleFeedbackChannel feedback, IndexedProperties properties) {
        Object result = ConcurrentFactoryLoader.getConcurrentFactory(feedback, properties, kConcurrentLinkedQueueFactoryClassName, "Error while loading ConcurrentLinkedQueueFactory.", "getConcurrentLinkedQueueFactory()");
        if (result != null) {
            return (IConcurrentLinkedQueueFactory)result;
        }
        return null;
    }

    public static final IConcurrentLinkedQueueFactory getConcurrentLinkedQueueFactory(IModuleFeedbackChannel feedback) {
        Object result = ConcurrentFactoryLoader.getConcurrentFactory(feedback, null, kConcurrentLinkedQueueFactoryClassName, "Error while loading ConcurrentLinkedQueueFactory.", "getConcurrentLinkedQueueFactory()");
        if (result != null) {
            return (IConcurrentLinkedQueueFactory)result;
        }
        return null;
    }

    private static final Object getConcurrentFactory(IModuleFeedbackChannel feedback, IndexedProperties properties, String className, String errorString, String debugString) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            feedback.error(errorString);
            feedback.debug(debugString, e);
            return null;
        }
        Constructor<?> ctor = null;
        try {
            ctor = properties == null ? clazz.getConstructor(new Class[0]) : clazz.getConstructor(IModuleFeedbackChannel.class, IndexedProperties.class);
        }
        catch (SecurityException e) {
            feedback.error(errorString);
            feedback.debug(debugString, e);
            return null;
        }
        catch (NoSuchMethodException e) {
            feedback.error(errorString);
            feedback.debug(debugString, e);
            return null;
        }
        if (ctor == null) {
            return null;
        }
        try {
            if (properties == null) {
                Object factory = ctor.newInstance(new Object[0]);
                return factory;
            }
            Object factory = ctor.newInstance(feedback, properties);
            return factory;
        }
        catch (IllegalArgumentException e) {
            feedback.error(errorString);
            feedback.debug(debugString, e);
        }
        catch (InstantiationException e) {
            feedback.error(errorString);
            feedback.debug(debugString, e);
        }
        catch (IllegalAccessException e) {
            feedback.error(errorString);
            feedback.debug(debugString, e);
        }
        catch (InvocationTargetException e) {
            feedback.error(errorString);
            feedback.debug(debugString, e);
        }
        return null;
    }
}

