/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.bizrecording;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.bizrecording.BizRecordingDataWrapper;
import com.wily.introscope.agent.bizrecording.BizRecordingSession;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.spec.common.bizrecording.BizTransactionRecordedComponent;
import com.wily.introscope.spec.server.beans.bizrecording.IEMBizRecordingServiceCallback;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.service.ServiceException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.Map;

class BizRecordingServletTracerInstance
implements ITracer {
    private final IAgent fAgent;
    private final IModuleFeedbackChannel fFeedback;
    private final Map fSessions;
    private BizRecordingDataWrapper fWrapper;

    public BizRecordingServletTracerInstance(IAgent agent, Map sessions) {
        this.fAgent = agent;
        this.fFeedback = this.fAgent.IAgent_getModuleFeedback();
        this.fSessions = sessions;
        this.fWrapper = null;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        BizRecordingDataWrapper.resetThreadLocalData();
        if (this.fSessions.size() == 0) {
            return;
        }
        try {
            this.fWrapper = new BizRecordingDataWrapper(data);
        }
        catch (Throwable e) {
            this.fFeedback.debug("Failed to start recording in BizRecordingTracer", e);
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (this.fSessions.size() == 0) {
            return;
        }
        BizTransactionRecordedComponent btc = null;
        try {
            BizRecordingDataWrapper wrapper = this.fWrapper;
            String address = wrapper.getRemoteAddress();
            String language = wrapper.getAcceptLanguage();
            for (Map.Entry entry : this.fSessions.entrySet()) {
                BizRecordingSession session = (BizRecordingSession)entry.getValue();
                if (session.matches(address, language)) {
                    if (btc == null) {
                        btc = new BizTransactionRecordedComponent();
                        btc.setName(wrapper.getName());
                        btc.setPathParams(wrapper.getPath());
                        btc.setRecordingDate(wrapper.getRecordingDate());
                        btc.setServerIPAddress(wrapper.getServerAddress());
                        btc.setServerPort(wrapper.getServerPort());
                        btc.setRequestHeader(wrapper.getRequestHeader());
                        btc.setRequestBody(wrapper.getRequestBody());
                        btc.setResponseHeader(wrapper.getResponseHeader());
                        btc.setResponseBody(wrapper.getResponseBody());
                    }
                    if (session.getConnector() == null) continue;
                    IEMBizRecordingServiceCallback callback = (IEMBizRecordingServiceCallback)session.getConnector().getInterface();
                    callback.recordComponent(session.getSessionId(), btc);
                    continue;
                }
                if (!this.fFeedback.isDebugEnabled()) continue;
                StringBuffer buf = new StringBuffer();
                buf.append("BizRecording component rejected").append("\nAddress=").append(address).append(" vs ClientIPFilter=").append(session.getClientIpFilter()).append("\nLanguage=").append(language).append(" vs LanguageFilter=").append(session.getLanguageFilter()).append('\n');
                this.fFeedback.debug(buf.toString());
            }
            if (btc != null && this.fFeedback.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf.append("BizRecording component recorded").append("\nName=").append(wrapper.getName()).append("\nPath=").append(wrapper.getPath()).append("\nDate=").append(wrapper.getRecordingDate()).append("\nAddress=").append(wrapper.getServerAddress()).append("\nPort=").append(wrapper.getServerPort()).append("\nRequestHeader=\n").append(wrapper.getRequestHeader()).append("\nRequestBody=").append(wrapper.getRequestBody()).append("\nResponseHeader=\n").append(wrapper.getResponseHeader()).append("\nResponseBody=").append(wrapper.getResponseBody()).append('\n');
                this.fFeedback.debug(buf.toString());
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (ConnectionException ce) {
            this.fFeedback.debug("ConnectionException in BizRecordingTracer", ce);
        }
        catch (ServiceException se) {
            this.fFeedback.debug("ServiceException in BizRecordingTracer", se);
        }
        catch (Throwable e) {
            this.fFeedback.debug("Failed to record in BizRecordingTracer", e);
        }
    }
}

