/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.blame;

import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.util.HashCodeUtils;

final class BlamedMetricCache {
    private static final int kDefaultInitialCapacity = 95;
    private static final float kLoadFactor = 0.75f;
    private Entry[] fTable = new Entry[95];
    private int fCount = 0;

    public int size() {
        return this.fCount;
    }

    public void put(String component, String blamedMetric, int type, IDataAccumulator accumulator) {
        Entry newEntry;
        int hashcode = this.calculateHashCode(component, blamedMetric, type);
        int index = (hashcode & Integer.MAX_VALUE) % this.fTable.length;
        Entry e = this.fTable[index];
        this.fTable[index] = newEntry = new Entry(hashcode, component, blamedMetric, type, accumulator, e);
        ++this.fCount;
        if ((float)this.fCount > (float)this.fTable.length * 0.75f) {
            this.rehash();
        }
    }

    public IDataAccumulator get(String component, String blamedMetric, int type) {
        int hashcode = this.calculateHashCode(component, blamedMetric, type);
        Entry e = this.fTable[(hashcode & Integer.MAX_VALUE) % this.fTable.length];
        while (e != null) {
            if (e.fComponent.equals(component) && e.fBlamedMetric.equals(blamedMetric) && e.fType == type) {
                return e.fValue;
            }
            e = e.fNext;
        }
        return null;
    }

    private int calculateHashCode(String component, String blamedMetric, int type) {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode(result, component.hashCode());
        result = HashCodeUtils.accumulateHashCode(result, blamedMetric.hashCode());
        result = HashCodeUtils.accumulateHashCode(result, HashCodeUtils.hashInt(type));
        return result;
    }

    private void rehash() {
        Entry[] newTable = new Entry[this.fTable.length * 2 + 1];
        int i = 0;
        while (i < this.fTable.length) {
            Entry e = this.fTable[i];
            Entry nextE = null;
            while (e != null) {
                Entry newNext;
                nextE = e.fNext;
                int newIndex = (e.fHashcode & Integer.MAX_VALUE) % newTable.length;
                e.fNext = newNext = newTable[newIndex];
                newTable[newIndex] = e;
                e = nextE;
            }
            ++i;
        }
        this.fTable = newTable;
    }

    private static final class Entry {
        public final int fHashcode;
        public final String fComponent;
        public final String fBlamedMetric;
        public final int fType;
        public final IDataAccumulator fValue;
        public Entry fNext;

        private Entry(int hashcode, String component, String blamedMetric, int type, IDataAccumulator value, Entry next) {
            this.fHashcode = hashcode;
            this.fComponent = component;
            this.fBlamedMetric = blamedMetric;
            this.fType = type;
            this.fValue = value;
            this.fNext = next;
        }
    }
}

