/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.gatherer.AIntegerCombiningGatherer;
import com.wily.introscope.stat.timeslice.IntegerTimeslicedValue;
import com.wily.wilyassert.Assertion;

public class IntegerSummingGatherer
extends AIntegerCombiningGatherer {
    private int fMin;
    private int fMax;
    private int fValue;

    public IntegerSummingGatherer(int typeCookie, long startTimestamp) {
        super(typeCookie, startTimestamp);
        this.reset();
        Assertion.wilyAssert(false);
    }

    protected void doAcceptAggregateIntegerTimeslicedValue(IntegerTimeslicedValue typedAggregate) {
        this.addToDataPointCount(typedAggregate.getDataPointCount());
        this.fValue += typedAggregate.getValue();
        this.fMin += typedAggregate.getMinimum();
        this.fMax += typedAggregate.getMaximum();
    }

    public int getIntValue() {
        return this.fValue;
    }

    public int getIntMinimum() {
        return this.fMin;
    }

    public int getIntMaximum() {
        return this.fMax;
    }

    protected void directSetIntMinimum(int minimum) {
        this.fMin = minimum;
    }

    protected void directSetIntMaximum(int maximum) {
        this.fMax = maximum;
    }

    protected void doResetCombiningGatherer(long when) {
        this.reset();
    }

    protected void doReinitializeCombiningGatherer() {
        this.reset();
    }

    private void reset() {
        this.fMin = 0;
        this.fMax = 0;
        this.fValue = 0;
    }

    public static IMetricDataValue aggregateByTime(IMetricDataValue pvalue1, IMetricDataValue pvalue2) {
        IntegerTimeslicedValue value1 = (IntegerTimeslicedValue)pvalue1;
        IntegerTimeslicedValue value2 = (IntegerTimeslicedValue)pvalue2;
        if (value1.dataIsAbsent() || value2.dataIsAbsent()) {
            return IntegerSummingGatherer.absentInt(value1, value2);
        }
        long count = value1.getDataPointCount() + value2.getDataPointCount();
        int min = value1.getMinimum() + value2.getMinimum();
        int max = value1.getMaximum() + value2.getMaximum();
        int val = value1.getValue() + value2.getValue();
        return new IntegerTimeslicedValue(value1.getType(), value1.getStartTimestampInMillis(), value2.getStopTimestampInMillis(), null, count, false, val, min, max);
    }
}

