/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import com.wily.util.adt.ICappedMap;
import com.wily.util.adt.QueueWrapper;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentHighPerformanceLRUHashMap<T, V>
implements Map<T, V>,
ICappedMap {
    protected final int fConcurrency;
    private static final long serialVersionUID = 123123L;
    private final LRUCache[] LRUMaps;
    private IModuleFeedbackChannel fFeedback;
    protected static final int kDefaultMaxSize = 16;
    protected static final int kDefaultConcurrency = 16;

    public ConcurrentHighPerformanceLRUHashMap() {
        this(16, 16);
    }

    public ConcurrentHighPerformanceLRUHashMap(int maxSize) {
        this(16, maxSize);
    }

    public ConcurrentHighPerformanceLRUHashMap(int concurrency, int maxSize) {
        this.fConcurrency = concurrency;
        this.LRUMaps = new LRUCache[this.fConcurrency];
        int i = 0;
        while (i < this.fConcurrency) {
            this.LRUMaps[i] = new LRUCache(maxSize);
            ++i;
        }
    }

    @Override
    public void increaseMaxSize(int newMaxSize) {
        int i = 0;
        while (i < this.LRUMaps.length) {
            try {
                this.LRUMaps[i].increaseMaxSize(newMaxSize);
            }
            catch (Exception exception) {}
            ++i;
        }
    }

    protected int getIndex(Object key) {
        int hashCode = key.hashCode();
        return (hashCode & Integer.MAX_VALUE) % this.fConcurrency;
    }

    protected final int getIndexFromHashCode(int explicitHashCode) {
        return (explicitHashCode & Integer.MAX_VALUE) % this.fConcurrency;
    }

    @Override
    public V get(Object key) {
        int index = this.getIndex(key);
        return this.get(index, key);
    }

    protected final V get(int index, Object key) {
        LRUCache cache = this.LRUMaps[index];
        cache.lock.lock();
        try {
            Object v = cache.get(key);
            return v;
        }
        finally {
            cache.lock.unlock();
        }
    }

    @Override
    public V put(T key, V value) {
        int index = this.getIndex(key);
        return this.put(index, key, value);
    }

    @Override
    public V putIfAbsent(T key, V value) {
        int index = this.getIndex(key);
        return this.putIfAbsent(index, key, value);
    }

    protected final V put(int index, T key, V value) {
        LRUCache cache = this.LRUMaps[index];
        cache.lock.lock();
        try {
            V v = cache.put(key, value);
            return v;
        }
        finally {
            cache.lock.unlock();
        }
    }

    protected final V putIfAbsent(int index, T key, V value) {
        LRUCache cache = this.LRUMaps[index];
        cache.lock.lock();
        try {
            if (!cache.containsKey(key)) {
                V v = cache.put(key, value);
                return v;
            }
            Object v = cache.get(key);
            return v;
        }
        finally {
            cache.lock.unlock();
        }
    }

    public int approximateSize() {
        int approximateSize = 0;
        int i = 0;
        while (i < this.fConcurrency) {
            approximateSize += this.LRUMaps[i].size();
            ++i;
        }
        return approximateSize;
    }

    @Override
    public int size() {
        return this.approximateSize();
    }

    @Override
    public boolean isEmpty() {
        return this.approximateSize() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        int index = this.getIndex(key);
        return this.containsKey(index, key);
    }

    protected final boolean containsKey(int index, Object key) {
        LRUCache cache = this.LRUMaps[index];
        cache.lock.lock();
        try {
            boolean bl = cache.containsKey(key);
            return bl;
        }
        finally {
            cache.lock.unlock();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        int i = 0;
        while (i < this.fConcurrency) {
            LRUCache cache = this.LRUMaps[i];
            cache.lock.lock();
            try {
                if (cache.containsValue(value)) {
                    return true;
                }
            }
            finally {
                cache.lock.unlock();
            }
            ++i;
        }
        return false;
    }

    @Override
    public V remove(Object key) {
        int index = this.getIndex(key);
        return this.remove(index, key);
    }

    protected final V remove(int index, Object key) {
        LRUCache cache = this.LRUMaps[index];
        cache.lock.lock();
        try {
            Object v = cache.remove(key);
            return v;
        }
        finally {
            cache.lock.unlock();
        }
    }

    @Override
    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        int i = 0;
        while (i < this.fConcurrency) {
            LRUCache cache = this.LRUMaps[i];
            cache.lock.lock();
            try {
                cache.clear();
            }
            finally {
                cache.lock.unlock();
            }
            ++i;
        }
    }

    @Override
    public Set<T> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<T, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    public IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }

    public void setFeedback(IModuleFeedbackChannel fFeedback) {
        this.fFeedback = fFeedback;
    }

    @Override
    public void setCallback(ICappedMap.IOnEntryRemovedListener callback) {
        int i = 0;
        while (i < this.fConcurrency) {
            this.LRUMaps[i].fCallback = callback;
            ++i;
        }
    }

    @Override
    public void iterateThrougEntries(ICappedMap.IOperateOnEntry delegate) {
        Object key = null;
        Object value = null;
        ArrayList c = new ArrayList();
        MutableMapEntry entry = new MutableMapEntry();
        int i = 0;
        while (i < this.fConcurrency) {
            LRUCache cache = this.LRUMaps[i];
            cache.lock.lock();
            try {
                c.addAll(cache.keySet());
            }
            finally {
                cache.lock.unlock();
            }
            Iterator j = c.iterator();
            while (j.hasNext()) {
                cache.lock.lock();
                try {
                    key = j.next();
                    value = cache.get(key);
                }
                finally {
                    cache.lock.unlock();
                }
                entry.setKey(key);
                entry.setValue(value);
                delegate.doOnEntry(entry);
            }
            c.clear();
            ++i;
        }
    }

    public int deepSize() {
        int approximateSize = 0;
        int i = 0;
        while (i < this.fConcurrency) {
            LRUCache cache = this.LRUMaps[i];
            cache.lock.lock();
            try {
                for (Object value : this.LRUMaps[i].values()) {
                    if (value != null && value instanceof List) {
                        approximateSize += ((List)value).size();
                        continue;
                    }
                    if (value != null && value instanceof QueueWrapper) {
                        approximateSize += ((QueueWrapper)value).size();
                        continue;
                    }
                    if (value == null || !(value instanceof String)) continue;
                    approximateSize += ((String)value).length();
                }
                approximateSize += this.LRUMaps[i].size();
            }
            finally {
                cache.lock.unlock();
            }
            ++i;
        }
        return approximateSize;
    }

    private static class LRUCache
    extends LinkedHashMap {
        private static final long serialVersionUID = 1L;
        private final ReentrantLock lock;
        private int fMaxSize;
        private volatile ICappedMap.IOnEntryRemovedListener fCallback;

        public LRUCache(int maxSize) {
            super(maxSize + 1, 1.0f, true);
            this.fMaxSize = maxSize;
            this.lock = new ReentrantLock(false);
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            boolean result;
            boolean bl = result = super.size() > this.fMaxSize;
            if (result && this.fCallback != null) {
                this.fCallback.onEntryRemoved(eldest);
            }
            return result;
        }

        public void increaseMaxSize(int newSize) {
            if (newSize > this.fMaxSize) {
                this.fMaxSize = newSize;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MutableMapEntry
    implements Map.Entry<T, V> {
        private T fKey;
        private V fValue;

        private MutableMapEntry() {
        }

        @Override
        public T getKey() {
            return this.fKey;
        }

        @Override
        public V getValue() {
            return this.fValue;
        }

        @Override
        public V setValue(V value) {
            this.fValue = value;
            return this.fValue;
        }

        public void setKey(T key) {
            this.fKey = key;
        }
    }
}

