/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ctg.client;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.ConcurrentInvocationCounter;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.properties.AttributeListing;
import com.wily.zos.tools.DebugController;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.Hashtable;

public final class WilyJavaGatewayTracer
extends ASingleInstanceTracerFactory {
    private static final String CLASS_NAME = WilyJavaGatewayTracer.class.getSimpleName();
    private final ReentrancyLevel fReentrancyLevel;
    ConcurrentInvocationCounter fConcurrentInvokeParent;
    ITracer fConcurrentTracer;
    IIntegerFluctuatingCounterDataAccumulator fDataAccumulator;
    IIntegerFluctuatingCounterDataAccumulator bci_counter;
    IIntegerFluctuatingCounterDataAccumulator ci_counter;
    private String gatewayName;
    private String programName;
    private String tranId;
    private String saved_tranId;
    private String saved_gatewayName;
    private String cics_ErrMessage;
    private String err_detect_errMessage;
    private int cics_RetCode;
    private int reported_error_count;
    public String Eci_HLQ;
    public String InvokesPerSecond;
    public String AggregateCount;
    public String errorInterval_Agg_Stats;
    private String eci_ComponentName;
    private String eci_GatewayName;
    private String eci_base_name;
    private int curr_TracerIndex;
    private IAgent my_agent;
    public long is_open;
    private boolean request_is_an_open;
    private boolean request_is_flow;
    private boolean request_is_service_flow;
    private boolean tls_uses_epi;
    private boolean trace_details;
    private boolean trace_START_details;
    private boolean needs_aggregate_counter;
    private boolean error_detected;
    private boolean is_CLEAR_Key;
    private boolean skip_tracing;
    private boolean startTrace_Issued;
    private int flow_type;
    int obj_InstanceOf;
    int parm_InstanceOf;
    Object requestObject;
    Class tcpgw_class;
    Class eciin_class;
    ClassLoader cloader;
    URLClassLoader uloader;
    private final DebugController debugger;
    public String str_API_Type;
    public Long curr_Eci_Epi_CallType;
    public String curr_Epi_TranId;
    long curr_Eci_Epi_Call_value;
    public Thread parentThread;
    int EE_COUNT;
    int ACTIVE_COUNT;
    public static final int CTG_ECI_ERR_NO_CICS = -3;
    public static final int CTG_EPI_ERR_SERVER_DOWN = 20;
    public static final int instanceof_TcpJavaGateway = 1;
    public static final int instanceof_SslJavaGateway = 2;
    public static final int instanceof_LocalJavaGateway = 3;
    public static final int instanceof_StatsJavaGateway = 4;
    public static final String kFrontend_Details_Metric_HLQ = "Frontends|Client_to_CTG_Details";
    public static final String kDetail_Aggregate_Request_Count_Suffix = ":Aggregate Request Count";
    public static final String kDetail_Aggregate_Service_Count_Suffix = ":Aggregate Service Count";
    public static final String kDetail_Aggregate_CLEAR_KEY_Count_Suffix = ":Clear Key Invocations Aggregate Count";
    public static final String kDetail_Aggregate_Error_Count_Suffix = ":Aggregate Errors";
    public static final String kFrontend_Aggregates_Metric_HLQ = "Frontends|Client_to_CTG_Aggregates";
    public static final String kAggregate_Open_RspTime_Suffix = ":Connection Open Response Time (ms)";
    public static final String kAggregate_Request_Program_Count_Suffix = ":Program Calls";
    public static final String kAggregate_Service_Count_Suffix = ":Service Calls";
    public static final String kAggregate_Open_Count_Suffix = ":Connection Opens";
    public static final String kAggregate_Error_Count_Suffix = ":Aggregate CTG Errors";
    public static final String kAggregate_Error_Gateway_to_CICS = ":Gateway Connection To CICS Error";
    public static final String kConcurrent_Invokes_Suffix = ":Concurrent Invocations";
    public static final String kResponses_per_Interval_Suffix = ":Responses Per Interval";
    public static final String kRspTime_Suffix = ":Average Response Time (ms)";
    public static final String kErrors_per_Interval_Suffix = ":Errors Per Interval";
    public static final String kStall_Count_Suffix = ":Stall Count";
    public static final int EPIRequest_EPI_START_TRAN = 7;
    public static final int FLOW_REQUEST = 1;
    public static final int FLOW_CONFIRM = 2;
    public static final int FLOW_REPLY = 3;
    public static final int FLOW_ERROR = 4;
    public static final int FLOW_HANDSHAKE = 5;
    public static final int FLOW_EXCEPTION = 6;
    public static final int FLOW_PING = 7;
    public static final int FLOW_PONG = 8;
    public static final int FLOW_CONFIRM_CALLBACK = 9;
    public static final int FLOW_CLOSE = 10;
    public static final int FLOW_REQUEST_AUTHORIZED = 11;
    public static final int EPI_FLOW_INITIALIZE = 1;
    public static final int EPI_FLOW_LIST_SYSTEMS = 3;
    public static final int EPI_FLOW_ADD_TERMINAL = 4;
    public static final int EPI_FLOW_INQUIRE_SYSTEM = 5;
    public static final int EPI_FLOW_DEL_TERMINAL = 6;
    public static final int EPI_FLOW_START_TRAN = 7;
    public static final int EPI_FLOW_REPLY = 8;
    public static final int EPI_FLOW_ATI_STATE = 9;
    public static final int EPI_FLOW_GET_EVENT = 11;
    public static final int EPI_FLOW_PURGE_TERMINAL = 13;
    public static final int EPI_FLOW_ADD_EX_TERMINAL = 14;
    public static final int EPI_FLOW_SET_SECURITY = 15;
    private static ThreadLocal<Object> eci_Epi_CallType = new ThreadLocal<Object>(){

        @Override
        protected synchronized Object initialValue() {
            return new Long(0L);
        }
    };
    private static ThreadLocal<Object> epi_TranId = new ThreadLocal<Object>(){

        @Override
        protected synchronized Object initialValue() {
            return null;
        }
    };
    static Hashtable<String, Object> concurrentDataAccumulatorTable = new Hashtable();

    public WilyJavaGatewayTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.debugger = new DebugController(agent);
        this.fReentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);
        this.parentThread = Thread.currentThread();
        this.Eci_HLQ = kFrontend_Details_Metric_HLQ;
        this.InvokesPerSecond = ":Invocations Per Second";
        this.AggregateCount = ":Aggregate Count";
        agent.IAgent_getDataAccumulatorFactory();
        this.my_agent = agent;
        this.curr_TracerIndex = 0;
        this.eci_ComponentName = null;
        this.eci_GatewayName = null;
        this.eci_base_name = null;
        this.requestObject = null;
        this.ci_counter = null;
        this.bci_counter = null;
        this.gatewayName = null;
        this.programName = null;
        this.tranId = null;
        this.saved_tranId = null;
        this.saved_gatewayName = null;
        this.cics_RetCode = 0;
        this.reported_error_count = 0;
        this.cics_ErrMessage = null;
        this.err_detect_errMessage = null;
        this.is_open = 0L;
        this.request_is_an_open = false;
        this.request_is_flow = false;
        this.request_is_service_flow = false;
        this.tls_uses_epi = false;
        this.trace_details = true;
        this.trace_START_details = false;
        this.needs_aggregate_counter = false;
        this.is_CLEAR_Key = false;
        this.skip_tracing = false;
        this.startTrace_Issued = false;
        this.errorInterval_Agg_Stats = null;
        this.flow_type = 0;
        this.EE_COUNT = 0;
        this.ACTIVE_COUNT = 0;
        try {
            Class<?> obj_Class = sampleTracedObject.getClass();
            String obj_ClassName = obj_Class.getName();
            this.obj_InstanceOf = obj_ClassName.equals("com.ibm.ctg.client.TcpJavaGateway") ? 1 : (obj_ClassName.equals("com.ibm.ctg.client.SslJavaGateway") ? 2 : (obj_ClassName.equals("com.ibm.ctg.client.LocalJavaGateway") ? 3 : (obj_ClassName.equals("com.ibm.ctg.client.StatsJavaGateway") ? 4 : -1)));
        }
        catch (Exception ex) {
            this.printDebugMessage("CONSTRUCTOR: ANOMALY ALERT 2 can't find the class", ex);
        }
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReentrancyLevel;
    }

    protected final IDataAccumulator createDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetLongAverageDataAccumulator(formattedMetricName);
    }

    protected final IIntegerFluctuatingCounterDataAccumulator createConcurrentDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(formattedMetricName);
    }

    protected String getComponentName(InvocationData data) {
        return this.getCompName(data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized String getCompName(InvocationData data) {
        String methodName;
        this.eci_ComponentName = null;
        String stack_eci_ComponentName = null;
        Object invokeObject = data.getInvocationObject();
        if (invokeObject == null) {
            this.printDebugMessage("getComponentName ANOMALY ALERT 3 InvocationObject=" + invokeObject);
            return null;
        }
        Class<?> parm_Class = null;
        String parm_ClassName = null;
        try {
            stack_eci_ComponentName = data.getOriginalComponentName();
            if (stack_eci_ComponentName == null) {
                stack_eci_ComponentName = this.formatParameterizedName(data);
            }
            this.curr_Eci_Epi_CallType = WilyJavaGatewayTracer.get_Eci_Epi_Call_Type();
            this.curr_Eci_Epi_Call_value = this.curr_Eci_Epi_CallType;
            this.obj_InstanceOf = 0;
            Class<?> obj_Class = invokeObject.getClass();
            if (obj_Class == null) {
                return null;
            }
            String obj_ClassName = obj_Class.getName();
            if (obj_ClassName == null) {
                return null;
            }
            if (obj_ClassName.equals("com.ibm.ctg.client.TcpJavaGateway")) {
                this.obj_InstanceOf = 1;
            } else if (obj_ClassName.equals("com.ibm.ctg.client.SslJavaGateway")) {
                this.obj_InstanceOf = 2;
            } else if (obj_ClassName.equals("com.ibm.ctg.client.LocalJavaGateway")) {
                this.obj_InstanceOf = 3;
            } else {
                if (obj_ClassName.equals("com.ibm.ctg.client.StatsJavaGateway")) {
                    this.obj_InstanceOf = 4;
                    return null;
                }
                this.obj_InstanceOf = -1;
                this.printDebugMessage("getComponentName ANOMALY ALERT 4 - STRANGE InvokeObject=" + obj_ClassName);
                return null;
            }
            methodName = data.getProbeInformation().getProbeIdentification().getProbeMethodName();
            if (methodName == null) {
                return null;
            }
        }
        catch (Exception ex) {
            this.printDebugMessage("getComponentName exception1", ex);
            ex.printStackTrace();
            return null;
        }
        Object parmObject = null;
        this.requestObject = null;
        this.tls_uses_epi = false;
        this.skip_tracing = false;
        this.trace_START_details = false;
        this.request_is_service_flow = false;
        this.is_CLEAR_Key = false;
        boolean is_eci_request = false;
        try {
            if (data.getInvocationParameterCount() > 0) {
                this.requestObject = parmObject = data.getInvocationParameterAsObject(0);
            }
            if (methodName.equals("flow") && data.getInvocationParameterCount() > 0) {
                parmObject = data.getInvocationParameterAsObject(0);
                if (parmObject == null) {
                    return null;
                }
                this.requestObject = parmObject;
                parm_Class = parmObject.getClass();
                if (parm_Class == null) {
                    return null;
                }
                parm_ClassName = parm_Class.getName();
                if (parm_ClassName == null) {
                    return null;
                }
                if (parm_ClassName.equals("com.ibm.ctg.client.EPIRequest") || parm_ClassName.equals("com.ibm.ctg.client.CicsCpRequest")) {
                    this.tls_uses_epi = true;
                    if (this.curr_Eci_Epi_Call_value < 3L) {
                        this.curr_Eci_Epi_Call_value = 3L;
                        WilyJavaGatewayTracer.set_Eci_Epi_Call_Type(new Long(this.curr_Eci_Epi_Call_value));
                    }
                    this.eci_base_name = "Frontends|Client_to_CTG_Aggregates|BASE_ECI_EPI";
                } else {
                    if (parm_ClassName.equals("com.ibm.ctg.client.ECIRequest")) {
                        is_eci_request = true;
                    }
                    if (this.curr_Eci_Epi_Call_value >= 3L) {
                        this.curr_Eci_Epi_Call_value = 0L;
                        WilyJavaGatewayTracer.set_Eci_Epi_Call_Type(new Long(this.curr_Eci_Epi_Call_value));
                    }
                    this.eci_base_name = "Frontends|Client_to_CTG_Aggregates|BASE_ECI_EPI";
                    if (stack_eci_ComponentName.endsWith("_EPI")) {
                        stack_eci_ComponentName = "Frontends|Client_to_CTG_Aggregates|BASE_ECI_EPI";
                    }
                }
            }
            switch ((int)this.curr_Eci_Epi_Call_value) {
                case 0: {
                    this.str_API_Type = "|BASE_ECI_EPI";
                    break;
                }
                case 1: {
                    this.str_API_Type = "|JCA_ECI";
                    break;
                }
                case 2: {
                    this.str_API_Type = "|CCF_ECI";
                    break;
                }
                case 3: {
                    this.str_API_Type = "|BASE_ECI_EPI";
                    this.tls_uses_epi = true;
                    break;
                }
                case 4: {
                    this.str_API_Type = "|JCA_EPI";
                    this.tls_uses_epi = true;
                    break;
                }
                case 5: {
                    this.str_API_Type = "|CCF_EPI";
                    this.tls_uses_epi = true;
                    break;
                }
                case 6: {
                    this.str_API_Type = "|LOCAL_ECI";
                    break;
                }
                case 7: {
                    this.str_API_Type = "|LOCAL_EPI";
                    this.tls_uses_epi = true;
                    break;
                }
                default: {
                    this.str_API_Type = "";
                }
            }
            int i = stack_eci_ComponentName.indexOf("|XXX_XXX_CT");
            if (i > 0) {
                StringBuffer strBuf = new StringBuffer(stack_eci_ComponentName.substring(0, i));
                strBuf.append(this.str_API_Type);
                stack_eci_ComponentName = strBuf.toString();
            }
        }
        catch (Exception ex) {
            this.printDebugMessage("getComponentName exception2", ex);
            ex.printStackTrace();
            return null;
        }
        try {
            if (this.obj_InstanceOf != 1 && this.obj_InstanceOf != 2 && this.obj_InstanceOf != 3) {
                return null;
            }
            if (methodName.equals("open")) {
                return this.getCompName_Open(data, stack_eci_ComponentName);
            }
            if (methodName.equals("close")) {
                return this.getCompName_Close(data, stack_eci_ComponentName);
            }
            this.trace_details = true;
            if (methodName.equals("flow")) {
                return this.getCompName_Flow(data, parmObject, parm_Class, parm_ClassName, stack_eci_ComponentName, is_eci_request);
            }
        }
        catch (Exception ex) {
            this.printDebugMessage("getComponentName exception3", ex);
            ex.printStackTrace();
            return null;
        }
        this.eci_ComponentName = stack_eci_ComponentName;
        return stack_eci_ComponentName;
    }

    public String getCompName_Open(InvocationData data, String stack_eci_ComponentName) {
        this.request_is_an_open = true;
        data.setComponentName(stack_eci_ComponentName);
        this.parentThread = Thread.currentThread();
        this.eci_ComponentName = stack_eci_ComponentName;
        return stack_eci_ComponentName;
    }

    public String getCompName_Close(InvocationData data, String stack_eci_ComponentName) {
        Thread curr_Thread = Thread.currentThread();
        if (curr_Thread != this.parentThread) {
            this.skip_tracing = true;
            return null;
        }
        WilyJavaGatewayTracer.set_Eci_Epi_Call_Type(new Long(0L));
        data.setComponentName(stack_eci_ComponentName);
        this.eci_ComponentName = stack_eci_ComponentName;
        return stack_eci_ComponentName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCompName_Flow(InvocationData data, Object parmObject, Class parm_Class, String parm_ClassName, String stack_eci_ComponentName, boolean is_eci_request) {
        boolean override_TLS = false;
        try {
            int i;
            this.trace_details = true;
            if (!this.tls_uses_epi) {
                int name_lng;
                Field field2;
                if (!is_eci_request) {
                    return null;
                }
                this.parentThread = Thread.currentThread();
                Field field1 = parm_Class.getDeclaredField("Server");
                if (field1 == null) {
                    return null;
                }
                this.gatewayName = (String)field1.get(parmObject);
                if (this.gatewayName == null) {
                    return null;
                }
                int url_Index = this.gatewayName.indexOf(":");
                if (url_Index > 0 && this.gatewayName.charAt(url_Index + 1) == '/') {
                    int url_End = this.gatewayName.length();
                    int port_Index = this.gatewayName.indexOf(":", url_Index + 1);
                    if (port_Index > 0 && port_Index < url_End) {
                        url_End = port_Index;
                    }
                    this.gatewayName = url_End > 0 ? this.gatewayName.substring(url_Index + 3, url_End) : this.gatewayName.substring(url_Index + 3);
                }
                if ((field2 = parm_Class.getDeclaredField("Program")) == null) {
                    return null;
                }
                this.programName = (String)field2.get(parmObject);
                if (this.programName == null) {
                    return null;
                }
                int i2 = stack_eci_ComponentName.indexOf("TCP JavaGateway");
                if (i2 <= 0) {
                    i2 = stack_eci_ComponentName.indexOf("SSL JavaGateway");
                }
                if (i2 <= 0) {
                    i2 = stack_eci_ComponentName.indexOf("Local EXCI JavaGateway");
                }
                if (i2 <= 0) {
                    if (!stack_eci_ComponentName.startsWith("Frontends|Client_to_CTG_Details|")) {
                        this.printDebugMessage("getComponentName 3a TIMING WINDOW ALERT. Ignored componentName=" + stack_eci_ComponentName + "  new i=" + i2);
                        return null;
                    }
                    i2 = 32;
                }
                if ((name_lng = this.gatewayName.length()) > i2 && i2 > 0) {
                    i2 = name_lng;
                }
                StringBuffer strBuf = null;
                if (i2 <= 0) {
                    this.printDebugMessage("getComponentName ANOMALY 6 componentName=" + stack_eci_ComponentName + "  i=" + i2 + "  name_lng=" + name_lng);
                    strBuf = new StringBuffer(stack_eci_ComponentName);
                } else {
                    strBuf = new StringBuffer(stack_eci_ComponentName.substring(0, i2));
                }
                strBuf.append(this.gatewayName);
                this.eci_GatewayName = strBuf.toString();
                strBuf.append("|");
                strBuf.append(this.programName);
                stack_eci_ComponentName = strBuf.toString();
                data.setComponentName(stack_eci_ComponentName);
                this.request_is_flow = true;
                this.needs_aggregate_counter = true;
                this.eci_ComponentName = stack_eci_ComponentName;
                return stack_eci_ComponentName;
            }
            this.request_is_flow = true;
            this.needs_aggregate_counter = true;
            if (!parm_ClassName.equals("com.ibm.ctg.client.EPIRequest")) {
                this.flow_type = 0;
                this.request_is_service_flow = true;
                this.gatewayName = "CTG_CP";
                return null;
            }
            Class[] cfr_ignored_0 = new Class[0];
            Field field2 = parm_Class.getDeclaredField("Call_Type");
            if (field2 == null) {
                return null;
            }
            Integer returnValue = (Integer)field2.get(parmObject);
            if (returnValue == null) {
                return null;
            }
            this.flow_type = returnValue;
            Field field1 = parm_Class.getDeclaredField("Server");
            if (field1 == null) {
                return null;
            }
            this.gatewayName = (String)field1.get(parmObject);
            if (this.flow_type != 7) {
                this.trace_START_details = false;
                this.request_is_service_flow = true;
                stack_eci_ComponentName = kFrontend_Aggregates_Metric_HLQ + this.str_API_Type;
                if (this.flow_type == 11 || this.flow_type == 13) {
                    Thread.currentThread();
                    this.skip_tracing = true;
                    return null;
                }
                if (override_TLS) {
                    WilyJavaGatewayTracer.set_Eci_Epi_Call_Type(new Long(this.curr_Eci_Epi_Call_value));
                }
                this.eci_ComponentName = stack_eci_ComponentName;
                return stack_eci_ComponentName;
            }
            this.parentThread = Thread.currentThread();
            this.skip_tracing = true;
            this.trace_START_details = true;
            this.needs_aggregate_counter = true;
            field1 = parm_Class.getDeclaredField("Server");
            if (field1 == null) {
                return null;
            }
            this.gatewayName = (String)field1.get(parmObject);
            field2 = parm_Class.getDeclaredField("Transid");
            if (field2 == null) {
                return null;
            }
            this.tranId = (String)field2.get(parmObject);
            String tls_tranId = WilyJavaGatewayTracer.get_epi_TranId();
            if (tls_tranId != null && tls_tranId.equals("_")) {
                this.tranId = WilyJavaGatewayTracer.get_epi_TranId();
                field2.set(parmObject, "_");
                this.skip_tracing = false;
                this.trace_START_details = false;
                this.is_CLEAR_Key = true;
                this.eci_base_name = kFrontend_Aggregates_Metric_HLQ + this.str_API_Type;
                return this.eci_base_name;
            }
            if (this.tranId == null) {
                this.tranId = WilyJavaGatewayTracer.get_epi_TranId();
                if (this.tranId == null) {
                    return null;
                }
                field2.set(parmObject, this.tranId);
            }
            if ((i = stack_eci_ComponentName.indexOf("TCP JavaGateway")) <= 0) {
                i = stack_eci_ComponentName.indexOf("SSL JavaGateway");
            }
            if (i <= 0) {
                i = stack_eci_ComponentName.indexOf("Local EXCI JavaGateway");
            }
            if (i <= 0) {
                return null;
            }
            StringBuffer strBuf = new StringBuffer(stack_eci_ComponentName.substring(0, i));
            this.eci_base_name = String.valueOf(strBuf.toString()) + this.str_API_Type;
            strBuf.append(this.gatewayName);
            this.eci_GatewayName = strBuf.toString();
            strBuf.append("|");
            strBuf.append(this.tranId);
            this.eci_ComponentName = stack_eci_ComponentName = strBuf.toString();
            return stack_eci_ComponentName;
        }
        catch (Exception ex) {
            this.printDebugMessage("getCompName_Flow exception", ex);
            ex.printStackTrace();
            return null;
        }
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        ++this.EE_COUNT;
        WilyJavaGatewayTracer.get_Eci_Epi_Call_Type();
        Thread.currentThread();
        this.parentThread = Thread.currentThread();
        data.getInvocationObject();
        this.curr_TracerIndex = tracerIndex;
        this.skip_tracing = false;
        try {
            String stack_eci_ComponentName = this.getComponentName(data);
            if (this.skip_tracing || stack_eci_ComponentName == null) {
                this.eci_ComponentName = null;
                this.skip_tracing = true;
                return;
            }
            if (stack_eci_ComponentName.startsWith("Frontends|Client_to_CTG_Details|TCP JavaGateway") || stack_eci_ComponentName.startsWith("Frontends|Client_to_CTG_Details|SSL JavaGateway") || stack_eci_ComponentName.startsWith("Frontends|Client_to_CTG_Details|Local EXCI JavaGateway")) {
                this.printDebugMessage("startTrace TIMING WINDOW ALERT-Z name=" + stack_eci_ComponentName + "  InvocationObject=" + data.getInvocationObject());
                this.eci_ComponentName = null;
                this.skip_tracing = true;
                return;
            }
            if (stack_eci_ComponentName.startsWith("Frontends|Client_to_CTG_Aggregates|XXX_XXX_CT")) {
                this.printDebugMessage("startTrace TIMING WINDOW ALERT-W name=" + stack_eci_ComponentName + "  InvocationObject=" + data.getInvocationObject());
                this.eci_ComponentName = null;
                this.skip_tracing = true;
                return;
            }
            data.setComponentNameAt(stack_eci_ComponentName, tracerIndex);
            data.setComponentName(stack_eci_ComponentName);
        }
        catch (Exception ex) {
            this.printDebugMessage("startTrace exception1", ex);
            ex.printStackTrace();
            this.eci_ComponentName = null;
            this.skip_tracing = true;
            return;
        }
        this.startTrace_Issued = false;
        data.storeWallClockStartTime();
        try {
            ++this.ACTIVE_COUNT;
            this.startTrace_Issued = true;
        }
        catch (Exception ex) {
            this.printDebugMessage("startTrace exception2", ex);
            ex.printStackTrace();
            this.eci_ComponentName = null;
            this.skip_tracing = true;
            return;
        }
        if (!this.trace_START_details) {
            this.skip_tracing = false;
        }
    }

    public void ITracer_abortTrace(int tracerIndex, InvocationData data) {
        if (this.startTrace_Issued) {
            data.getComponentNameAt(tracerIndex);
            this.startTrace_Issued = false;
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        String formattedMetricName;
        String errorMetricName;
        Object parmObject;
        --this.EE_COUNT;
        String stack_eci_ComponentName = this.eci_ComponentName;
        WilyJavaGatewayTracer.get_Eci_Epi_Call_Type();
        Thread.currentThread();
        Object invokeObject = data.getInvocationObject();
        if (this.skip_tracing || stack_eci_ComponentName == null) {
            return;
        }
        ILongIntervalCounterDataAccumulator error_Accum = null;
        if (stack_eci_ComponentName.startsWith("Frontends|Client_to_CTG_Details|TCP JavaGateway") || stack_eci_ComponentName.startsWith("Frontends|Client_to_CTG_Details|SSL JavaGateway") || stack_eci_ComponentName.startsWith("Frontends|Client_to_CTG_Details|Local EXCI JavaGateway")) {
            this.printDebugMessage("finishTrace TIMING WINDOW ALERT-B name=" + stack_eci_ComponentName + "  InvocationObject=" + invokeObject);
            return;
        }
        if (stack_eci_ComponentName.startsWith("Frontends|Client_to_CTG_Aggregates|XXX_XXX_CT")) {
            this.printDebugMessage("finishTrace TIMING WINDOW ALERT-C name=" + stack_eci_ComponentName + "  InvocationObject=" + invokeObject);
            return;
        }
        this.curr_TracerIndex = tracerIndex;
        data.setComponentNameAt(stack_eci_ComponentName, tracerIndex);
        data.setComponentName(stack_eci_ComponentName);
        if (stack_eci_ComponentName.endsWith("JCA_EPI") && this.curr_Eci_Epi_Call_value != 4L) {
            Long curr_Eci_Epi_API_Type = new Long(4L);
            WilyJavaGatewayTracer.set_Eci_Epi_Call_Type(curr_Eci_Epi_API_Type);
            this.curr_Eci_Epi_Call_value = 4L;
            this.tls_uses_epi = true;
        } else if (stack_eci_ComponentName.endsWith("CCF_EPI") && this.curr_Eci_Epi_Call_value != 5L) {
            Long curr_Eci_Epi_API_Type = new Long(5L);
            WilyJavaGatewayTracer.set_Eci_Epi_Call_Type(curr_Eci_Epi_API_Type);
            this.curr_Eci_Epi_Call_value = 5L;
            this.tls_uses_epi = true;
        }
        if (this.trace_START_details && this.tranId == null) {
            try {
                parmObject = data.getInvocationParameterAsObject(0);
                if (parmObject == null) {
                    this.ITracer_abortTrace(tracerIndex, data);
                    return;
                }
                Class<?> parm_Class = parmObject.getClass();
                if (parm_Class == null) {
                    this.ITracer_abortTrace(tracerIndex, data);
                    return;
                }
                Field field2 = parm_Class.getDeclaredField("Transid");
                if (field2 == null) {
                    this.ITracer_abortTrace(tracerIndex, data);
                    return;
                }
                this.tranId = (String)field2.get(parmObject);
                if (this.tranId == null) {
                    this.ITracer_abortTrace(tracerIndex, data);
                    return;
                }
            }
            catch (Exception ex) {
                this.printDebugMessage("finishTrace EPI Transid lookup exception", ex);
                ex.printStackTrace();
                return;
            }
        }
        this.error_detected = false;
        if (data.hasMethodResultAvailable()) {
            Integer retCode = (Integer)data.getInvocationReturnValueAsObject();
            this.cics_RetCode = retCode != null ? retCode : 0;
            if (this.request_is_flow) {
                retCode = (Integer)data.getInvocationReturnValueAsObject();
                this.cics_RetCode = retCode != null ? retCode : 0;
                if (this.cics_RetCode < 0 || this.cics_RetCode >= 3 && this.tls_uses_epi) {
                    this.error_detected = true;
                    this.cics_ErrMessage = " ";
                    try {
                        parmObject = data.getInvocationParameterAsObject(0);
                        if (parmObject == null) {
                            return;
                        }
                        Class[] paramTypes = new Class[]{};
                        Method getCicsRcMethod = parmObject.getClass().getMethod("getCicsRcString", paramTypes);
                        if (getCicsRcMethod == null) {
                            return;
                        }
                        Object returnValue = getCicsRcMethod.invoke(parmObject, null);
                        this.cics_ErrMessage = returnValue != null ? returnValue.toString() : "CICS error return code " + this.cics_RetCode;
                    }
                    catch (Exception ex) {
                        this.printDebugMessage("finishTrace getCicsRc() failed", ex);
                        ex.printStackTrace();
                        return;
                    }
                    this.err_detect_errMessage = !this.tls_uses_epi ? "Program invoke error: " + this.cics_RetCode + "  " + this.cics_ErrMessage + "  Program=" + this.programName + "  Gateway=" + this.gatewayName : (this.trace_START_details ? "Transaction invoke error: " + this.cics_RetCode + "  " + this.cics_ErrMessage + "  TranId=" + this.tranId + "  Gateway=" + this.gatewayName : "Transaction invoke error: " + this.cics_RetCode + "  " + this.cics_ErrMessage + "  Gateway=" + this.gatewayName);
                    String cfr_ignored_0 = String.valueOf(this.getFormattedResource()) + ": " + this.err_detect_errMessage;
                    errorMetricName = String.valueOf(stack_eci_ComponentName) + kErrors_per_Interval_Suffix;
                    if (ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)this.err_detect_errMessage)) {
                        this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                        try {
                            this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(errorMetricName).ILongIntervalCounterDataAccumulator_addSingleIncident();
                        }
                        catch (Exception ex) {
                            this.printDebugMessage("finishTrace exception2 Bad name", ex);
                            ex.printStackTrace();
                            return;
                        }
                    }
                }
            }
        }
        if (data.hasInvocationThrownException()) {
            this.error_detected = true;
            this.err_detect_errMessage = data.getInvocationThrownException().getMessage();
            if (this.request_is_flow) {
                this.err_detect_errMessage = String.valueOf(this.err_detect_errMessage) + "  Program=" + this.programName + "  Gateway=" + this.gatewayName;
                this.err_detect_errMessage = !this.tls_uses_epi ? String.valueOf(this.err_detect_errMessage) + "  Program=" + this.programName + "  Gateway=" + this.gatewayName : (this.trace_START_details ? String.valueOf(this.err_detect_errMessage) + "  TranId=" + this.tranId + "  Gateway=" + this.gatewayName : String.valueOf(this.err_detect_errMessage) + "  Gateway=" + this.gatewayName);
            }
            String cfr_ignored_1 = String.valueOf(this.getFormattedResource()) + ": " + this.err_detect_errMessage;
            errorMetricName = String.valueOf(stack_eci_ComponentName) + kErrors_per_Interval_Suffix;
            if (ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)this.err_detect_errMessage)) {
                this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                try {
                    this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(errorMetricName).ILongIntervalCounterDataAccumulator_addSingleIncident();
                }
                catch (Exception ex) {
                    this.printDebugMessage("finishTrace exception3 Bad name", ex);
                    ex.printStackTrace();
                    return;
                }
            }
        }
        try {
            IIntegerAverageDataAccumulator average;
            IIntegerFluctuatingCounterDataAccumulator counter;
            if (this.needs_aggregate_counter) {
                if (!this.request_is_service_flow) {
                    if (this.is_CLEAR_Key) {
                        formattedMetricName = new String(String.valueOf(this.eci_base_name) + kDetail_Aggregate_CLEAR_KEY_Count_Suffix);
                    } else {
                        if (!stack_eci_ComponentName.endsWith("BASE_ECI_EPI") && !this.request_is_service_flow) {
                            formattedMetricName = new String(String.valueOf(stack_eci_ComponentName) + kAggregate_Request_Program_Count_Suffix);
                            counter = this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(formattedMetricName);
                            counter.IIntegerFluctuatingCounterDataAccumulator_increment();
                        }
                        formattedMetricName = new String(String.valueOf(stack_eci_ComponentName) + kDetail_Aggregate_Request_Count_Suffix);
                    }
                } else {
                    formattedMetricName = new String(String.valueOf(stack_eci_ComponentName) + kDetail_Aggregate_Service_Count_Suffix);
                }
                counter = this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(formattedMetricName);
                counter.IIntegerFluctuatingCounterDataAccumulator_increment();
                this.ci_counter = null;
                formattedMetricName = new String(String.valueOf(stack_eci_ComponentName) + kResponses_per_Interval_Suffix);
                ILongIntervalCounterDataAccumulator pi_counter = this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(formattedMetricName);
                pi_counter.ILongIntervalCounterDataAccumulator_addSingleIncident();
                formattedMetricName = new String(String.valueOf(stack_eci_ComponentName) + kRspTime_Suffix);
                average = this.getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(formattedMetricName);
                average.IIntegerAggregatingDataAccumulator_recordDataPoint(data.getWallClockElapsedTimeAsInt());
                formattedMetricName = new String(String.valueOf(stack_eci_ComponentName) + kStall_Count_Suffix);
                IIntegerFluctuatingCounterDataAccumulator stall_counter = this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(formattedMetricName);
                stall_counter.IIntegerCounterDataAccumulator_setValue(0);
                if (stack_eci_ComponentName.endsWith("BASE_ECI_EPI") || this.str_API_Type.equals("|BASE_ECI_EPI")) {
                    formattedMetricName = new String(kFrontend_Aggregates_Metric_HLQ + this.str_API_Type + kResponses_per_Interval_Suffix);
                    pi_counter = this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(formattedMetricName);
                    pi_counter.ILongIntervalCounterDataAccumulator_addSingleIncident();
                    formattedMetricName = new String(kFrontend_Aggregates_Metric_HLQ + this.str_API_Type + kRspTime_Suffix);
                    average = this.getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(formattedMetricName);
                    average.IIntegerAggregatingDataAccumulator_recordDataPoint(data.getWallClockElapsedTimeAsInt());
                    formattedMetricName = new String(kFrontend_Aggregates_Metric_HLQ + this.str_API_Type + kDetail_Aggregate_Request_Count_Suffix);
                    counter = this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(formattedMetricName);
                    counter.IIntegerFluctuatingCounterDataAccumulator_increment();
                    formattedMetricName = new String(kFrontend_Aggregates_Metric_HLQ + this.str_API_Type + kErrors_per_Interval_Suffix);
                    error_Accum = this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(formattedMetricName);
                    if (this.error_detected) {
                        error_Accum.ILongIntervalCounterDataAccumulator_addSingleIncident();
                    } else {
                        error_Accum.ILongAggregatingDataAccumulator_recordDataPoint(0L);
                    }
                    formattedMetricName = new String(kFrontend_Aggregates_Metric_HLQ + this.str_API_Type + kConcurrent_Invokes_Suffix);
                    this.ci_counter = this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(formattedMetricName);
                    this.ci_counter.IIntegerCounterDataAccumulator_setValue(0);
                    this.ci_counter = null;
                }
                formattedMetricName = new String(kFrontend_Aggregates_Metric_HLQ + this.str_API_Type + kStall_Count_Suffix);
                stall_counter = this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(formattedMetricName);
                stall_counter.IIntegerCounterDataAccumulator_setValue(0);
            }
            if (this.needs_aggregate_counter && !this.is_CLEAR_Key) {
                if (this.eci_base_name.startsWith("Frontends|Client_to_CTG_Aggregates|XXX_XXX_CT")) {
                    this.printDebugMessage("finishTrace TIMING WINDOW ALERT-D name=" + this.eci_base_name + "  InvocationObject=" + invokeObject);
                    return;
                }
                formattedMetricName = !this.request_is_service_flow ? new String(kFrontend_Aggregates_Metric_HLQ + this.str_API_Type + kAggregate_Request_Program_Count_Suffix) : new String(kFrontend_Aggregates_Metric_HLQ + this.str_API_Type + kAggregate_Service_Count_Suffix);
                counter = this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(formattedMetricName);
                counter.IIntegerFluctuatingCounterDataAccumulator_increment();
            }
            if (this.request_is_an_open) {
                formattedMetricName = new String(String.valueOf(stack_eci_ComponentName) + kAggregate_Open_RspTime_Suffix);
                average = this.getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(formattedMetricName);
                average.IIntegerAggregatingDataAccumulator_recordDataPoint(data.getWallClockElapsedTimeAsInt());
                formattedMetricName = new String(String.valueOf(stack_eci_ComponentName) + kAggregate_Open_Count_Suffix);
                counter = this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(formattedMetricName);
                counter.IIntegerFluctuatingCounterDataAccumulator_increment();
            }
            if (this.error_detected) {
                formattedMetricName = new String(kFrontend_Aggregates_Metric_HLQ + this.str_API_Type + kAggregate_Error_Count_Suffix);
                counter = this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(formattedMetricName);
                counter.IIntegerFluctuatingCounterDataAccumulator_increment();
                if (this.curr_Eci_Epi_Call_value == 1L) {
                    formattedMetricName = new String("Frontends|Client_to_CTG_Aggregates|JCA_ECI:Errors Per Interval");
                    error_Accum = this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(formattedMetricName);
                    error_Accum.ILongIntervalCounterDataAccumulator_addSingleIncident();
                }
                if (this.request_is_flow && !this.trace_START_details) {
                    formattedMetricName = new String(String.valueOf(stack_eci_ComponentName) + kDetail_Aggregate_Error_Count_Suffix);
                    counter = this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(formattedMetricName);
                    counter.IIntegerFluctuatingCounterDataAccumulator_increment();
                }
                if (this.request_is_flow && this.trace_START_details) {
                    formattedMetricName = new String(String.valueOf(stack_eci_ComponentName) + kDetail_Aggregate_Error_Count_Suffix);
                    counter = this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(formattedMetricName);
                    counter.IIntegerFluctuatingCounterDataAccumulator_increment();
                }
                if (this.gatewayName != null) {
                    formattedMetricName = new String(kFrontend_Aggregates_Metric_HLQ + this.str_API_Type + "|" + this.gatewayName + kAggregate_Error_Gateway_to_CICS);
                    counter = this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(formattedMetricName);
                    counter.IIntegerFluctuatingCounterDataAccumulator_increment();
                }
            }
        }
        catch (Exception ex) {
            this.printDebugMessage("finishTrace exception4", ex);
            ex.printStackTrace();
            this.skip_tracing = true;
            return;
        }
        try {
            --this.ACTIVE_COUNT;
            if (stack_eci_ComponentName.endsWith("JCA_ECI") || stack_eci_ComponentName.endsWith("JCA_EPI") || stack_eci_ComponentName.endsWith("BASE_ECI_EPI") || stack_eci_ComponentName.endsWith("CCF_ECI") || stack_eci_ComponentName.endsWith("CCF_EPI")) {
                // empty if block
            }
            formattedMetricName = new String(String.valueOf(stack_eci_ComponentName) + kErrors_per_Interval_Suffix);
        }
        catch (Exception ex) {
            this.printDebugMessage("finishTrace exception5", ex);
            ex.printStackTrace();
            this.skip_tracing = true;
            return;
        }
    }

    public String toString() {
        return this.err_detect_errMessage;
    }

    public static Long get_Eci_Epi_Call_Type() {
        return (Long)eci_Epi_CallType.get();
    }

    public static void set_Eci_Epi_Call_Type(Long call_type) {
        eci_Epi_CallType.set(call_type);
    }

    public static String get_epi_TranId() {
        return (String)epi_TranId.get();
    }

    public static void set_epi_TranId(String tranId) {
        epi_TranId.set(tranId);
    }

    static void putConcurrentInvokes_Metric(String metric_name, Object FluctuatingCounterAccumulator) {
        concurrentDataAccumulatorTable.put(metric_name, FluctuatingCounterAccumulator);
    }

    static Object getConcurrentInvokes_Metric(String metric_name) {
        Object fluctuatingCounterAccumulator = concurrentDataAccumulatorTable.get(metric_name);
        return fluctuatingCounterAccumulator;
    }

    private void printDebugMessage(String message) {
        this.debugger.printDetail(String.valueOf(CLASS_NAME) + " : " + message);
    }

    private void printDebugMessage(String message, Exception e) {
        this.printDebugMessage(String.valueOf(message) + " : " + e.getMessage());
        e.printStackTrace();
    }
}

