/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.action;

import com.wily.org.apache.log4j.Logger;
import com.wily.properties.KUIErrorMessagesKeys;
import com.wily.ui.action.ExtendedActionException;
import com.wily.ui.action.IExtendedAction;
import com.wily.util.exception.AChainingException;
import com.wily.util.feedback.Module;
import com.wily.util.text.ILocalizableException;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.text.SimpleLocalizableMessage;
import com.wily.util.validate.ValidationException;
import com.wily.wilyassert.Assertion;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public abstract class AExtendedAction
extends AbstractAction
implements IExtendedAction,
KUIErrorMessagesKeys {
    private int fActionType;
    private boolean fTriggered;
    private boolean fUndone;
    private boolean fCancelled;
    private boolean fIsProducer;
    private boolean fIsConsumer;
    private boolean fTearDownCalled;

    public AExtendedAction(int actionType) {
        this.init(actionType);
    }

    public AExtendedAction(String name, int actionType) {
        super(name);
        this.init(actionType);
    }

    public AExtendedAction(String name, Icon icon, int actionType) {
        super(name, icon);
        this.init(actionType);
    }

    private void init(int actionType) {
        this.setActionType(actionType);
        this.setTriggered(false);
        this.setUndone(false);
        this.setCancelled(false);
        this.setIsProducer(false);
        this.setIsConsumer(false);
        this.setTearDownCalled(false);
        super.putValue("dummy", "dummy");
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        block3: {
            this.checkCanTrigger();
            try {
                this.doTriggerAction(actionEvent);
            }
            catch (ExtendedActionException ae) {
                Throwable cause = ae;
                while (cause != null && cause instanceof AChainingException) {
                    cause = ((AChainingException)cause).getCause();
                }
                if (cause instanceof ValidationException) break block3;
                Logger.getLogger((String)Module.kAction.getName()).error((Object)("Unexpected error executing extended action: " + ae), (Throwable)ae);
            }
        }
        this.setTriggeredIfNotCancelledOrTornDown();
    }

    public final void IExtendedAction_triggerAction(ActionEvent actionEvent) throws ExtendedActionException {
        this.checkTearDownNotCalled();
        this.checkCanTrigger();
        this.setCancelled(false);
        this.doTriggerAction(actionEvent);
        this.setTriggeredIfNotCancelledOrTornDown();
    }

    public final void IExtendedAction_undoAction() throws ExtendedActionException {
        this.checkTearDownNotCalled();
        this.checkCanUndo();
        this.doUndoAction();
        this.setUndone(true);
    }

    public final void IExtendedAction_redoAction() throws ExtendedActionException {
        this.checkTearDownNotCalled();
        this.checkCanRedo();
        this.doRedoAction();
    }

    protected abstract void doTriggerAction(ActionEvent var1) throws ExtendedActionException;

    protected abstract void doUndoAction() throws ExtendedActionException;

    protected abstract void doRedoAction() throws ExtendedActionException;

    public int IExtendedAction_getActionType() {
        this.checkTearDownNotCalled();
        return this.fActionType;
    }

    public boolean IExtendedAction_wasCancelled() {
        this.checkTearDownNotCalled();
        return this.fCancelled;
    }

    public String IExtendedAction_getName() {
        this.checkTearDownNotCalled();
        return (String)this.getValue("Name");
    }

    public void IExtendedAction_setName(String name) {
        this.checkTearDownNotCalled();
        this.putValue("Name", name);
    }

    public Icon IExtendedAction_getIcon() {
        this.checkTearDownNotCalled();
        return (Icon)this.getValue("SmallIcon");
    }

    public void IExtendedAction_setIcon(Icon icon) {
        this.checkTearDownNotCalled();
        this.putValue("SmallIcon", icon);
    }

    public boolean IExtendedAction_isProducer() {
        this.checkTearDownNotCalled();
        return this.fIsProducer;
    }

    public Object IExtendedAction_getProduct() throws ExtendedActionException {
        Assertion.unimplemented("IExtendedAction_getProduct not implemented for this action");
        return null;
    }

    public boolean IExtendedAction_isConsumer() {
        this.checkTearDownNotCalled();
        return this.fIsConsumer;
    }

    public void IExtendedAction_setConsumable(Object consumable) throws ExtendedActionException {
        Assertion.unimplemented("IExtendedAction_setConsumable not implemented for this action");
    }

    public final void IExtendedAction_tearDown() {
        if (!this.tearDownCalled()) {
            this.doTearDown();
            this.setTearDownCalled(true);
        }
    }

    protected void doTearDown() {
    }

    public Object clone() throws CloneNotSupportedException {
        AExtendedAction clonedExtendedAction = (AExtendedAction)super.clone();
        clonedExtendedAction.setActionType(this.IExtendedAction_getActionType());
        clonedExtendedAction.setTriggered(this.wasTriggered());
        clonedExtendedAction.setUndone(this.wasUndone());
        clonedExtendedAction.setCancelled(this.IExtendedAction_wasCancelled());
        clonedExtendedAction.setTearDownCalled(this.tearDownCalled());
        clonedExtendedAction.changeSupport = null;
        return clonedExtendedAction;
    }

    public void throwExtendedActionExceptionFromGenericException(IStringLocalizer stringLocalizer, Exception e) throws ExtendedActionException {
        ILocalizableException localizableException;
        ILocalizableMessage message;
        if (e instanceof ExtendedActionException) {
            throw new IllegalArgumentException("passed an ExtendedActionException to throwExtendedActionExceptionFromGenericException");
        }
        if (e instanceof ILocalizableException && (message = (localizableException = (ILocalizableException)((Object)e)).ILocalizableException_getLocalizableMessage()) != null) {
            throw new ExtendedActionException(this, e, e.getMessage(), message);
        }
        throw new ExtendedActionException(this, e, e.getMessage(), new SimpleLocalizableMessage("Unknown_Error"));
    }

    protected void setActionType(int actionType) {
        if (this.fActionType != actionType) {
            int oldValue = this.fActionType;
            this.fActionType = actionType;
            this.firePropertyChange("ActionType", new Integer(oldValue), new Integer(this.fActionType));
        }
    }

    protected void setIsProducer(boolean isProducer) {
        if (this.fIsProducer != isProducer) {
            boolean oldValue = this.fIsProducer;
            this.fIsProducer = isProducer;
            this.firePropertyChange("Producer", new Boolean(oldValue), new Boolean(this.fIsProducer));
        }
    }

    protected void setIsConsumer(boolean isConsumer) {
        if (this.fIsConsumer != isConsumer) {
            boolean oldValue = this.fIsConsumer;
            this.fIsConsumer = isConsumer;
            this.firePropertyChange("Consumer", new Boolean(oldValue), new Boolean(this.fIsConsumer));
        }
    }

    protected void setCancelled(boolean cancelled) {
        this.fCancelled = cancelled;
    }

    protected boolean setTriggered(boolean triggered) {
        this.fTriggered = triggered;
        return this.fTriggered;
    }

    protected void setTriggeredIfNotCancelledOrTornDown() {
        if (this.tearDownCalled()) {
            return;
        }
        this.fTriggered = !this.IExtendedAction_wasCancelled();
    }

    protected void setUndone(boolean undone) {
        this.fUndone = undone;
    }

    private void setTearDownCalled(boolean tearDownCalled) {
        this.fTearDownCalled = tearDownCalled;
    }

    private boolean wasUndone() {
        return this.fUndone;
    }

    protected boolean wasTriggered() {
        return this.fTriggered;
    }

    private boolean tearDownCalled() {
        return this.fTearDownCalled;
    }

    protected void checkCanUndo() {
        Assertion.wilyAssert(!this.IExtendedAction_wasCancelled(), "checkCanUndo(): action not canceled.");
        Assertion.wilyAssert(this.IExtendedAction_getActionType() == 1 || this.IExtendedAction_getActionType() == 3, "checkCanUndo(): wrong type. ");
        Assertion.wilyAssert(this.wasTriggered(), "checkCanUndo(): action not triggered. ");
    }

    protected void checkCanTrigger() {
    }

    protected void checkCanRedo() {
        Assertion.wilyAssert(!this.IExtendedAction_wasCancelled() && (this.IExtendedAction_getActionType() == 1 || this.IExtendedAction_getActionType() == 3) && this.wasUndone());
    }

    protected void checkTearDownNotCalled() {
        Assertion.wilyAssert(!this.tearDownCalled());
    }

    private String getTypeNameFromType(int type) {
        String result = "";
        switch (type) {
            case 0: {
                result = "One Way";
                break;
            }
            case 1: {
                result = "Two Way";
                break;
            }
            case 2: {
                result = "Destructive";
                break;
            }
            case 3: {
                result = "Undoable Edit";
                break;
            }
            default: {
                result = result + "unrecognized type!";
            }
        }
        return result;
    }

    public String toString() {
        return " name: " + (String)this.getValue("Name") + " type: " + this.getTypeNameFromType(this.fActionType) + " triggered: " + (this.fTriggered ? "yes" : "no") + " undone: " + (this.fUndone ? "yes" : "no") + " cancelled: " + (this.fCancelled ? "yes" : "no") + " producer: " + (this.fIsProducer ? "yes" : "no") + " consumer: " + (this.fIsConsumer ? "yes" : "no") + " torn down: " + (this.fTearDownCalled ? "yes" : "no") + " identity: " + System.identityHashCode(this);
    }
}

