/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import com.wily.properties.KUICommonStringsKeys;
import com.wily.ui.ExtendedPrintable;
import com.wily.ui.IGenericServices;
import com.wily.ui.OverriddenGenericServices;
import com.wily.ui.WilyUIUtilities;
import com.wily.ui.action.ADestructiveExtendedAction;
import com.wily.ui.action.ExtendedActionMonitor;
import com.wily.ui.action.IExtendedAction;
import com.wily.ui.action.TextEditActionBroker;
import com.wily.ui.image.ImageBroker;
import com.wily.ui.selection.SelectionBroker;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class ExtendedJFrame
extends JFrame
implements KUICommonStringsKeys {
    private static final long serialVersionUID = 3436715643846435744L;
    private IGenericServices fGenericServices;
    private boolean fIsPacked;

    private ExtendedJFrame() {
        Assertion.unimplemented("Must at least specify Generic Services");
    }

    public ExtendedJFrame(IGenericServices genericServices) {
        this.init(genericServices);
    }

    public ExtendedJFrame(IGenericServices genericServices, String title) {
        super(title);
        this.init(genericServices);
    }

    public ExtendedJFrame(IGenericServices genericServices, String title, String iconKey) {
        super(title);
        this.init(genericServices);
        this.setIconImageFromBrokerKey(iconKey);
    }

    private void init(IGenericServices genericServices) {
        ExtendedActionMonitor actionMonitor = new ExtendedActionMonitor(genericServices.IGenericServices_getStringLocalizer());
        SelectionBroker selectionBroker = new SelectionBroker();
        TextEditActionBroker editBroker = new TextEditActionBroker(genericServices, actionMonitor);
        this.fGenericServices = new OverriddenGenericServices(genericServices, actionMonitor, selectionBroker, editBroker);
        this.setPacked(false);
        super.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ExtendedJFrame.this.respondToCloseRequest();
            }
        });
        WilyUIUtilities.autoDeselectMenuOnWindowDeactivation(this);
        WilyUIUtilities.autoRespectComponentMinimumSize(this);
    }

    public final void setDefaultCloseOperation(int operation) {
        Assertion.unimplemented("Subclasses of ExtendedJFrame should use standardClose() and/or doRespondToCloseRequest()");
        super.setDefaultCloseOperation(0);
    }

    public IGenericServices getGenericServices() {
        return this.fGenericServices;
    }

    public IModuleFeedbackChannel getModuleFeedback() {
        return this.getGenericServices().IGenericServices_getModuleFeedback();
    }

    public IStringLocalizer getStringLocalizer() {
        return this.getGenericServices().IGenericServices_getStringLocalizer();
    }

    protected ImageBroker getImageBroker() {
        return this.getGenericServices().IGenericServices_getImageBroker();
    }

    protected void setIconImageFromBrokerKey(String key) {
        this.setIconImage(this.getImageBroker().getImage(key));
    }

    public ExtendedPrintable getExtendedPrintable() {
        return new DefaultPrintable();
    }

    public void pack() {
        super.pack();
        this.setPacked(true);
    }

    public void dispose() {
        super.dispose();
        this.setPacked(false);
    }

    private final void standardClose() {
        ExtendedActionMonitor monitor = this.fGenericServices.IGenericServices_getExtendedActionMonitor();
        monitor.tearDownActionMonitor();
        this.doStandardClose();
    }

    protected void doStandardClose() {
        this.setVisible(false);
        this.dispose();
    }

    private final void respondToCloseRequest() {
        this.doRespondToCloseRequest();
    }

    protected void doRespondToCloseRequest() {
        this.standardClose();
    }

    public final void programmaticallyRequestClose() {
        this.respondToCloseRequest();
    }

    public final void programmaticallyForceClose() {
        this.standardClose();
    }

    public final IExtendedAction getAtomicCloseAction() {
        return new CloseAction();
    }

    public final IExtendedAction getAtomicCloseAction(String localizedActionNameKey) {
        return new CloseAction(localizedActionNameKey);
    }

    public final IExtendedAction getMonitoredReportingCloseAction(JComponent parentComponent) {
        return WilyUIUtilities.makeMonitoredReportingAction(this.getAtomicCloseAction(), this.getGenericServices(), parentComponent);
    }

    public void packAndShow() {
        this.pack();
        this.show();
    }

    public void ensurePackedAndShown() {
        if (!this.isPacked()) {
            this.pack();
        }
        if (!this.isShowing()) {
            this.show();
        }
    }

    private boolean isPacked() {
        return this.fIsPacked;
    }

    private void setPacked(boolean packed) {
        this.fIsPacked = packed;
    }

    protected boolean isIconified() {
        return this.getState() == 1;
    }

    protected void programmaticallyForceIconify() {
        this.setState(1);
    }

    protected void programmaticallyForceDeiconify() {
        this.setState(0);
    }

    public void forceToFrontWithFocus() {
        if (this.isIconified()) {
            this.programmaticallyForceDeiconify();
        }
        this.toFront();
        this.requestFocus();
    }

    private class DefaultPrintable
    implements ExtendedPrintable {
        private DefaultPrintable() {
        }

        public String getPrintableName() {
            return ExtendedJFrame.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Window_Noun");
        }

        public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
            boolean wasDoubleBuffered;
            if (pi >= 1) {
                return 1;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.translate(pf.getImageableX(), pf.getImageableY());
            Container toPaint = ExtendedJFrame.this.getContentPane();
            double scale = 1.0 * pf.getImageableWidth() / (double)toPaint.getSize().width;
            g2.scale(scale, scale);
            boolean bl = wasDoubleBuffered = toPaint.isDoubleBuffered() && toPaint instanceof JComponent;
            if (wasDoubleBuffered) {
                ((JComponent)toPaint).setDoubleBuffered(false);
            }
            toPaint.paint(g2);
            if (wasDoubleBuffered) {
                ((JComponent)toPaint).setDoubleBuffered(true);
            }
            return 0;
        }
    }

    private class CloseAction
    extends ADestructiveExtendedAction {
        private static final long serialVersionUID = 9123207306354274798L;

        public CloseAction() {
            super(ExtendedJFrame.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Close"));
        }

        public CloseAction(String localizedActionNameKey) {
            super(ExtendedJFrame.this.getStringLocalizer().IStringLocalizer_getLocalizedString(localizedActionNameKey));
        }

        protected void doTriggerAction(ActionEvent actionEvent) {
            ExtendedJFrame.this.programmaticallyRequestClose();
        }
    }
}

